/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SymbolReference;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RemoveRedundantDateTrunc
extends ExpressionRewriteRuleSet {
    public RemoveRedundantDateTrunc(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        super((expression, context) -> RemoveRedundantDateTrunc.rewrite(expression, context.getSession(), plannerContext, typeAnalyzer, context.getSymbolAllocator().getTypes()));
    }

    private static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, typeAnalyzer, types), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final IrTypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        public Visitor(Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            CatalogSchemaFunctionName functionName = ResolvedFunction.extractFunctionName(node.getName());
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date_trunc")) && node.getArguments().size() == 2) {
                Slice unitValue;
                Map<NodeRef<Expression>, Type> expressionTypes = this.typeAnalyzer.getTypes(this.session, this.types, (Expression)node);
                Expression unitExpression = (Expression)node.getArguments().get(0);
                Expression argument = (Expression)node.getArguments().get(1);
                if (expressionTypes.get(NodeRef.of((Node)argument)) == DateType.DATE && expressionTypes.get(NodeRef.of((Node)unitExpression)) instanceof VarcharType && IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, unitExpression) && (unitValue = (Slice)new IrExpressionInterpreter(unitExpression, this.plannerContext, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE)) != null && "day".equals(unitValue.toStringUtf8().toLowerCase(Locale.ENGLISH))) {
                    return treeRewriter.rewrite(argument, (Object)context);
                }
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }
    }
}

