/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.PlanNodeDecorrelator;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedJoinToJoin
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation()));
    private final PlannerContext plannerContext;

    public TransformCorrelatedJoinToJoin(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((correlatedJoinNode.getType() == JoinType.INNER || correlatedJoinNode.getType() == JoinType.LEFT ? 1 : 0) != 0, (String)"correlation in %s JOIN", (Object)correlatedJoinNode.getType().name());
        PlanNode subquery = correlatedJoinNode.getSubquery();
        PlanNodeDecorrelator planNodeDecorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedNodeOptional = planNodeDecorrelator.decorrelateFilters(subquery, correlatedJoinNode.getCorrelation());
        if (decorrelatedNodeOptional.isEmpty()) {
            return Rule.Result.empty();
        }
        PlanNodeDecorrelator.DecorrelatedNode decorrelatedSubquery = decorrelatedNodeOptional.get();
        Expression filter = IrUtils.combineConjuncts(this.plannerContext.getMetadata(), decorrelatedSubquery.getCorrelatedPredicates().orElse((Expression)BooleanLiteral.TRUE_LITERAL), correlatedJoinNode.getFilter());
        return Rule.Result.ofPlanNode(new JoinNode(correlatedJoinNode.getId(), correlatedJoinNode.getType(), correlatedJoinNode.getInput(), decorrelatedSubquery.getNode(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), correlatedJoinNode.getInput().getOutputSymbols(), correlatedJoinNode.getSubquery().getOutputSymbols(), false, filter.equals((Object)BooleanLiteral.TRUE_LITERAL) ? Optional.empty() : Optional.of(filter), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty()));
    }
}

