/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.function.Function;

public final class DistinctOutputQueryUtil {
    private DistinctOutputQueryUtil() {
    }

    public static boolean isDistinct(PlanNode node) {
        return node.accept(new IsDistinctPlanVisitor(Function.identity()), null);
    }

    public static boolean isDistinct(PlanNode node, Function<PlanNode, PlanNode> lookupFunction) {
        return node.accept(new IsDistinctPlanVisitor(lookupFunction), null);
    }

    private static final class IsDistinctPlanVisitor
    extends PlanVisitor<Boolean, Void> {
        private final Function<PlanNode, PlanNode> lookupFunction;

        private IsDistinctPlanVisitor(Function<PlanNode, PlanNode> lookupFunction) {
            this.lookupFunction = lookupFunction;
        }

        @Override
        protected Boolean visitPlan(PlanNode node, Void context) {
            return false;
        }

        @Override
        public Boolean visitAggregation(AggregationNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitAssignUniqueId(AssignUniqueId node, Void context) {
            return true;
        }

        @Override
        public Boolean visitDistinctLimit(DistinctLimitNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitExcept(ExceptNode node, Void context) {
            return node.isDistinct() || this.lookupFunction.apply(node.getSources().get(0)).accept(this, null) != false;
        }

        @Override
        public Boolean visitFilter(FilterNode node, Void context) {
            return this.lookupFunction.apply(node.getSource()).accept(this, null);
        }

        @Override
        public Boolean visitIntersect(IntersectNode node, Void context) {
            return node.isDistinct() || node.getSources().stream().allMatch(source -> this.lookupFunction.apply((PlanNode)source).accept(this, null));
        }

        @Override
        public Boolean visitValues(ValuesNode node, Void context) {
            return node.getRowCount() <= 1;
        }

        @Override
        public Boolean visitLimit(LimitNode node, Void context) {
            return node.getCount() <= 1L;
        }

        @Override
        public Boolean visitTopN(TopNNode node, Void context) {
            return node.getCount() <= 1L;
        }
    }
}

