/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Row;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataQueryOptimizer
implements PlanOptimizer {
    private static final Set<CatalogSchemaFunctionName> ALLOWED_FUNCTIONS = ImmutableSet.builder().add((Object)GlobalFunctionCatalog.builtinFunctionName("max")).add((Object)GlobalFunctionCatalog.builtinFunctionName("min")).add((Object)GlobalFunctionCatalog.builtinFunctionName("approx_distinct")).build();
    private final PlannerContext plannerContext;

    public MetadataQueryOptimizer(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        if (!SystemSessionProperties.isOptimizeMetadataQueries(context.session())) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Optimizer(context.session(), this.plannerContext, context.idAllocator()), plan, null);
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final PlannerContext plannerContext;
        private final LiteralEncoder literalEncoder;

        private Optimizer(Session session, PlannerContext plannerContext, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.plannerContext = plannerContext;
            this.literalEncoder = new LiteralEncoder(plannerContext);
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                if (ALLOWED_FUNCTIONS.contains(aggregation.getResolvedFunction().getSignature().getName()) || aggregation.isDistinct()) continue;
                return context.defaultRewrite(node);
            }
            Optional<TableScanNode> result = this.findTableScan(node.getSource());
            if (result.isEmpty()) {
                return context.defaultRewrite(node);
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List<Symbol> inputs = tableScan.getOutputSymbols();
            if (inputs.isEmpty()) {
                return context.defaultRewrite(node);
            }
            for (Symbol symbol : inputs) {
                ColumnHandle column = tableScan.getAssignments().get(symbol);
                ColumnMetadata columnMetadata = this.plannerContext.getMetadata().getColumnMetadata(this.session, tableScan.getTable(), column);
                typesBuilder.put((Object)symbol, (Object)columnMetadata.getType());
                columnBuilder.put((Object)symbol, (Object)column);
            }
            ImmutableMap columns = columnBuilder.buildOrThrow();
            ImmutableMap types = typesBuilder.buildOrThrow();
            TableProperties layout = this.plannerContext.getMetadata().getTableProperties(this.session, tableScan.getTable());
            if (layout.getDiscretePredicates().isEmpty()) {
                return context.defaultRewrite(node);
            }
            DiscretePredicates predicates = layout.getDiscretePredicates().get();
            if (!predicates.getColumns().containsAll(columns.values())) {
                return context.defaultRewrite(node);
            }
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (TupleDomain domain : predicates.getPredicates()) {
                if (domain.isNone()) continue;
                Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (Symbol input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    Type type = (Type)types.get(input);
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite(node);
                    }
                    rowBuilder.add((Object)this.literalEncoder.toExpression(value.getValue(), type));
                }
                rowsBuilder.add((Object)new Row((List)rowBuilder.build()));
            }
            ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), inputs, (List<Expression>)rowsBuilder.build());
            return SimplePlanRewriter.rewriteWith(new Replacer(valuesNode), node);
        }

        private Optional<TableScanNode> findTableScan(PlanNode source) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all(project.getAssignments().getExpressions(), expression -> DeterminismEvaluator.isDeterministic(expression, this.plannerContext.getMetadata()))) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)source;
                return Optional.of(tableScanNode);
            }
            return Optional.empty();
        }
    }

    private static class Replacer
    extends SimplePlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }
}

