/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.trino.Session;
import io.trino.connector.ConnectorName;
import io.trino.execution.TableInfo;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TableInfoSupplier
implements Function<TableScanNode, TableInfo> {
    private final Metadata metadata;
    private final Session session;

    public TableInfoSupplier(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public TableInfo apply(TableScanNode node) {
        CatalogSchemaTableName tableName = this.metadata.getTableName(this.session, node.getTable());
        TableProperties tableProperties = this.metadata.getTableProperties(this.session, node.getTable());
        Optional<String> connectorName = this.metadata.listCatalogs(this.session).stream().filter(catalogInfo -> catalogInfo.getCatalogName().equals(tableName.getCatalogName())).map(CatalogInfo::getConnectorName).map(ConnectorName::toString).findFirst();
        QualifiedObjectName objectName = new QualifiedObjectName(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName());
        return new TableInfo(connectorName, objectName, tableProperties.getPredicate());
    }
}

