/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class AggregationValuePointer
implements ValuePointer {
    private final ResolvedFunction function;
    private final AggregatedSetDescriptor setDescriptor;
    private final List<Expression> arguments;
    private final Optional<Symbol> classifierSymbol;
    private final Optional<Symbol> matchNumberSymbol;

    @JsonCreator
    public AggregationValuePointer(ResolvedFunction function, AggregatedSetDescriptor setDescriptor, List<Expression> arguments, Optional<Symbol> classifierSymbol, Optional<Symbol> matchNumberSymbol) {
        this.function = Objects.requireNonNull(function, "function is null");
        this.setDescriptor = Objects.requireNonNull(setDescriptor, "setDescriptor is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.classifierSymbol = Objects.requireNonNull(classifierSymbol, "classifierSymbol is null");
        this.matchNumberSymbol = Objects.requireNonNull(matchNumberSymbol, "matchNumberSymbol is null");
    }

    @JsonProperty
    public ResolvedFunction getFunction() {
        return this.function;
    }

    @JsonProperty
    public AggregatedSetDescriptor getSetDescriptor() {
        return this.setDescriptor;
    }

    @JsonProperty
    public List<Expression> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public Optional<Symbol> getClassifierSymbol() {
        return this.classifierSymbol;
    }

    @JsonProperty
    public Optional<Symbol> getMatchNumberSymbol() {
        return this.matchNumberSymbol;
    }

    public List<Symbol> getInputSymbols() {
        return (List)this.arguments.stream().map(SymbolsExtractor::extractAll).flatMap(Collection::stream).filter(symbol -> !(!this.classifierSymbol.isEmpty() && this.classifierSymbol.get().equals(symbol) || !this.matchNumberSymbol.isEmpty() && this.matchNumberSymbol.get().equals(symbol))).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationValuePointer o = (AggregationValuePointer)obj;
        return Objects.equals(this.function, o.function) && Objects.equals(this.setDescriptor, o.setDescriptor) && Objects.equals(this.arguments, o.arguments) && Objects.equals(this.classifierSymbol, o.classifierSymbol) && Objects.equals(this.matchNumberSymbol, o.matchNumberSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.setDescriptor, this.arguments, this.classifierSymbol, this.matchNumberSymbol);
    }
}

