/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ExpressionAndValuePointers {
    public static final ExpressionAndValuePointers TRUE = new ExpressionAndValuePointers((Expression)BooleanLiteral.TRUE_LITERAL, (List<Assignment>)ImmutableList.of());
    private final Expression expression;
    private final List<Assignment> assignments;

    @JsonCreator
    public ExpressionAndValuePointers(Expression expression, List<Assignment> assignments) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.assignments = ImmutableList.copyOf(assignments);
    }

    @JsonProperty
    public Expression getExpression() {
        return this.expression;
    }

    @JsonProperty
    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public List<Symbol> getInputSymbols() {
        Set localInputs = (Set)this.assignments.stream().filter(assignment -> assignment.valuePointer() instanceof ClassifierValuePointer || assignment.valuePointer() instanceof MatchNumberValuePointer).map(Assignment::symbol).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder inputSymbols = ImmutableList.builder();
        block4: for (Assignment assignment2 : this.assignments) {
            ValuePointer valuePointer;
            Objects.requireNonNull(assignment2.valuePointer());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ScalarValuePointer.class, AggregationValuePointer.class}, (Object)valuePointer, n)) {
                case 0: {
                    ScalarValuePointer pointer = (ScalarValuePointer)valuePointer;
                    Symbol symbol2 = pointer.getInputSymbol();
                    if (localInputs.contains(symbol2)) continue block4;
                    inputSymbols.add((Object)symbol2);
                    break;
                }
                case 1: {
                    AggregationValuePointer pointer = (AggregationValuePointer)valuePointer;
                    inputSymbols.addAll((Iterable)pointer.getInputSymbols().stream().filter(symbol -> !localInputs.contains(symbol)).collect(Collectors.toList()));
                    break;
                }
            }
        }
        return inputSymbols.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionAndValuePointers o = (ExpressionAndValuePointers)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.assignments, o.assignments);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.assignments);
    }

    public record Assignment(Symbol symbol, ValuePointer valuePointer) {
    }
}

