/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Verify;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.BigintOperators;
import io.trino.type.BooleanOperators;
import io.trino.type.DateTimes;
import io.trino.type.DoubleOperators;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.type.VarcharOperators;
import io.trino.util.DateTimeUtils;
import io.trino.util.JsonCastException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public final class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPED_UNORDERED = new ObjectMapper(JsonUtil.createJsonFactory());
    private static final int MAX_JSON_LENGTH_IN_ERROR_MESSAGE = 10000;

    private JsonUtil() {
    }

    public static JsonFactory createJsonFactory() {
        return ((JsonFactoryBuilder)JsonUtils.jsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build();
    }

    public static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }

    public static JsonGenerator createJsonGenerator(JsonFactory factory, SliceOutput output) throws IOException {
        return factory.createGenerator((OutputStream)output);
    }

    public static String truncateIfNecessaryForErrorMessage(Slice json) {
        if (json.length() <= 10000) {
            return json.toStringUtf8();
        }
        return json.slice(0, 10000).toStringUtf8() + "...(truncated)";
    }

    public static boolean canCastToJson(Type type) {
        if (type instanceof UnknownType || type instanceof BooleanType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof RealType || type instanceof DoubleType || type instanceof DecimalType || type instanceof VarcharType || type instanceof JsonType || type instanceof TimestampType || type instanceof DateType) {
            return true;
        }
        if (type instanceof ArrayType) {
            return JsonUtil.canCastToJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return (mapType.getKeyType() instanceof UnknownType || JsonUtil.isValidJsonObjectKeyType(mapType.getKeyType())) && JsonUtil.canCastToJson(mapType.getValueType());
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(JsonUtil::canCastToJson);
        }
        return false;
    }

    public static boolean canCastFromJson(Type type) {
        if (type instanceof BooleanType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof RealType || type instanceof DoubleType || type instanceof DecimalType || type instanceof VarcharType || type instanceof JsonType) {
            return true;
        }
        if (type instanceof ArrayType) {
            return JsonUtil.canCastFromJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return JsonUtil.isValidJsonObjectKeyType(((MapType)type).getKeyType()) && JsonUtil.canCastFromJson(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(JsonUtil::canCastFromJson);
        }
        return false;
    }

    private static boolean isValidJsonObjectKeyType(Type type) {
        return type instanceof BooleanType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof RealType || type instanceof DoubleType || type instanceof DecimalType || type instanceof VarcharType;
    }

    public static Slice currentTokenAsVarchar(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return Slices.utf8Slice((String)parser.getText());
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToVarchar(Integer.MAX_VALUE, parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Slices.utf8Slice((String)parser.getText());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToVarchar(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToVarchar(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "varchar", parser.getText()));
    }

    public static Long currentTokenAsBigint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToBigint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToLong(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return parser.getLongValue();
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToBigint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToBigint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "bigint", parser.getText()));
    }

    public static Long currentTokenAsInteger(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToInteger(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToInteger(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Math.toIntExact(parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToInteger(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToInteger(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "integer", parser.getText()));
    }

    public static Long currentTokenAsSmallint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToSmallint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToSmallint(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return Shorts.checkedCast((long)parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToSmallint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToSmallint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "smallint", parser.getText()));
    }

    public static Long currentTokenAsTinyint(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToTinyint(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToTinyint(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return SignedBytes.checkedCast((long)parser.getLongValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToTinyint(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToTinyint(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "tinyint", parser.getText()));
    }

    public static Double currentTokenAsDouble(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToDouble(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return parser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToDouble(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToDouble(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "double", parser.getText()));
    }

    public static Long currentTokenAsReal(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToFloat(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return Float.floatToRawIntBits(parser.getFloatValue());
            }
            case VALUE_NUMBER_INT: {
                return Float.floatToRawIntBits(parser.getFloatValue());
            }
            case VALUE_TRUE: {
                return BooleanOperators.castToReal(true);
            }
            case VALUE_FALSE: {
                return BooleanOperators.castToReal(false);
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "real", parser.getText()));
    }

    public static Boolean currentTokenAsBoolean(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                return VarcharOperators.castToBoolean(Slices.utf8Slice((String)parser.getText()));
            }
            case VALUE_NUMBER_FLOAT: {
                return DoubleOperators.castToBoolean(parser.getDoubleValue());
            }
            case VALUE_NUMBER_INT: {
                return BigintOperators.castToBoolean(parser.getLongValue());
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
        }
        throw new JsonCastException(String.format("Unexpected token when cast to %s: %s", "boolean", parser.getText()));
    }

    public static Long currentTokenAsShortDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal bigDecimal = JsonUtil.currentTokenAsJavaDecimal(parser, precision, scale);
        return bigDecimal != null ? Long.valueOf(bigDecimal.unscaledValue().longValue()) : null;
    }

    public static Int128 currentTokenAsLongDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal bigDecimal = JsonUtil.currentTokenAsJavaDecimal(parser, precision, scale);
        if (bigDecimal == null) {
            return null;
        }
        return Int128.valueOf((BigInteger)bigDecimal.unscaledValue());
    }

    private static BigDecimal currentTokenAsJavaDecimal(JsonParser parser, int precision, int scale) throws IOException {
        BigDecimal result;
        switch (parser.getCurrentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: 
            case FIELD_NAME: {
                result = new BigDecimal(parser.getText());
                result = result.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                result = parser.getDecimalValue();
                result = result.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_TRUE: {
                result = BigDecimal.ONE.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            case VALUE_FALSE: {
                result = BigDecimal.ZERO.setScale(scale, RoundingMode.HALF_UP);
                break;
            }
            default: {
                throw new JsonCastException(String.format("Unexpected token when cast to DECIMAL(%s,%s): %s", precision, scale, parser.getText()));
            }
        }
        if (result.precision() > precision) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast input json to DECIMAL(%s,%s)", precision, scale));
        }
        return result;
    }

    public static Optional<Map<String, Integer>> getFieldNameToIndex(List<RowType.Field> rowFields) {
        if (rowFields.get(0).getName().isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, Integer> fieldNameToIndex = new HashMap<String, Integer>(rowFields.size());
        for (int i = 0; i < rowFields.size(); ++i) {
            fieldNameToIndex.put((String)rowFields.get(i).getName().get(), i);
        }
        return Optional.of(fieldNameToIndex);
    }

    private static void parseJsonToSingleRowBlock(JsonParser parser, List<BlockBuilder> fieldBuilders, BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex) throws IOException {
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            for (int i = 0; i < fieldAppenders.length; ++i) {
                parser.nextToken();
                fieldAppenders[i].append(parser, fieldBuilders.get(i));
            }
            if (parser.nextToken() != JsonToken.END_ARRAY) {
                throw new JsonCastException(String.format("Expected json array ending, but got %s", parser.getText()));
            }
        } else {
            Verify.verify((parser.getCurrentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0);
            if (fieldNameToIndex.isEmpty()) {
                throw new JsonCastException("Cannot cast a JSON object to anonymous row type. Input must be a JSON array.");
            }
            boolean[] fieldWritten = new boolean[fieldAppenders.length];
            int numFieldsWritten = 0;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.currentToken() != JsonToken.FIELD_NAME) {
                    throw new JsonCastException(String.format("Expected a json field name, but got %s", parser.getText()));
                }
                String fieldName = parser.getText().toLowerCase(Locale.ENGLISH);
                Integer fieldIndex = fieldNameToIndex.get().get(fieldName);
                parser.nextToken();
                if (fieldIndex != null) {
                    if (fieldWritten[fieldIndex]) {
                        throw new JsonCastException("Duplicate field: " + fieldName);
                    }
                    fieldWritten[fieldIndex.intValue()] = true;
                    ++numFieldsWritten;
                    fieldAppenders[fieldIndex].append(parser, fieldBuilders.get(fieldIndex));
                    continue;
                }
                parser.skipChildren();
            }
            if (numFieldsWritten != fieldAppenders.length) {
                for (int i = 0; i < fieldWritten.length; ++i) {
                    if (fieldWritten[i]) continue;
                    fieldBuilders.get(i).appendNull();
                }
            }
        }
    }

    public static interface BlockBuilderAppender {
        public void append(JsonParser var1, BlockBuilder var2) throws IOException;

        public static BlockBuilderAppender createBlockBuilderAppender(Type type) {
            if (type instanceof BooleanType) {
                return new BooleanBlockBuilderAppender();
            }
            if (type instanceof TinyintType) {
                return new TinyintBlockBuilderAppender();
            }
            if (type instanceof SmallintType) {
                return new SmallintBlockBuilderAppender();
            }
            if (type instanceof IntegerType) {
                return new IntegerBlockBuilderAppender();
            }
            if (type instanceof BigintType) {
                return new BigintBlockBuilderAppender();
            }
            if (type instanceof RealType) {
                return new RealBlockBuilderAppender();
            }
            if (type instanceof DoubleType) {
                return new DoubleBlockBuilderAppender();
            }
            if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                if (decimalType.isShort()) {
                    return new ShortDecimalBlockBuilderAppender(decimalType);
                }
                return new LongDecimalBlockBuilderAppender(decimalType);
            }
            if (type instanceof VarcharType) {
                return new VarcharBlockBuilderAppender(type);
            }
            if (type instanceof JsonType) {
                return (parser, blockBuilder) -> {
                    String json = OBJECT_MAPPED_UNORDERED.writeValueAsString((Object)parser.readValueAsTree());
                    JsonType.JSON.writeSlice(blockBuilder, Slices.utf8Slice((String)json));
                };
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return new ArrayBlockBuilderAppender(BlockBuilderAppender.createBlockBuilderAppender(arrayType.getElementType()));
            }
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                return new MapBlockBuilderAppender(BlockBuilderAppender.createBlockBuilderAppender(mapType.getKeyType()), BlockBuilderAppender.createBlockBuilderAppender(mapType.getValueType()));
            }
            if (type instanceof RowType) {
                RowType rowType = (RowType)type;
                List rowFields = rowType.getFields();
                BlockBuilderAppender[] fieldAppenders = new BlockBuilderAppender[rowFields.size()];
                for (int i = 0; i < fieldAppenders.length; ++i) {
                    fieldAppenders[i] = BlockBuilderAppender.createBlockBuilderAppender(((RowType.Field)rowFields.get(i)).getType());
                }
                return new RowBlockBuilderAppender(fieldAppenders, JsonUtil.getFieldNameToIndex(rowFields));
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }

    private static class RowBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender[] fieldAppenders;
        final Optional<Map<String, Integer>> fieldNameToIndex;

        RowBlockBuilderAppender(BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex) {
            this.fieldAppenders = fieldAppenders;
            this.fieldNameToIndex = fieldNameToIndex;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_ARRAY && parser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json array or object, but got %s", parser.getText()));
            }
            ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> JsonUtil.parseJsonToSingleRowBlock(parser, fieldBuilders, this.fieldAppenders, this.fieldNameToIndex));
        }
    }

    private static class MapBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender keyAppender;
        final BlockBuilderAppender valueAppender;

        MapBlockBuilderAppender(BlockBuilderAppender keyAppender, BlockBuilderAppender valueAppender) {
            this.keyAppender = keyAppender;
            this.valueAppender = valueAppender;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json object, but got %s", parser.getText()));
            }
            MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)blockBuilder;
            mapBlockBuilder.strict();
            try {
                mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> this.appendMap(parser, keyBuilder, valueBuilder));
            }
            catch (DuplicateMapKeyException e) {
                throw new JsonCastException("Duplicate keys are not allowed");
            }
        }

        private void appendMap(JsonParser parser, BlockBuilder keyBuilder, BlockBuilder valueBuilder) throws IOException {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                this.keyAppender.append(parser, keyBuilder);
                parser.nextToken();
                this.valueAppender.append(parser, valueBuilder);
            }
        }
    }

    private static class ArrayBlockBuilderAppender
    implements BlockBuilderAppender {
        final BlockBuilderAppender elementAppender;

        ArrayBlockBuilderAppender(BlockBuilderAppender elementAppender) {
            this.elementAppender = elementAppender;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                blockBuilder.appendNull();
                return;
            }
            if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
                throw new JsonCastException(String.format("Expected a json array, but got %s", parser.getText()));
            }
            ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.elementAppender.append(parser, elementBuilder);
                }
            });
        }
    }

    private static class VarcharBlockBuilderAppender
    implements BlockBuilderAppender {
        final Type type;

        VarcharBlockBuilderAppender(Type type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Slice result = JsonUtil.currentTokenAsVarchar(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeSlice(blockBuilder, result);
            }
        }
    }

    private static class LongDecimalBlockBuilderAppender
    implements BlockBuilderAppender {
        final DecimalType type;

        LongDecimalBlockBuilderAppender(DecimalType type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Int128 result = JsonUtil.currentTokenAsLongDecimal(parser, this.type.getPrecision(), this.type.getScale());
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeObject(blockBuilder, (Object)result);
            }
        }
    }

    private static class ShortDecimalBlockBuilderAppender
    implements BlockBuilderAppender {
        final DecimalType type;

        ShortDecimalBlockBuilderAppender(DecimalType type) {
            this.type = type;
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsShortDecimal(parser, this.type.getPrecision(), this.type.getScale());
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                this.type.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class DoubleBlockBuilderAppender
    implements BlockBuilderAppender {
        private DoubleBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Double result = JsonUtil.currentTokenAsDouble(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(blockBuilder, result.doubleValue());
            }
        }
    }

    private static class RealBlockBuilderAppender
    implements BlockBuilderAppender {
        private RealBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsReal(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                RealType.REAL.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class BigintBlockBuilderAppender
    implements BlockBuilderAppender {
        private BigintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsBigint(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class IntegerBlockBuilderAppender
    implements BlockBuilderAppender {
        private IntegerBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsInteger(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                IntegerType.INTEGER.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class SmallintBlockBuilderAppender
    implements BlockBuilderAppender {
        private SmallintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsInteger(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                SmallintType.SMALLINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class TinyintBlockBuilderAppender
    implements BlockBuilderAppender {
        private TinyintBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Long result = JsonUtil.currentTokenAsTinyint(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                TinyintType.TINYINT.writeLong(blockBuilder, result.longValue());
            }
        }
    }

    private static class BooleanBlockBuilderAppender
    implements BlockBuilderAppender {
        private BooleanBlockBuilderAppender() {
        }

        @Override
        public void append(JsonParser parser, BlockBuilder blockBuilder) throws IOException {
            Boolean result = JsonUtil.currentTokenAsBoolean(parser);
            if (result == null) {
                blockBuilder.appendNull();
            } else {
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, result.booleanValue());
            }
        }
    }

    private static class RowJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final RowType type;
        private final List<JsonGeneratorWriter> fieldWriters;

        public RowJsonGeneratorWriter(RowType type, List<JsonGeneratorWriter> fieldWriters) {
            this.type = type;
            this.fieldWriters = fieldWriters;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                SqlRow sqlRow = this.type.getObject(block, position);
                int rawIndex = sqlRow.getRawIndex();
                List typeSignatureParameters = this.type.getTypeSignature().getParameters();
                jsonGenerator.writeStartObject();
                for (int i = 0; i < sqlRow.getFieldCount(); ++i) {
                    jsonGenerator.writeFieldName(((TypeSignatureParameter)typeSignatureParameters.get(i)).getNamedTypeSignature().getName().orElse(""));
                    this.fieldWriters.get(i).writeJsonValue(jsonGenerator, sqlRow.getRawFieldBlock(i), rawIndex);
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    private static class MapJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final MapType type;
        private final ObjectKeyProvider keyProvider;
        private final JsonGeneratorWriter valueWriter;

        public MapJsonGeneratorWriter(MapType type, ObjectKeyProvider keyProvider, JsonGeneratorWriter valueWriter) {
            this.type = type;
            this.keyProvider = keyProvider;
            this.valueWriter = valueWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                SqlMap sqlMap = this.type.getObject(block, position);
                int rawOffset = sqlMap.getRawOffset();
                Block rawKeyBlock = sqlMap.getRawKeyBlock();
                Block rawValueBlock = sqlMap.getRawValueBlock();
                TreeMap<String, Integer> orderedKeyToValuePosition = new TreeMap<String, Integer>();
                for (int i = 0; i < sqlMap.getSize(); ++i) {
                    String objectKey = this.keyProvider.getObjectKey(rawKeyBlock, rawOffset + i);
                    orderedKeyToValuePosition.put(objectKey, i);
                }
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : orderedKeyToValuePosition.entrySet()) {
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    this.valueWriter.writeJsonValue(jsonGenerator, rawValueBlock, rawOffset + (Integer)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    private static class ArrayJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final ArrayType type;
        private final JsonGeneratorWriter elementWriter;

        public ArrayJsonGeneratorWriter(ArrayType type, JsonGeneratorWriter elementWriter) {
            this.type = type;
            this.elementWriter = elementWriter;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Block arrayBlock = this.type.getObject(block, position);
                jsonGenerator.writeStartArray();
                for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                    this.elementWriter.writeJsonValue(jsonGenerator, arrayBlock, i);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static class DateGeneratorWriter
    implements JsonGeneratorWriter {
        private DateGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                int value = DateType.DATE.getInt(block, position);
                jsonGenerator.writeString(DateTimeUtils.printDate(value));
            }
        }
    }

    private static class TimestampJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final TimestampType type;

        public TimestampJsonGeneratorWriter(TimestampType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                int fraction;
                long epochMicros;
                if (this.type.isShort()) {
                    epochMicros = this.type.getLong(block, position);
                    fraction = 0;
                } else {
                    LongTimestamp timestamp = (LongTimestamp)this.type.getObject(block, position);
                    epochMicros = timestamp.getEpochMicros();
                    fraction = timestamp.getPicosOfMicro();
                }
                jsonGenerator.writeString(DateTimes.formatTimestamp(this.type.getPrecision(), epochMicros, fraction, ZoneOffset.UTC));
            }
        }
    }

    private static class JsonJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private JsonJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = JsonType.JSON.getSlice(block, position);
                jsonGenerator.writeRawValue(value.toStringUtf8());
            }
        }
    }

    private static class VarcharJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public VarcharJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                Slice value = this.type.getSlice(block, position);
                jsonGenerator.writeString(value.toStringUtf8());
            }
        }
    }

    private static class LongDecimalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public LongDecimalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = new BigDecimal(((Int128)this.type.getObject(block, position)).toBigInteger(), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class ShortDecimalJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final DecimalType type;

        public ShortDecimalJsonGeneratorWriter(DecimalType type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                BigDecimal value = BigDecimal.valueOf(this.type.getLong(block, position), this.type.getScale());
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class DoubleJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private DoubleJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                double value = DoubleType.DOUBLE.getDouble(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class RealJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private RealJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                float value = RealType.REAL.getFloat(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class LongJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private final Type type;

        public LongJsonGeneratorWriter(Type type) {
            this.type = type;
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                long value = this.type.getLong(block, position);
                jsonGenerator.writeNumber(value);
            }
        }
    }

    private static class BooleanJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private BooleanJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                jsonGenerator.writeNull();
            } else {
                boolean value = BooleanType.BOOLEAN.getBoolean(block, position);
                jsonGenerator.writeBoolean(value);
            }
        }
    }

    private static class UnknownJsonGeneratorWriter
    implements JsonGeneratorWriter {
        private UnknownJsonGeneratorWriter() {
        }

        @Override
        public void writeJsonValue(JsonGenerator jsonGenerator, Block block, int position) throws IOException {
            jsonGenerator.writeNull();
        }
    }

    public static interface JsonGeneratorWriter {
        public void writeJsonValue(JsonGenerator var1, Block var2, int var3) throws IOException;

        public static JsonGeneratorWriter createJsonGeneratorWriter(Type type) {
            if (type instanceof UnknownType) {
                return new UnknownJsonGeneratorWriter();
            }
            if (type instanceof BooleanType) {
                return new BooleanJsonGeneratorWriter();
            }
            if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType) {
                return new LongJsonGeneratorWriter(type);
            }
            if (type instanceof RealType) {
                return new RealJsonGeneratorWriter();
            }
            if (type instanceof DoubleType) {
                return new DoubleJsonGeneratorWriter();
            }
            if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                if (decimalType.isShort()) {
                    return new ShortDecimalJsonGeneratorWriter(decimalType);
                }
                return new LongDecimalJsonGeneratorWriter(decimalType);
            }
            if (type instanceof VarcharType) {
                return new VarcharJsonGeneratorWriter(type);
            }
            if (type instanceof JsonType) {
                return new JsonJsonGeneratorWriter();
            }
            if (type instanceof TimestampType) {
                TimestampType timestampType = (TimestampType)type;
                return new TimestampJsonGeneratorWriter(timestampType);
            }
            if (type instanceof DateType) {
                return new DateGeneratorWriter();
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return new ArrayJsonGeneratorWriter(arrayType, JsonGeneratorWriter.createJsonGeneratorWriter(arrayType.getElementType()));
            }
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                return new MapJsonGeneratorWriter(mapType, ObjectKeyProvider.createObjectKeyProvider(mapType.getKeyType()), JsonGeneratorWriter.createJsonGeneratorWriter(mapType.getValueType()));
            }
            if (type instanceof RowType) {
                RowType rowType = (RowType)type;
                List fieldTypes = type.getTypeParameters();
                ArrayList<JsonGeneratorWriter> fieldWriters = new ArrayList<JsonGeneratorWriter>(fieldTypes.size());
                for (int i = 0; i < fieldTypes.size(); ++i) {
                    fieldWriters.add(JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i)));
                }
                return new RowJsonGeneratorWriter(rowType, fieldWriters);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }

    public static interface ObjectKeyProvider {
        public String getObjectKey(Block var1, int var2);

        public static ObjectKeyProvider createObjectKeyProvider(Type type) {
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                return (block, position) -> null;
            }
            if (type.equals((Object)BooleanType.BOOLEAN)) {
                return (block, position) -> BooleanType.BOOLEAN.getBoolean(block, position) ? "true" : "false";
            }
            if (type.equals((Object)TinyintType.TINYINT)) {
                return (block, position) -> String.valueOf(TinyintType.TINYINT.getByte(block, position));
            }
            if (type.equals((Object)SmallintType.SMALLINT)) {
                return (block, position) -> String.valueOf(SmallintType.SMALLINT.getShort(block, position));
            }
            if (type.equals((Object)IntegerType.INTEGER)) {
                return (block, position) -> String.valueOf(IntegerType.INTEGER.getInt(block, position));
            }
            if (type.equals((Object)BigintType.BIGINT)) {
                return (block, position) -> String.valueOf(BigintType.BIGINT.getLong(block, position));
            }
            if (type.equals((Object)RealType.REAL)) {
                return (block, position) -> String.valueOf(RealType.REAL.getFloat(block, position));
            }
            if (type.equals((Object)DoubleType.DOUBLE)) {
                return (block, position) -> String.valueOf(DoubleType.DOUBLE.getDouble(block, position));
            }
            if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                if (decimalType.isShort()) {
                    return (block, position) -> Decimals.toString((long)decimalType.getLong(block, position), (int)decimalType.getScale());
                }
                return (block, position) -> Decimals.toString((BigInteger)((Int128)decimalType.getObject(block, position)).toBigInteger(), (int)decimalType.getScale());
            }
            if (type instanceof VarcharType) {
                VarcharType varcharType = (VarcharType)type;
                return (block, position) -> varcharType.getSlice(block, position).toStringUtf8();
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type: %s", type));
        }
    }
}

