/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.SymbolStatsAssertion;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.JsonType;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;

public class TestFilterStatsCalculator {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final VarcharType MEDIUM_VARCHAR_TYPE = VarcharType.createVarcharType((int)100);
    private final SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
    private final SymbolStatsEstimate yStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
    private final SymbolStatsEstimate zStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate leftOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate rightOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate unknownRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate emptyRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(Double.NaN).build();
    private final SymbolStatsEstimate mediumVarcharStats = SymbolStatsEstimate.builder().setAverageRowSize(85.0).setDistinctValuesCount(165.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.34).build();
    private final FilterStatsCalculator statsCalculator = new FilterStatsCalculator(PLANNER_CONTEXT, new ScalarStatsCalculator(PLANNER_CONTEXT, new IrTypeAnalyzer(PLANNER_CONTEXT)), new StatsNormalizer(), new IrTypeAnalyzer(PLANNER_CONTEXT));
    private final PlanNodeStatsEstimate standardInputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), this.xStats).addSymbolStatistics(new Symbol("y"), this.yStats).addSymbolStatistics(new Symbol("z"), this.zStats).addSymbolStatistics(new Symbol("leftOpen"), this.leftOpenStats).addSymbolStatistics(new Symbol("rightOpen"), this.rightOpenStats).addSymbolStatistics(new Symbol("unknownRange"), this.unknownRangeStats).addSymbolStatistics(new Symbol("emptyRange"), this.emptyRangeStats).addSymbolStatistics(new Symbol("mediumVarchar"), this.mediumVarcharStats).setOutputRowCount(1000.0).build();
    private final PlanNodeStatsEstimate zeroStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("y"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("z"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("leftOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("rightOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("unknownRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("emptyRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("mediumVarchar"), SymbolStatsEstimate.zero()).setOutputRowCount(0.0).build();
    private final TypeProvider standardTypes = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("x"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("y"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("z"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("leftOpen"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("rightOpen"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("unknownRange"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("emptyRange"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("mediumVarchar"), (Object)MEDIUM_VARCHAR_TYPE).buildOrThrow());
    private final Session session = TestingSession.testSessionBuilder().build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction JSON_ARRAY_CONTAINS = FUNCTIONS.resolveFunction("json_array_contains", TypeSignatureProvider.fromTypes((Type[])new Type[]{JsonType.JSON, DoubleType.DOUBLE}));
    private static final ResolvedFunction SIN = FUNCTIONS.resolveFunction("sin", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));

    @Test
    public void testBooleanLiteralStats() {
        this.assertExpression((Expression)BooleanLiteral.TRUE_LITERAL).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)BooleanLiteral.FALSE_LITERAL).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN)).equalTo(this.zeroStatistics);
    }

    @Test
    public void testComparison() {
        double lessThan3Rows = 487.5;
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(3.0))).outputRowsCount(lessThan3Rows).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(3.0).distinctValuesCount(26.0).nullsFraction(0.0));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("x")), (Expression)new DoubleLiteral(-3.0))).outputRowsCount(lessThan3Rows);
        for (Expression minusThree : ImmutableList.of((Object)new DecimalLiteral("-3"), (Object)new DoubleLiteral(-3.0), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new DoubleLiteral(4.0), (Expression)new DoubleLiteral(7.0)), (Object)new Cast((Expression)new LongLiteral(-3L), (Type)DecimalType.createDecimalType((int)7, (int)3)))) {
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(18.75).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE), (Expression)new SymbolReference("x"))).outputRowsCount(18.75).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new NullLiteral(), (Type)DoubleType.DOUBLE)), (Expression)new SymbolReference("x"), new Expression[0]), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(18.75).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(262.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE), (Expression)new SymbolReference("x"))).outputRowsCount(262.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
        }
    }

    @Test
    public void testInequalityComparisonApproximation() {
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("emptyRange"))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(20L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(20L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(25L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(25L)))).outputRowsCount(0.0);
        double nullsFractionY = 0.5;
        double inputRowCount = this.standardInputStatistics.getOutputRowCount();
        double nonNullRowCount = inputRowCount * (1.0 - nullsFractionY);
        SymbolStatsEstimate nonNullStatsX = this.xStats.mapNullsFraction(nullsFraction -> 0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(25L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(25L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(20L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(20L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
    }

    @Test
    public void testOrStats() {
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-7.5"))))).outputRowsCount(375.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-7.5"))))).outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(3.0))))).outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("a"), (Expression)new StringLiteral("b")), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(3.0))))).outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0)), (Object)new InPredicate((Expression)new Cast((Expression)new StringLiteral("b"), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("a"), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new StringLiteral("b"), (Type)VarcharType.createVarcharType((int)3)))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(3.0))))).equalTo(this.standardInputStatistics);
    }

    @Test
    public void testUnsupportedExpression() {
        this.assertExpression((Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("x")))).outputRowsCountUnknown();
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("x"))))).outputRowsCountUnknown();
    }

    @Test
    public void testAndStats() {
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0)))), PlanNodeStatsEstimate.unknown()).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral(1.0)))), PlanNodeStatsEstimate.unknown()).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0)))), this.zeroStatistics).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral(1.0)))), this.zeroStatistics).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0))))).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-7.5"))))).outputRowsCount(281.25).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(15.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DoubleLiteral(0.0), (Expression)new DoubleLiteral(1.0))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DoubleLiteral(0.0), (Expression)new DoubleLiteral(3.0)))))).outputRowsCount(0.0).symbolStats(new Symbol("x"), SymbolStatsAssertion::emptyRange).symbolStats(new Symbol("y"), SymbolStatsAssertion::emptyRange);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new FunctionCall(JSON_ARRAY_CONTAINS.toQualifiedName(), (List)ImmutableList.of((Object)new GenericLiteral((Type)JsonType.JSON, "[]"), (Object)new SymbolReference("x"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0))))).outputRowsCount(337.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new FunctionCall(JSON_ARRAY_CONTAINS.toQualifiedName(), (List)ImmutableList.of((Object)new GenericLiteral((Type)JsonType.JSON, "[]"), (Object)new SymbolReference("x")))))).outputRowsCount(337.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new FunctionCall(JSON_ARRAY_CONTAINS.toQualifiedName(), (List)ImmutableList.of((Object)new GenericLiteral((Type)JsonType.JSON, "[11]"), (Object)new SymbolReference("x"))), (Object)new FunctionCall(JSON_ARRAY_CONTAINS.toQualifiedName(), (List)ImmutableList.of((Object)new GenericLiteral((Type)JsonType.JSON, "[13]"), (Object)new SymbolReference("x")))))).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new InPredicate((Expression)new StringLiteral("a"), (List)ImmutableList.of((Object)new StringLiteral("b"), (Object)new StringLiteral("c"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral(3.0))))).outputRowsCount(0.0);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN)))).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(1.0))))))).equalTo(this.zeroStatistics);
        Consumer<SymbolStatsAssertion> symbolAssertX = symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-5.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0);
        Consumer<SymbolStatsAssertion> symbolAssertY = symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(5.0).distinctValuesCount(16.0).nullsFraction(0.0);
        double inputRowCount = this.standardInputStatistics.getOutputRowCount();
        double filterSelectivityX = 0.375;
        double inequalityFilterSelectivityY = 0.4;
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0").build()).outputRowsCount(filterSelectivityX * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "1").build()).outputRowsCount(filterSelectivityX * inequalityFilterSelectivityY * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(inequalityFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        double nullFilterSelectivityY = 0.5;
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference("y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "1").build()).outputRowsCount(filterSelectivityX * nullFilterSelectivityY * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference("y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(nullFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference("y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0").build()).outputRowsCount(filterSelectivityX * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE), (Expression)new SymbolReference("y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(100.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(1.0).distinctValuesCount(4.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(2L), (Type)DoubleType.DOUBLE)))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(inequalityFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(16.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(172.0).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.1053779069));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE), (Object)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE), (Object)new Cast((Expression)new LongLiteral(2L), (Type)DoubleType.DOUBLE))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(2L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DoubleType.DOUBLE)))))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(20.373798).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(2.0).distinctValuesCount(2.623798).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(15.686298).nullsFraction(0.2300749269));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DoubleType.DOUBLE)), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * inputRowCount * 0.9).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0));
    }

    @Test
    public void testNotStats() {
        this.assertExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(0.0)))).outputRowsCount(625.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.4)).symbolStats(new Symbol("y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("x")))).outputRowsCount(750.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).symbolStats(new Symbol("y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression((Expression)new NotExpression((Expression)new FunctionCall(JSON_ARRAY_CONTAINS.toQualifiedName(), (List)ImmutableList.of((Object)new GenericLiteral((Type)JsonType.JSON, "[]"), (Object)new SymbolReference("x"))))).outputRowsCountUnknown();
    }

    @Test
    public void testIsNullFilter() {
        this.assertExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("x"))).outputRowsCount(250.0).symbolStats(new Symbol("x"), symbolStats -> symbolStats.distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("emptyRange"))).outputRowsCount(1000.0).symbolStats(new Symbol("emptyRange"), SymbolStatsAssertion::empty);
    }

    @Test
    public void testIsNotNullFilter() {
        this.assertExpression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("x"))).outputRowsCount(750.0).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("emptyRange"))).outputRowsCount(0.0).symbolStats("emptyRange", SymbolStatsAssertion::empty);
    }

    @Test
    public void testBetweenOperatorFilter() {
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(7.5), (Expression)new DoubleLiteral(12.0))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(7.5).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-12"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-7.5"))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new DoubleLiteral(-12.0), (Expression)new DoubleLiteral(-7.5))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("x"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-2.5"), (Expression)new DoubleLiteral(2.5))).outputRowsCount(187.5).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-2.5).highValue(2.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral(2.72), (Expression)new DoubleLiteral(3.14))).outputRowsCount(112.5).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(6.25).lowValue(2.72).highValue(3.14).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("leftOpen"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-10"), (Expression)new DoubleLiteral(10.0))).outputRowsCount(180.0).symbolStats("leftOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("rightOpen"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-10"), (Expression)new DoubleLiteral(10.0))).outputRowsCount(180.0).symbolStats("rightOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("y"), (Expression)new DoubleLiteral(27.5), (Expression)new DoubleLiteral(107.0))).outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("y"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-100"), (Expression)new DoubleLiteral(100.0))).outputRowsCount(500.0).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("z"), (Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "-100"), (Expression)new DoubleLiteral(100.0))).outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-100.0).highValue(100.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new Cast((Expression)new SymbolReference("x"), (Type)DecimalType.createDecimalType((int)7, (int)2)), (Expression)new Cast((Expression)new DecimalLiteral("-2.50"), (Type)DecimalType.createDecimalType((int)7, (int)2)), (Expression)new Cast((Expression)new DecimalLiteral("2.50"), (Type)DecimalType.createDecimalType((int)7, (int)2)))).outputRowsCount(219.726563).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(this.xStats.getDistinctValuesCount()).lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).nullsFraction(this.xStats.getNullsFraction()));
        this.assertExpression((Expression)new InPredicate((Expression)new StringLiteral("a"), (List)ImmutableList.of((Object)new StringLiteral("a"), (Object)new StringLiteral("b")))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new StringLiteral("a"), (List)ImmutableList.of((Object)new StringLiteral("a"), (Object)new StringLiteral("b"), (Object)new Cast((Expression)new NullLiteral(), (Type)VarcharType.createVarcharType((int)1))))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new StringLiteral("a"), (List)ImmutableList.of((Object)new StringLiteral("b"), (Object)new StringLiteral("c")))).outputRowsCount(0.0);
        this.assertExpression((Expression)new InPredicate((Expression)new StringLiteral("a"), (List)ImmutableList.of((Object)new StringLiteral("b"), (Object)new StringLiteral("c"), (Object)new Cast((Expression)new NullLiteral(), (Type)VarcharType.createVarcharType((int)1))))).outputRowsCount(0.0);
        this.assertExpression((Expression)new InPredicate((Expression)new Cast((Expression)new StringLiteral("b"), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("a"), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new StringLiteral("b"), (Type)VarcharType.createVarcharType((int)3))))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new Cast((Expression)new StringLiteral("c"), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("a"), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new StringLiteral("b"), (Type)VarcharType.createVarcharType((int)3))))).outputRowsCount(0.0);
    }

    @Test
    public void testSymbolEqualsSameSymbolFilter() {
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("x"))).outputRowsCount(750.0).symbolStats("x", symbolStats -> SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).build());
    }

    @Test
    public void testInPredicateFilter() {
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new DoubleLiteral(7.5)))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-7.5")))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2"), (Expression)new DoubleLiteral(5.5))))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new DoubleLiteral(-7.5)))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new DoubleLiteral(1.5), (Object)new DoubleLiteral(2.5), (Object)new DoubleLiteral(7.5)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0)).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.5));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-42"), (Object)new DoubleLiteral(1.5), (Object)new DoubleLiteral(2.5), (Object)new DoubleLiteral(7.5), (Object)new DoubleLiteral(314.0)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("x"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-42"), (Object)new DoubleLiteral(1.5), (Object)new DoubleLiteral(2.5), (Object)new DoubleLiteral(7.5), (Object)new DoubleLiteral(314.0), (Object)new Cast((Expression)new NullLiteral(), (Type)DoubleType.DOUBLE)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("unknownRange"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-42"), (Object)new DoubleLiteral(1.5), (Object)new DoubleLiteral(2.5), (Object)new DoubleLiteral(7.5), (Object)new DoubleLiteral(314.0)))).outputRowsCount(90.0).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-42.0).highValue(314.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("mediumVarchar"), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("abc"), (Type)MEDIUM_VARCHAR_TYPE)))).outputRowsCount(4.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(1.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("mediumVarchar"), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("abc"), (Type)VarcharType.createVarcharType((int)100)), (Object)new Cast((Expression)new StringLiteral("def"), (Type)VarcharType.createVarcharType((int)100))))).outputRowsCount(8.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("y"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-42"), (Object)new DoubleLiteral(6.0), (Object)new DoubleLiteral(31.1341), (Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-0.000000002"), (Object)new DoubleLiteral(314.0)))).outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("z"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-1"), (Object)new DoubleLiteral(3.14), (Object)new DoubleLiteral(0.0), (Object)new DoubleLiteral(1.0), (Object)new DoubleLiteral(2.0), (Object)new DoubleLiteral(3.0), (Object)new DoubleLiteral(4.0), (Object)new DoubleLiteral(5.0), (Object)new DoubleLiteral(6.0), (Object)new DoubleLiteral(7.0), (Object)new DoubleLiteral(8.0), (Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-2"), (Object[])new Expression[0]))).outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-2.0).highValue(8.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference("z"), (List)ImmutableList.of((Object)new GenericLiteral((Type)DoubleType.DOUBLE, "-1"), (Object)new DoubleLiteral(1.0), (Object)new DoubleLiteral(0.0)))).outputRowsCount(540.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(-1.0).highValue(1.0).nullsFraction(0.0));
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression) {
        return this.assertExpression(expression, this.session);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, PlanNodeStatsEstimate inputStatistics) {
        return this.assertExpression(expression, this.session, inputStatistics);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, Session session) {
        return this.assertExpression(expression, session, this.standardInputStatistics);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, Session session, PlanNodeStatsEstimate inputStatistics) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (PlanNodeStatsAssertion)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> PlanNodeStatsAssertion.assertThat(this.statsCalculator.filterStats(inputStatistics, expression, transactionSession, this.standardTypes)));
    }
}

