/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SymbolStatsAssertion;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestScalarStatsCalculator {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final ScalarStatsCalculator calculator = new ScalarStatsCalculator(this.functionResolution.getPlannerContext(), new IrTypeAnalyzer(this.functionResolution.getPlannerContext()));
    private final Session session = TestingSession.testSessionBuilder().build();

    @Test
    public void testLiteral() {
        this.assertCalculate((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "7")).distinctValuesCount(1.0).lowValue(7.0).highValue(7.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "8")).distinctValuesCount(1.0).lowValue(8.0).highValue(8.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral((Type)IntegerType.INTEGER, "9")).distinctValuesCount(1.0).lowValue(9.0).highValue(9.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral((Type)BigintType.BIGINT, Long.toString(Long.MAX_VALUE))).distinctValuesCount(1.0).lowValue(9.223372036854776E18).highValue(9.223372036854776E18).nullsFraction(0.0);
        this.assertCalculate((Expression)new DoubleLiteral(7.5)).distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0);
        this.assertCalculate((Expression)new DecimalLiteral("75.5")).distinctValuesCount(1.0).lowValue(75.5).highValue(75.5).nullsFraction(0.0);
        this.assertCalculate((Expression)new StringLiteral("blah")).distinctValuesCount(1.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0);
        this.assertCalculate((Expression)new NullLiteral()).distinctValuesCount(0.0).lowValueUnknown().highValueUnknown().nullsFraction(1.0);
    }

    @Test
    public void testFunctionCall() {
        this.assertCalculate((Expression)this.functionResolution.functionCallBuilder("length").addArgument((Type)VarcharType.createVarcharType((int)10), (Expression)new Cast((Expression)new NullLiteral(), (Type)VarcharType.createVarcharType((int)10))).build()).distinctValuesCount(0.0).lowValueUnknown().highValueUnknown().nullsFraction(1.0);
        this.assertCalculate((Expression)this.functionResolution.functionCallBuilder("length").addArgument((Type)VarcharType.createVarcharType((int)2), (Expression)new SymbolReference("x")).build(), PlanNodeStatsEstimate.unknown(), TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("x"), (Object)VarcharType.createVarcharType((int)2)))).distinctValuesCountUnknown().lowValueUnknown().highValueUnknown().nullsFractionUnknown();
    }

    @Test
    public void testVarbinaryConstant() {
        LiteralEncoder literalEncoder = new LiteralEncoder(this.functionResolution.getPlannerContext());
        Expression expression = literalEncoder.toExpression((Object)Slices.utf8Slice((String)"ala ma kota"), (Type)VarbinaryType.VARBINARY);
        this.assertCalculate(expression).distinctValuesCount(1.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0);
    }

    @Test
    public void testSymbolReference() {
        SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build();
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), xStats).build();
        this.assertCalculate((Expression)new SymbolReference("x"), inputStatistics).isEqualTo(xStats);
        this.assertCalculate((Expression)new SymbolReference("y"), inputStatistics).isEqualTo(SymbolStatsEstimate.unknown());
    }

    @Test
    public void testCastDoubleToBigint() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(17.3).setDistinctValuesCount(10.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)BigintType.BIGINT), inputStatistics, TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("a"), (Object)BigintType.BIGINT))).lowValue(2.0).highValue(17.0).distinctValuesCount(10.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastDoubleToShortRange() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(3.3).setDistinctValuesCount(10.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)BigintType.BIGINT), inputStatistics, TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("a"), (Object)BigintType.BIGINT))).lowValue(2.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastDoubleToShortRangeUnknownDistinctValuesCount() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(3.3).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)BigintType.BIGINT), inputStatistics, TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("a"), (Object)BigintType.BIGINT))).lowValue(2.0).highValue(3.0).distinctValuesCountUnknown().nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastBigintToDouble() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(2.0).setHighValue(10.0).setDistinctValuesCount(4.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), inputStatistics, TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("a"), (Object)DoubleType.DOUBLE))).lowValue(2.0).highValue(10.0).distinctValuesCount(4.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastUnknown() {
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)BigintType.BIGINT), PlanNodeStatsEstimate.unknown(), TypeProvider.viewOf((Map)ImmutableMap.of((Object)new Symbol("a"), (Object)BigintType.BIGINT))).lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown().dataSizeUnknown();
    }

    private SymbolStatsAssertion assertCalculate(Expression scalarExpression) {
        return this.assertCalculate(scalarExpression, PlanNodeStatsEstimate.unknown());
    }

    private SymbolStatsAssertion assertCalculate(Expression scalarExpression, PlanNodeStatsEstimate inputStatistics) {
        return this.assertCalculate(scalarExpression, inputStatistics, TypeProvider.empty());
    }

    private SymbolStatsAssertion assertCalculate(Expression scalarExpression, PlanNodeStatsEstimate inputStatistics, TypeProvider types) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (SymbolStatsAssertion)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, transactionSession -> SymbolStatsAssertion.assertThat(this.calculator.calculate(scalarExpression, inputStatistics, transactionSession, types)));
    }

    @Test
    public void testNonDivideArithmeticBinaryExpression() {
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build()).addSymbolStatistics(new Symbol("y"), SymbolStatsEstimate.builder().setLowValue(-2.0).setHighValue(5.0).setDistinctValuesCount(3.0).setNullsFraction(0.2).setAverageRowSize(2.0).build()).addSymbolStatistics(new Symbol("unknown"), SymbolStatsEstimate.unknown()).setOutputRowCount(10.0).build();
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), relationStats).distinctValuesCount(10.0).lowValue(-3.0).highValue(15.0).nullsFraction(0.28).averageRowSize(2.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("unknown")), relationStats).isEqualTo(SymbolStatsEstimate.unknown());
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("unknown"), (Expression)new SymbolReference("unknown")), relationStats).isEqualTo(SymbolStatsEstimate.unknown());
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), relationStats).distinctValuesCount(10.0).lowValue(-6.0).highValue(12.0).nullsFraction(0.28).averageRowSize(2.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), relationStats).distinctValuesCount(10.0).lowValue(-20.0).highValue(50.0).nullsFraction(0.28).averageRowSize(2.0);
    }

    @Test
    public void testArithmeticBinaryWithAllNullsSymbol() {
        SymbolStatsEstimate allNullStats = SymbolStatsEstimate.zero();
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(0.0).build()).addSymbolStatistics(new Symbol("all_null"), allNullStats).setOutputRowCount(10.0).build();
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("all_null")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("all_null")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("all_null"), (Expression)new SymbolReference("x")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("all_null"), (Expression)new SymbolReference("x")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("all_null")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("all_null"), (Expression)new SymbolReference("x")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("all_null")), relationStats).isEqualTo(allNullStats);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("all_null"), (Expression)new SymbolReference("x")), relationStats).isEqualTo(allNullStats);
    }

    @Test
    public void testDivideArithmeticBinaryExpression() {
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, -3.0, -5.0, -4.0)).lowValue(0.6).highValue(2.75);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, -3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, -3.0, 4.0, 5.0)).lowValue(-2.75).highValue(-0.6);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 0.0, -5.0, -4.0)).lowValue(0.0).highValue(2.75);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 0.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 0.0, 4.0, 5.0)).lowValue(-2.75).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 3.0, -5.0, -4.0)).lowValue(-0.75).highValue(2.75);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-11.0, 3.0, 4.0, 5.0)).lowValue(-2.75).highValue(0.75);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 3.0, -5.0, -4.0)).lowValue(-0.75).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 3.0, 4.0, 5.0)).lowValue(0.0).highValue(0.75);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(3.0, 11.0, -5.0, -4.0)).lowValue(-2.75).highValue(-0.6);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(3.0, 11.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(3.0, 11.0, 4.0, 5.0)).lowValue(0.6).highValue(2.75);
    }

    @Test
    public void testModulusArithmeticBinaryExpression() {
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 0.0, -6.0, -4.0)).lowValue(-1.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 0.0, -6.0, -4.0)).lowValue(-5.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, -6.0, -4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, -6.0, -4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, -6.0, 4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, -6.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, 4.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 0.0, 4.0, 6.0)).lowValue(-1.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 0.0, 4.0, 6.0)).lowValue(-5.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 0.0, 4.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 5.0, -6.0, -4.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 8.0, -6.0, -4.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 1.0, -6.0, 4.0)).lowValue(0.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 5.0, -6.0, 4.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 8.0, -6.0, 4.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 1.0, 4.0, 6.0)).lowValue(0.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 5.0, 4.0, 6.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(0.0, 8.0, 4.0, 6.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 1.0, -6.0, -4.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 5.0, -6.0, -4.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 1.0, -6.0, -4.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 5.0, -6.0, -4.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 8.0, -6.0, -4.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 5.0, -6.0, -4.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 8.0, -6.0, -4.0)).lowValue(-6.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 1.0, -6.0, 4.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 5.0, -6.0, 4.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 1.0, -6.0, 4.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 5.0, -6.0, 4.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 8.0, -6.0, 4.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 5.0, -6.0, 4.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 8.0, -6.0, 4.0)).lowValue(-6.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 1.0, 4.0, 6.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-1.0, 5.0, 4.0, 6.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 1.0, 4.0, 6.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 5.0, 4.0, 6.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-5.0, 8.0, 4.0, 6.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 5.0, 4.0, 6.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), this.xyStats(-8.0, 8.0, 4.0, 6.0)).lowValue(-6.0).highValue(6.0);
    }

    private PlanNodeStatsEstimate xyStats(double lowX, double highX, double lowY, double highY) {
        return PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.builder().setLowValue(lowX).setHighValue(highX).build()).addSymbolStatistics(new Symbol("y"), SymbolStatsEstimate.builder().setLowValue(lowY).setHighValue(highY).build()).build();
    }

    @Test
    public void testCoalesceExpression() {
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build()).addSymbolStatistics(new Symbol("y"), SymbolStatsEstimate.builder().setLowValue(-2.0).setHighValue(5.0).setDistinctValuesCount(3.0).setNullsFraction(0.2).setAverageRowSize(2.0).build()).setOutputRowCount(10.0).build();
        this.assertCalculate((Expression)new CoalesceExpression((Expression)new SymbolReference("x"), (Expression)new SymbolReference("y"), new Expression[0]), relationStats).distinctValuesCount(5.0).lowValue(-2.0).highValue(10.0).nullsFraction(0.02).averageRowSize(2.0);
        this.assertCalculate((Expression)new CoalesceExpression((Expression)new SymbolReference("y"), (Expression)new SymbolReference("x"), new Expression[0]), relationStats).distinctValuesCount(5.0).lowValue(-2.0).highValue(10.0).nullsFraction(0.02).averageRowSize(2.0);
    }
}

