/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.planner.Symbol;
import io.trino.type.UnknownType;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestValuesNodeStats
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForValuesNode() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)pb.symbol("b", (Type)DoubleType.DOUBLE)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new GenericLiteral((Type)BigintType.BIGINT, "3"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "3")), (Object)new DoubleLiteral(13.5)), (Object)ImmutableList.of((Object)new GenericLiteral((Type)BigintType.BIGINT, "55"), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new GenericLiteral((Type)BigintType.BIGINT, "6"), (Object)new DoubleLiteral(13.5))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(3.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.0).setLowValue(6.0).setHighValue(55.0).setDistinctValuesCount(2.0).build()).addSymbolStatistics(new Symbol("b"), SymbolStatsEstimate.builder().setNullsFraction(0.3333333333333333).setLowValue(13.5).setHighValue(13.5).setDistinctValuesCount(1.0).build()).build()));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("v", (Type)VarcharType.createVarcharType((int)30))), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("Alice")), (Object)ImmutableList.of((Object)new StringLiteral("'has'")), (Object)ImmutableList.of((Object)new StringLiteral("'a cat'")), (Object)ImmutableList.of((Object)new NullLiteral())))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(4.0).addSymbolStatistics(new Symbol("v"), SymbolStatsEstimate.builder().setNullsFraction(0.25).setDistinctValuesCount(3.0).build()).build()));
    }

    @Test
    public void testDivisionByZero() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(0L)))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.unknown()));
    }

    @Test
    public void testStatsForValuesNodeWithJustNulls() {
        PlanNodeStatsEstimate nullAStats = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.zero()).build();
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(3L), (Expression)new NullLiteral()))))).check(outputStats -> outputStats.equalTo(nullAStats));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral())))).check(outputStats -> outputStats.equalTo(nullAStats));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)UnknownType.UNKNOWN)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral())))).check(outputStats -> outputStats.equalTo(nullAStats));
    }

    @Test
    public void testStatsForEmptyValues() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of())).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(0.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.zero()).build()));
    }
}

