/*
 * Decompiled with CFR 0.152.
 */
package io.trino.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.tracing.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.exchange.LazyExchangeDataSource;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.exchange.ExchangeId;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.FutureAssert;
import org.junit.jupiter.api.Test;

public class TestLazyExchangeDataSource {
    @Test
    public void testIsBlockedCancellationIsolationInInitializationPhase() {
        try (LazyExchangeDataSource source = new LazyExchangeDataSource(new QueryId("query"), new ExchangeId("exchange"), Span.getInvalid(), (queryId, exchangeId, span, memoryContext, taskFailureListener, retryPolicy) -> {
            throw new UnsupportedOperationException();
        }, (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), TestLazyExchangeDataSource.class.getSimpleName()), (taskId, failure) -> {
            throw new UnsupportedOperationException();
        }, RetryPolicy.NONE, new ExchangeManagerRegistry(OpenTelemetry.noop(), Tracing.noopTracer()));){
            ListenableFuture first = source.isBlocked();
            ListenableFuture second = source.isBlocked();
            ((FutureAssert)Assertions.assertThat((Future)first).isNotDone()).isNotCancelled();
            ((FutureAssert)Assertions.assertThat((Future)second).isNotDone()).isNotCancelled();
            first.cancel(true);
            ((FutureAssert)Assertions.assertThat((Future)first).isDone()).isCancelled();
            ((FutureAssert)Assertions.assertThat((Future)second).isNotDone()).isNotCancelled();
            ListenableFuture third = source.isBlocked();
            ((FutureAssert)Assertions.assertThat((Future)third).isNotDone()).isNotCancelled();
        }
    }
}

