/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.tracing.Tracing;
import io.opentelemetry.api.trace.Span;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.StageStateMachine;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestStageStateMachine {
    private static final StageId STAGE_ID = new StageId("query", 0);
    private static final PlanFragment PLAN_FRAGMENT = TestStageStateMachine.createValuesPlan();
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testBasicStateChanges() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testPlanned() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testScheduling() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testRunning() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testFinished() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testFailed() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FAILED);
    }

    private static void assertFinalState(StageStateMachine stateMachine, StageState expectedState) {
        Assertions.assertThat((boolean)expectedState.isDone()).isTrue();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish"))).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
    }

    private static void assertState(StageStateMachine stateMachine, StageState expectedState) {
        Assertions.assertThat((Object)stateMachine.getStageId()).isEqualTo((Object)STAGE_ID);
        StageInfo stageInfo = stateMachine.getStageInfo(ImmutableList::of);
        Assertions.assertThat((Object)stageInfo.getStageId()).isEqualTo((Object)STAGE_ID);
        Assertions.assertThat((List)stageInfo.getSubStages()).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)stageInfo.getTasks()).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)stageInfo.getTypes()).isEqualTo((Object)ImmutableList.of((Object)VarcharType.VARCHAR));
        Assertions.assertThat((Object)stageInfo.getPlan()).isSameAs((Object)PLAN_FRAGMENT);
        Assertions.assertThat((Comparable)stateMachine.getState()).isEqualTo((Object)expectedState);
        Assertions.assertThat((Comparable)stageInfo.getState()).isEqualTo((Object)expectedState);
        if (expectedState == StageState.FAILED) {
            ExecutionFailureInfo failure = stageInfo.getFailureCause();
            Assertions.assertThat((String)failure.getMessage()).isEqualTo(FAILED_CAUSE.getMessage());
            Assertions.assertThat((String)failure.getType()).isEqualTo(FAILED_CAUSE.getClass().getName());
        } else {
            Assertions.assertThat((Object)stageInfo.getFailureCause()).isNull();
        }
    }

    private StageStateMachine createStageStateMachine() {
        return new StageStateMachine(STAGE_ID, PLAN_FRAGMENT, (Map)ImmutableMap.of(), (Executor)this.executor, Tracing.noopTracer(), Span.getInvalid(), new SplitSchedulerStats());
    }

    private static PlanFragment createValuesPlan() {
        Symbol symbol = new Symbol("column");
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("plan"), (PlanNode)new ValuesNode(valuesNodeId, (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new StringLiteral("foo"))))), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        return planFragment;
    }

    static {
        FAILED_CAUSE.setStackTrace(new StackTraceElement[0]);
    }
}

