/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.FlatHashStrategy;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.TestingSession;
import io.trino.type.IpAddressType;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlatHashStrategy {
    private final TypeOperators typeOperators = new TypeOperators();
    private final JoinCompiler joinCompiler = new JoinCompiler(this.typeOperators);

    @Test
    public void testBatchedRawHashesZeroLength() {
        List<Type> types = TestFlatHashStrategy.createTestingTypes(this.typeOperators);
        FlatHashStrategy flatHashStrategy = this.joinCompiler.getFlatHashStrategy(types);
        int positionCount = 10;
        Assertions.assertDoesNotThrow(() -> flatHashStrategy.hashBlocksBatched(new Block[types.size()], new long[positionCount], 0, 0));
    }

    @Test
    public void testBatchedRawHashesMatchSinglePositionHashes() {
        List<Type> types = TestFlatHashStrategy.createTestingTypes(this.typeOperators);
        FlatHashStrategy flatHashStrategy = this.joinCompiler.getFlatHashStrategy(types);
        int positionCount = 1024;
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockAssertions.createRandomBlockForType(types.get(i), positionCount, 0.25f);
        }
        long[] hashes = new long[positionCount];
        flatHashStrategy.hashBlocksBatched(blocks, hashes, 0, positionCount);
        TestFlatHashStrategy.assertHashesEqual(types, blocks, hashes, flatHashStrategy);
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = RunLengthEncodedBlock.create((Block)blocks[i].getSingleValueBlock(0), (int)positionCount);
        }
        flatHashStrategy.hashBlocksBatched(blocks, hashes, 0, positionCount);
        TestFlatHashStrategy.assertHashesEqual(types, blocks, hashes, flatHashStrategy);
        Assertions.assertNotNull((Object)TestFlatHashStrategy.singleRowTypesAndValues(types, blocks, 0));
    }

    private static void assertHashesEqual(List<Type> types, Block[] blocks, long[] batchedHashes, FlatHashStrategy flatHashStrategy) {
        for (int position = 0; position < batchedHashes.length; ++position) {
            long singleRowHash = flatHashStrategy.hash(blocks, position);
            if (batchedHashes[position] == singleRowHash) continue;
            Assertions.fail((String)"Hash mismatch: %s <> %s at position %s - Values: %s".formatted(batchedHashes[position], singleRowHash, position, TestFlatHashStrategy.singleRowTypesAndValues(types, blocks, position)));
        }
    }

    private static List<Type> createTestingTypes(TypeOperators typeOperators) {
        List<Type> baseTypes = List.of(BigintType.BIGINT, BooleanType.BOOLEAN, CharType.createCharType((int)5), DecimalType.createDecimalType((int)18), DecimalType.createDecimalType((int)38), DoubleType.DOUBLE, IntegerType.INTEGER, IpAddressType.IPADDRESS, RealType.REAL, TimestampType.TIMESTAMP_SECONDS, TimestampType.TIMESTAMP_MILLIS, TimestampType.TIMESTAMP_MICROS, TimestampType.TIMESTAMP_NANOS, TimestampType.TIMESTAMP_PICOS, UuidType.UUID, VarbinaryType.VARBINARY, VarcharType.VARCHAR);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(baseTypes);
        builder.add((Object)RowType.anonymous(baseTypes));
        for (Type baseType : baseTypes) {
            builder.add((Object)new ArrayType(baseType));
            builder.add((Object)new MapType(baseType, baseType, typeOperators));
        }
        return builder.build();
    }

    private static String singleRowTypesAndValues(List<Type> types, Block[] blocks, int position) {
        ConnectorSession connectorSession = TestingSession.testSessionBuilder().build().toConnectorSession();
        StringBuilder builder = new StringBuilder();
        int column = 0;
        for (Type type : types) {
            builder.append("\n\t");
            builder.append(type);
            builder.append(": ");
            builder.append(type.getObjectValue(connectorSession, blocks[column], position));
            ++column;
        }
        return builder.toString();
    }
}

