/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.block.BlockAssertions;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.FlatGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.TestingSession;
import io.trino.type.TypeTestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGroupByHash {
    private static final int MAX_GROUP_ID = 500;
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler(new TypeOperators());
    private static final int BIGINT_EXPECTED_REHASH = 20;
    private static final int VARCHAR_EXPECTED_REHASH = 11;

    @Test
    public void testAddPage() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            for (int tries = 0; tries < 2; ++tries) {
                for (int value = 0; value < 500; ++value) {
                    ValueBlock block = BlockAssertions.createLongsBlock(value);
                    Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
                    Page page = new Page(new Block[]{block, hashBlock});
                    for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                        groupByHash.addPage(page).process();
                        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(tries == 0 ? value + 1 : 500);
                        int[] groupIds = TestGroupByHash.getGroupIds(groupByHash, page);
                        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(tries == 0 ? value + 1 : 500);
                        Assertions.assertThat((int)groupIds.length).isEqualTo(1);
                        int groupId = groupIds[0];
                        Assertions.assertThat((int)groupId).isEqualTo(value);
                    }
                }
            }
        }
    }

    @Test
    public void testRunLengthEncodedInputPage() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            ValueBlock block = BlockAssertions.createLongsBlock(0L);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
            Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Block)block, (int)2), RunLengthEncodedBlock.create((Block)hashBlock, (int)2)});
            groupByHash.addPage(page).process();
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(1);
            Work work = groupByHash.getGroupIds(page);
            if (groupByHashType == GroupByHashType.FLAT) {
                Assertions.assertThat((Object)work).isInstanceOf(FlatGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
            } else {
                Assertions.assertThat((Object)work).isInstanceOf(BigintGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
            }
            work.process();
            int[] groupIds = (int[])work.getResult();
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(1);
            Assertions.assertThat((int)groupIds.length).isEqualTo(2);
            Assertions.assertThat((int)groupIds[0]).isEqualTo(0);
            Assertions.assertThat((int)groupIds[1]).isEqualTo(0);
        }
    }

    @Test
    public void testDictionaryInputPage() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            ValueBlock block = BlockAssertions.createLongsBlock(0L, 1L);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
            int[] ids = new int[]{0, 0, 1, 1};
            Page page = new Page(new Block[]{DictionaryBlock.create((int)ids.length, (Block)block, (int[])ids), DictionaryBlock.create((int)ids.length, (Block)hashBlock, (int[])ids)});
            groupByHash.addPage(page).process();
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(2);
            int[] groupIds = TestGroupByHash.getGroupIds(groupByHash, page);
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(2);
            Assertions.assertThat((int)groupIds.length).isEqualTo(4);
            Assertions.assertThat((int)groupIds[0]).isEqualTo(0);
            Assertions.assertThat((int)groupIds[1]).isEqualTo(0);
            Assertions.assertThat((int)groupIds[2]).isEqualTo(1);
            Assertions.assertThat((int)groupIds[3]).isEqualTo(1);
        }
    }

    @Test
    public void testNullGroup() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            ValueBlock block = BlockAssertions.createLongsBlock(0L, null);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
            Page page = new Page(new Block[]{block, hashBlock});
            Assertions.assertThat((int[])TestGroupByHash.getGroupIds(groupByHash, page)).containsExactly(new int[]{0, 1});
            block = BlockAssertions.createLongSequenceBlock(1, 132748);
            hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
            page = new Page(new Block[]{block, hashBlock});
            groupByHash.addPage(page).process();
            block = BlockAssertions.createLongsBlock(new Long[]{null});
            hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
            Assertions.assertThat((int[])TestGroupByHash.getGroupIds(groupByHash, new Page(new Block[]{block, hashBlock}))).containsExactly(new int[]{1});
        }
    }

    @Test
    public void testGetGroupIds() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            for (int tries = 0; tries < 2; ++tries) {
                for (int value = 0; value < 500; ++value) {
                    ValueBlock block = BlockAssertions.createLongsBlock(value);
                    Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{block});
                    Page page = new Page(new Block[]{block, hashBlock});
                    for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                        int[] groupIds = TestGroupByHash.getGroupIds(groupByHash, page);
                        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(tries == 0 ? value + 1 : 500);
                        Assertions.assertThat((int)groupIds.length).isEqualTo(1);
                        long groupId = groupIds[0];
                        Assertions.assertThat((long)groupId).isEqualTo((long)value);
                    }
                }
            }
        }
    }

    @Test
    public void testAppendTo() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            ValueBlock valuesBlock = BlockAssertions.createLongSequenceBlock(0, 100);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{valuesBlock});
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            int[] groupIds = TestGroupByHash.getGroupIds(groupByHash, new Page(new Block[]{valuesBlock, hashBlock}));
            for (int i = 0; i < valuesBlock.getPositionCount(); ++i) {
                Assertions.assertThat((int)groupIds[i]).isEqualTo(i);
            }
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(100);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
                pageBuilder.declarePosition();
                groupByHash.appendValuesTo(i, pageBuilder);
            }
            Page page = pageBuilder.build();
            for (int i = 0; i < page.getChannelCount(); ++i) {
                Assertions.assertThat((int)page.getBlock(i).getPositionCount()).isEqualTo(100);
            }
            Assertions.assertThat((int)page.getPositionCount()).isEqualTo(100);
            BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, page.getBlock(0), (Block)valuesBlock);
            BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, page.getBlock(1), hashBlock);
        }
    }

    @Test
    public void testAppendToMultipleTuplesPerGroup() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            ArrayList<Long> values = new ArrayList<Long>();
            for (long i = 0L; i < 100L; ++i) {
                values.add(i % 50L);
            }
            ValueBlock valuesBlock = BlockAssertions.createLongsBlock(values);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{valuesBlock});
            GroupByHash groupByHash = groupByHashType.createGroupByHash();
            groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock})).process();
            Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(50);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
                pageBuilder.declarePosition();
                groupByHash.appendValuesTo(i, pageBuilder);
            }
            Page outputPage = pageBuilder.build();
            Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(50);
            BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, outputPage.getBlock(0), (Block)BlockAssertions.createLongSequenceBlock(0, 50));
        }
    }

    @Test
    public void testForceRehash() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            ValueBlock valuesBlock = BlockAssertions.createLongSequenceBlock(0, 100);
            Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), new Block[]{valuesBlock});
            GroupByHash groupByHash = groupByHashType.createGroupByHash(4, UpdateMemory.NOOP);
            groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock})).process();
            int groupCount = groupByHash.getGroupCount();
            for (int groupId : TestGroupByHash.getGroupIds(groupByHash, new Page(new Block[]{valuesBlock, hashBlock}))) {
                Assertions.assertThat((int)groupId).isLessThan(groupCount);
            }
        }
    }

    @Test
    public void testUpdateMemoryVarchar() {
        VarcharType type = VarcharType.VARCHAR;
        ValueBlock valuesBlock = BlockAssertions.createStringSequenceBlock(0, 1000000);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)type), new Block[]{valuesBlock});
        AtomicInteger rehashCount = new AtomicInteger();
        GroupByHash groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (boolean)true, (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, () -> {
            rehashCount.incrementAndGet();
            return true;
        });
        groupByHash.addPage(new Page(new Block[]{valuesBlock, hashBlock})).process();
        Assertions.assertThat((int)rehashCount.get()).isEqualTo(22);
    }

    @Test
    public void testUpdateMemoryBigint() {
        BigintType type = BigintType.BIGINT;
        ValueBlock valuesBlock = BlockAssertions.createLongSequenceBlock(0, 1000000);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)type), new Block[]{valuesBlock});
        AtomicInteger rehashCount = new AtomicInteger();
        GroupByHash groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (boolean)true, (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, () -> {
            rehashCount.incrementAndGet();
            return true;
        });
        groupByHash.addPage(new Page(new Block[]{valuesBlock, hashBlock})).process();
        Assertions.assertThat((int)rehashCount.get()).isEqualTo(40);
    }

    @Test
    public void testMemoryReservationYield() {
        int length = 1000000;
        TestGroupByHash.testMemoryReservationYield((Type)VarcharType.VARCHAR, (Block)BlockAssertions.createStringSequenceBlock(0, length), length, 11);
        TestGroupByHash.testMemoryReservationYield((Type)BigintType.BIGINT, (Block)BlockAssertions.createLongSequenceBlock(0, length), length, 20);
    }

    private static void testMemoryReservationYield(Type type, Block valuesBlock, int length, int expectedRehash) {
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)type), valuesBlock);
        Page page = new Page(new Block[]{valuesBlock, hashBlock});
        AtomicInteger currentQuota = new AtomicInteger(0);
        AtomicInteger allowedQuota = new AtomicInteger(6);
        UpdateMemory updateMemory = () -> {
            if (currentQuota.get() < allowedQuota.get()) {
                currentQuota.getAndIncrement();
                return true;
            }
            return false;
        };
        int yields = 0;
        GroupByHash groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (boolean)true, (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)updateMemory);
        boolean finish = false;
        Work addPageWork = groupByHash.addPage(page);
        while (!finish) {
            finish = addPageWork.process();
            if (finish) continue;
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
            Assertions.assertThat((boolean)addPageWork.process()).isFalse();
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assertions.assertThat((int)length).isEqualTo(groupByHash.getGroupCount());
        Assertions.assertThat((int)currentQuota.get()).isEqualTo(2 * expectedRehash);
        Assertions.assertThat((int)(currentQuota.get() / 3 / 2)).isEqualTo(yields);
        currentQuota.set(0);
        allowedQuota.set(6);
        yields = 0;
        groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (boolean)true, (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)updateMemory);
        finish = false;
        Work getGroupIdsWork = groupByHash.getGroupIds(page);
        while (!finish) {
            finish = getGroupIdsWork.process();
            if (finish) continue;
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
            Assertions.assertThat((boolean)getGroupIdsWork.process()).isFalse();
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assertions.assertThat((int)length).isEqualTo(groupByHash.getGroupCount());
        Assertions.assertThat((int)length).isEqualTo(((int[])getGroupIdsWork.getResult()).length);
        Assertions.assertThat((int)currentQuota.get()).isEqualTo(2 * expectedRehash);
        Assertions.assertThat((int)(currentQuota.get() / 3 / 2)).isEqualTo(yields);
    }

    @Test
    public void testMemoryReservationYieldWithDictionary() {
        for (GroupByHashType groupByHashType : GroupByHashType.values()) {
            int dictionaryLength = 10000;
            int length = 2000000;
            int[] ids = IntStream.range(0, dictionaryLength).toArray();
            Block valuesBlock = DictionaryBlock.create((int)dictionaryLength, (Block)BlockAssertions.createLongSequenceBlock(0, length), (int[])ids);
            Block hashBlock = DictionaryBlock.create((int)dictionaryLength, (Block)TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock), (int[])ids);
            Page page = new Page(new Block[]{valuesBlock, hashBlock});
            AtomicInteger currentQuota = new AtomicInteger(0);
            AtomicInteger allowedQuota = new AtomicInteger(6);
            UpdateMemory updateMemory = () -> {
                if (currentQuota.get() < allowedQuota.get()) {
                    currentQuota.getAndIncrement();
                    return true;
                }
                return false;
            };
            int yields = 0;
            GroupByHash groupByHash = groupByHashType.createGroupByHash(1, updateMemory);
            boolean finish = false;
            Work addPageWork = groupByHash.addPage(page);
            while (!finish) {
                finish = addPageWork.process();
                if (finish) continue;
                Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
                Assertions.assertThat((boolean)addPageWork.process()).isFalse();
                Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
                ++yields;
                allowedQuota.getAndAdd(6);
            }
            Assertions.assertThat((int)dictionaryLength).isEqualTo(groupByHash.getGroupCount());
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(2 * (groupByHashType == GroupByHashType.FLAT ? 4 : 13));
            Assertions.assertThat((int)(currentQuota.get() / 3 / 2)).isEqualTo(yields);
            currentQuota.set(0);
            allowedQuota.set(6);
            yields = 0;
            groupByHash = groupByHashType.createGroupByHash(1, updateMemory);
            finish = false;
            Work getGroupIdsWork = groupByHash.getGroupIds(page);
            while (!finish) {
                finish = getGroupIdsWork.process();
                if (finish) continue;
                Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
                Assertions.assertThat((boolean)getGroupIdsWork.process()).isFalse();
                Assertions.assertThat((int)currentQuota.get()).isEqualTo(allowedQuota.get());
                ++yields;
                allowedQuota.getAndAdd(6);
            }
            Assertions.assertThat((int)dictionaryLength).isEqualTo(groupByHash.getGroupCount());
            Assertions.assertThat((int)dictionaryLength).isEqualTo(((int[])getGroupIdsWork.getResult()).length);
            Assertions.assertThat((int)currentQuota.get()).isEqualTo(2 * (groupByHashType == GroupByHashType.FLAT ? 4 : 13));
            Assertions.assertThat((int)(currentQuota.get() / 3 / 2)).isEqualTo(yields);
        }
    }

    @Test
    public void testLowCardinalityDictionariesAddPage() {
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (boolean)false, (int)100, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)UpdateMemory.NOOP);
        Block firstBlock = BlockAssertions.createLongDictionaryBlock(0, 1000, 10);
        Block secondBlock = BlockAssertions.createLongDictionaryBlock(0, 1000, 10);
        Page page = new Page(new Block[]{firstBlock, secondBlock});
        Work work = groupByHash.addPage(page);
        Assertions.assertThat((Object)work).isInstanceOf(FlatGroupByHash.AddLowCardinalityDictionaryPageWork.class);
        work.process();
        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(10);
        firstBlock = BlockAssertions.createLongDictionaryBlock(10, 1000, 5);
        secondBlock = BlockAssertions.createLongDictionaryBlock(10, 1000, 7);
        page = new Page(new Block[]{firstBlock, secondBlock});
        groupByHash.addPage(page).process();
        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(45);
    }

    @Test
    public void testLowCardinalityDictionariesGetGroupIds() {
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (boolean)false, (int)100, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)UpdateMemory.NOOP);
        GroupByHash lowCardinalityGroupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (boolean)false, (int)100, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)UpdateMemory.NOOP);
        ValueBlock sameValueBlock = BlockAssertions.createLongRepeatBlock(0, 100);
        Block block1 = BlockAssertions.createLongDictionaryBlock(0, 100, 1);
        Block block2 = BlockAssertions.createLongDictionaryBlock(0, 100, 2);
        Block block3 = BlockAssertions.createLongDictionaryBlock(0, 100, 3);
        Block block4 = BlockAssertions.createLongDictionaryBlock(0, 100, 4);
        Page lowCardinalityPage = new Page(new Block[]{block1, block2, block3, block4});
        Page page = new Page(new Block[]{block1, block2, block3, block4, sameValueBlock});
        Work lowCardinalityWork = lowCardinalityGroupByHash.getGroupIds(lowCardinalityPage);
        Assertions.assertThat((Object)lowCardinalityWork).isInstanceOf(FlatGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        Work work = groupByHash.getGroupIds(page);
        lowCardinalityWork.process();
        work.process();
        Assertions.assertThat((int)lowCardinalityGroupByHash.getGroupCount()).isEqualTo(groupByHash.getGroupCount());
        int[] lowCardinalityResults = (int[])lowCardinalityWork.getResult();
        int[] results = (int[])work.getResult();
        Assertions.assertThat((int[])lowCardinalityResults).isEqualTo((Object)results);
    }

    @Test
    public void testLowCardinalityDictionariesProperGroupIdOrder() {
        int i;
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (boolean)false, (int)100, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)UpdateMemory.NOOP);
        LongArrayBlock dictionary = new LongArrayBlock(2, Optional.empty(), new long[]{0L, 1L});
        int[] ids = new int[32];
        for (int i2 = 0; i2 < 16; ++i2) {
            ids[i2] = 1;
        }
        Block block1 = DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
        Block block2 = DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
        Page page = new Page(new Block[]{block1, block2});
        Work work = groupByHash.getGroupIds(page);
        Assertions.assertThat((Object)work).isInstanceOf(FlatGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        work.process();
        int[] results = (int[])work.getResult();
        for (i = 0; i < 16; ++i) {
            Assertions.assertThat((int)results[i]).isEqualTo(0);
        }
        for (i = 16; i < 32; ++i) {
            Assertions.assertThat((int)results[i]).isEqualTo(1);
        }
    }

    @Test
    public void testProperWorkTypesSelected() {
        ValueBlock bigintBlock = BlockAssertions.createLongsBlock(1, 2, 3, 4, 5, 6, 7, 8);
        Block bigintDictionaryBlock = BlockAssertions.createLongDictionaryBlock(0, 8);
        Block bigintRleBlock = BlockAssertions.createRepeatedValuesBlock(42L, 8);
        VariableWidthBlock varcharBlock = BlockAssertions.createStringsBlock("1", "2", "3", "4", "5", "6", "7", "8");
        Block varcharDictionaryBlock = BlockAssertions.createStringDictionaryBlock(1, 8);
        Block varcharRleBlock = RunLengthEncodedBlock.create((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 1}, Optional.empty()), (int)8);
        Block bigintBigDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 8, 1000);
        Block bigintSingletonDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 500000, 1);
        Block bigintHugeDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 500000, 66000);
        Page singleBigintPage = new Page(new Block[]{bigintBlock});
        TestGroupByHash.assertGroupByHashWork(singleBigintPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetGroupIdsWork.class);
        Page singleBigintDictionaryPage = new Page(new Block[]{bigintDictionaryBlock});
        TestGroupByHash.assertGroupByHashWork(singleBigintDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetDictionaryGroupIdsWork.class);
        Page singleBigintRlePage = new Page(new Block[]{bigintRleBlock});
        TestGroupByHash.assertGroupByHashWork(singleBigintRlePage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
        Page singleVarcharPage = new Page(new Block[]{varcharBlock});
        TestGroupByHash.assertGroupByHashWork(singleVarcharPage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), FlatGroupByHash.GetNonDictionaryGroupIdsWork.class);
        Page singleVarcharDictionaryPage = new Page(new Block[]{varcharDictionaryBlock});
        TestGroupByHash.assertGroupByHashWork(singleVarcharDictionaryPage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), FlatGroupByHash.GetDictionaryGroupIdsWork.class);
        Page singleVarcharRlePage = new Page(new Block[]{varcharRleBlock});
        TestGroupByHash.assertGroupByHashWork(singleVarcharRlePage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), FlatGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
        Page lowCardinalityDictionaryPage = new Page(new Block[]{bigintDictionaryBlock, varcharDictionaryBlock});
        TestGroupByHash.assertGroupByHashWork(lowCardinalityDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), FlatGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        Page highCardinalityDictionaryPage = new Page(new Block[]{bigintDictionaryBlock, bigintBigDictionaryBlock});
        TestGroupByHash.assertGroupByHashWork(highCardinalityDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), FlatGroupByHash.GetNonDictionaryGroupIdsWork.class);
        Page lowCardinalityHugeDictionaryPage = new Page(new Block[]{bigintSingletonDictionaryBlock, bigintHugeDictionaryBlock});
        TestGroupByHash.assertGroupByHashWork(lowCardinalityHugeDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), FlatGroupByHash.GetNonDictionaryGroupIdsWork.class);
    }

    private static void assertGroupByHashWork(Page page, List<Type> types, Class<?> clazz) {
        GroupByHash groupByHash = GroupByHash.createGroupByHash(types, (boolean)false, (int)100, (boolean)true, (JoinCompiler)JOIN_COMPILER, (UpdateMemory)UpdateMemory.NOOP);
        Work work = groupByHash.getGroupIds(page);
        Assertions.assertThat((Object)work).isInstanceOf(clazz);
    }

    private static int[] getGroupIds(GroupByHash groupByHash, Page page) {
        Work work = groupByHash.getGroupIds(page);
        work.process();
        int[] groupIds = (int[])work.getResult();
        return groupIds;
    }

    private static enum GroupByHashType {
        BIGINT,
        FLAT;


        public GroupByHash createGroupByHash() {
            return this.createGroupByHash(100, UpdateMemory.NOOP);
        }

        public GroupByHash createGroupByHash(int expectedSize, UpdateMemory updateMemory) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new BigintGroupByHash(true, expectedSize, updateMemory);
                case 1 -> new FlatGroupByHash((List)ImmutableList.of((Object)BigintType.BIGINT), true, expectedSize, true, JOIN_COMPILER, updateMemory);
            };
        }
    }
}

