/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import io.trino.operator.aggregation.AbstractTestApproximateSetGeneric;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Test;

public class TestApproximateSetGenericBoolean
extends AbstractTestApproximateSetGeneric {
    @Override
    protected Type getValueType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    protected Object randomValue() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @Test
    public void testNonEmptyInputs() {
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true}), 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{false}), 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, false}), 2L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, true, true}), 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{false, false, false}), 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, false, true, false}), 2L);
    }

    @Override
    protected int getUniqueValuesCount() {
        return 2;
    }

    @Override
    protected List<Object> getResultStabilityTestSample() {
        return ImmutableList.of((Object)true, (Object)false);
    }

    @Override
    protected String getResultStabilityExpected() {
        return "020C020080034400802008DE";
    }
}

