/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLongDecimalWithOverflowStateSerializer {
    private static final LongDecimalWithOverflowStateFactory STATE_FACTORY = new LongDecimalWithOverflowStateFactory();

    @Test
    public void testSerde() {
        this.testSerde(3L, 0L, 0L, 1);
        this.testSerde(3L, 5L, 0L, 2);
        this.testSerde(3L, 5L, 7L, 3);
        this.testSerde(3L, 0L, 7L, 3);
        this.testSerde(0L, 0L, 0L, 1);
        this.testSerde(0L, 5L, 0L, 2);
        this.testSerde(0L, 5L, 7L, 3);
        this.testSerde(0L, 0L, 7L, 3);
    }

    private void testSerde(long low, long high, long overflow, int expectedLength) {
        LongDecimalWithOverflowState state = STATE_FACTORY.createSingleState();
        state.getDecimalArray()[0] = high;
        state.getDecimalArray()[1] = low;
        state.setOverflow(overflow);
        state.setNotNull();
        LongDecimalWithOverflowState outState = this.roundTrip(state, expectedLength);
        Assertions.assertThat((boolean)outState.isNotNull()).isTrue();
        Assertions.assertThat((long)outState.getDecimalArray()[0]).isEqualTo(high);
        Assertions.assertThat((long)outState.getDecimalArray()[1]).isEqualTo(low);
        Assertions.assertThat((long)outState.getOverflow()).isEqualTo(overflow);
    }

    @Test
    public void testNullSerde() {
        LongDecimalWithOverflowState state = STATE_FACTORY.createSingleState();
        LongDecimalWithOverflowState outState = this.roundTrip(state, 0);
        Assertions.assertThat((boolean)outState.isNotNull()).isFalse();
    }

    private LongDecimalWithOverflowState roundTrip(LongDecimalWithOverflowState state, int expectedLength) {
        LongDecimalWithOverflowStateSerializer serializer = new LongDecimalWithOverflowStateSerializer();
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 1, 0);
        serializer.serialize(state, (BlockBuilder)out);
        VariableWidthBlock serialized = out.buildValueBlock();
        Assertions.assertThat((int)serialized.getSliceLength(0)).isEqualTo(expectedLength * 8);
        LongDecimalWithOverflowState outState = STATE_FACTORY.createSingleState();
        serializer.deserialize((Block)serialized, 0, outState);
        return outState;
    }
}

