/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.project.PageFieldsToInputParametersRewriter;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.transaction.TestingTransactionManager;
import io.trino.type.FunctionType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPageFieldsToInputParametersRewriter {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final IrTypeAnalyzer TYPE_ANALYZER = new IrTypeAnalyzer(PLANNER_CONTEXT);
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction CEIL = FUNCTIONS.resolveFunction("ceil", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction ROUND = FUNCTIONS.resolveFunction("round", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction TRANSFORM = FUNCTIONS.resolveFunction("transform", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)IntegerType.INTEGER)}));
    private static final ResolvedFunction ZIP_WITH = FUNCTIONS.resolveFunction("zip_with", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT), new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (Type)IntegerType.INTEGER)}));

    @Test
    public void testEagerLoading() {
        RowExpressionBuilder builder = RowExpressionBuilder.create().addSymbol("bigint0", (Type)BigintType.BIGINT).addSymbol("bigint1", (Type)BigintType.BIGINT);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(5L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new Cast((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(10L)), (Type)IntegerType.INTEGER)), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(2L)), (Expression)new SymbolReference("bigint0"), new Expression[0])), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new InPredicate((Expression)new SymbolReference("bigint0"), (List)ImmutableList.of((Object)new GenericLiteral((Type)BigintType.BIGINT, "1"), (Object)new GenericLiteral((Type)BigintType.BIGINT, "2"), (Object)new GenericLiteral((Type)BigintType.BIGINT, "3")))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(0L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(0L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(10L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(0L)), (Expression)new SymbolReference("bigint0"))), Optional.of(new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT)))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new SimpleCaseExpression((Expression)new SymbolReference("bigint0"), (List)ImmutableList.of((Object)new WhenClause((Expression)new GenericLiteral((Type)BigintType.BIGINT, "1"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1"))), Optional.of(new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("bigint0"))))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(150000L)), (Expression)new LongLiteral(0L), (Expression)new LongLiteral(1L))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "150000")), (Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new CoalesceExpression((Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"), (Expression)new SymbolReference("bigint0"), new Expression[0]), (Expression)new SymbolReference("bigint0"))), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("bigint0"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2"), (Expression)new SymbolReference("bigint1")))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new NullIfExpression((Expression)new SymbolReference("bigint0"), (Expression)new SymbolReference("bigint1"))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new CoalesceExpression((Expression)new FunctionCall(CEIL.toQualifiedName(), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new SymbolReference("bigint0"), (Expression)new SymbolReference("bigint1")))), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"), new Expression[0])), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new SymbolReference("bigint1")), (Expression)new LongLiteral(1L))), Optional.of(new LongLiteral(0L)))), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), (Expression)new SymbolReference("bigint1"))), Optional.of(new GenericLiteral((Type)BigintType.BIGINT, "0")))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new CoalesceExpression((Expression)new FunctionCall(ROUND.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("bigint0"))), (Expression)new SymbolReference("bigint1"), new Expression[0])), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint1"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"))))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("bigint1"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"))))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("bigint0"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"), (Expression)new SymbolReference("bigint1"))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("bigint1"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "150000")), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0"), (Expression)new SymbolReference("bigint0"))), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        builder = RowExpressionBuilder.create().addSymbol("array_bigint0", (Type)new ArrayType((Type)BigintType.BIGINT)).addSymbol("array_bigint1", (Type)new ArrayType((Type)BigintType.BIGINT));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new FunctionCall(TRANSFORM.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("array_bigint0"), (Object)new LambdaExpression((List)ImmutableList.of((Object)"x"), (Expression)new LongLiteral(1L))))), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new FunctionCall(TRANSFORM.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("array_bigint0"), (Object)new LambdaExpression((List)ImmutableList.of((Object)"x"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new LongLiteral(2L), (Expression)new SymbolReference("x")))))), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression((Expression)new FunctionCall(ZIP_WITH.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("array_bigint0"), (Object)new SymbolReference("array_bigint1"), (Object)new LambdaExpression((List)ImmutableList.of((Object)"x", (Object)"y"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2"), (Expression)new SymbolReference("x")))))), 2, (Set<Integer>)ImmutableSet.of());
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount) {
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(rowExpression, columnCount, (Set)IntStream.range(0, columnCount).boxed().collect(ImmutableSet.toImmutableSet()));
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount, Set<Integer> eagerlyLoadedChannels) {
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters((RowExpression)rowExpression);
        Block[] blocks = new Block[columnCount];
        for (int channel = 0; channel < columnCount; ++channel) {
            blocks[channel] = TestPageFieldsToInputParametersRewriter.lazyWrapper((Block)BlockAssertions.createLongSequenceBlock(0, 100));
        }
        Page page = result.getInputChannels().getInputChannels(new Page(blocks));
        for (int channel = 0; channel < columnCount; ++channel) {
            Assertions.assertThat((boolean)page.getBlock(channel).isLoaded()).isEqualTo(eagerlyLoadedChannels.contains(channel));
        }
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static class RowExpressionBuilder {
        private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private final List<Type> types = new LinkedList<Type>();

        private RowExpressionBuilder() {
        }

        private static RowExpressionBuilder create() {
            return new RowExpressionBuilder();
        }

        private RowExpressionBuilder addSymbol(String name, Type type) {
            Symbol symbol = new Symbol(name);
            this.symbolTypes.put(symbol, type);
            this.sourceLayout.put(symbol, this.types.size());
            this.types.add(type);
            return this;
        }

        private RowExpression buildExpression(Expression expression) {
            return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)TYPE_ANALYZER.getTypes(SessionTestUtils.TEST_SESSION, TypeProvider.copyOf(this.symbolTypes), expression), this.sourceLayout, (Metadata)PLANNER_CONTEXT.getMetadata(), (FunctionManager)PLANNER_CONTEXT.getFunctionManager(), (TypeManager)PLANNER_CONTEXT.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (boolean)true);
        }
    }
}

