/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TestingTransactionManager;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionInterpreter {
    private static final TypeProvider SYMBOL_TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("bound_value"), (Object)IntegerType.INTEGER).put((Object)new Symbol("unbound_value"), (Object)IntegerType.INTEGER).buildOrThrow());
    private static final SymbolResolver INPUTS = symbol -> {
        if (symbol.getName().toLowerCase(Locale.ENGLISH).equals("bound_value")) {
            return 1234L;
        }
        return symbol.toSymbolReference();
    };
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ABS = FUNCTIONS.resolveFunction("abs", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));

    @Test
    public void testAnd() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)new NullLiteral())), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)new NullLiteral())), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())), (Expression)new NullLiteral());
    }

    @Test
    public void testOr() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)new NullLiteral())), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)new NullLiteral())), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)new NullLiteral());
    }

    @Test
    public void testComparison() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new NullLiteral(), (Expression)new NullLiteral()), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("a"), (Expression)new StringLiteral("b")), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("a"), (Expression)new StringLiteral("a")), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("a"), (Expression)new NullLiteral()), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new NullLiteral(), (Expression)new StringLiteral("a")), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(1234L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testIsDistinctFrom() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new NullLiteral(), (Expression)new NullLiteral()), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(3L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(3L), (Expression)new NullLiteral()), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new NullLiteral(), (Expression)new LongLiteral(3L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("unbound_value"), (Expression)new NullLiteral()), (Expression)new IsNotNullPredicate((Expression)new SymbolReference("unbound_value")));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new NullLiteral(), (Expression)new SymbolReference("unbound_value")), (Expression)new IsNotNullPredicate((Expression)new SymbolReference("unbound_value")));
    }

    @Test
    public void testIsNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new NullLiteral()), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new NullLiteral(), (Expression)new LongLiteral(1L))), (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testIsNotNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNotNullPredicate((Expression)new NullLiteral()), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNotNullPredicate((Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNotNullPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new NullLiteral(), (Expression)new LongLiteral(1L))), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testNullIf() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new StringLiteral("a"), (Expression)new StringLiteral("a")), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new StringLiteral("a"), (Expression)new StringLiteral("b")), (Expression)new StringLiteral("a"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new NullLiteral(), (Expression)new StringLiteral("b")), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new StringLiteral("a"), (Expression)new NullLiteral()), (Expression)new StringLiteral("a"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)), (Expression)new NullIfExpression((Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)));
    }

    @Test
    public void testNegative() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(-1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L))), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L))));
    }

    @Test
    public void testNot() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)BooleanLiteral.TRUE_LITERAL), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)BooleanLiteral.FALSE_LITERAL), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new NullLiteral()), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L))));
    }

    @Test
    public void testFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(ABS.toQualifiedName(), (List)ImmutableList.of((Object)new LongLiteral(-5L))), (Expression)new LongLiteral(5L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(ABS.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("unbound_value"))), (Expression)new FunctionCall(ABS.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("unbound_value"))));
    }

    @Test
    public void testNonDeterministicFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()));
    }

    @Test
    public void testBetween() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(3L), (Expression)new LongLiteral(2L), (Expression)new LongLiteral(4L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(2L), (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new NullLiteral(), (Expression)new LongLiteral(2L), (Expression)new LongLiteral(4L)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(3L), (Expression)new NullLiteral(), (Expression)new LongLiteral(4L)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(3L), (Expression)new LongLiteral(2L), (Expression)new NullLiteral()), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(2L), (Expression)new LongLiteral(3L), (Expression)new NullLiteral()), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new LongLiteral(8L), (Expression)new NullLiteral(), (Expression)new LongLiteral(6L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(1000L), (Expression)new LongLiteral(2000L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testIn() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(9L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER))), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference("bound_value"), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(1234L), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference("bound_value"), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(1234L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new SymbolReference("bound_value"), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(99L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new SymbolReference("bound_value"), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference("bound_value"), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new SymbolReference("bound_value"), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference("unbound_value"), (List)ImmutableList.of((Object)new LongLiteral(1L))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))), (Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))), (Expression)new InPredicate((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))), (Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))), (Expression)new InPredicate((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))), (Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new InPredicate((Expression)new LongLiteral(3L), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(0L)))))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))), (Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(3L), (Object)new LongLiteral(5L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L), (Object)new LongLiteral(2L), (Object)new LongLiteral(4L))), (Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(4L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(2L))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L)));
    }

    @Test
    public void testCastOptimization() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new SymbolReference("bound_value"), (Type)VarcharType.VARCHAR), (Expression)new StringLiteral("1234"));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Cast((Expression)new SymbolReference("unbound_value"), (Type)IntegerType.INTEGER), (Expression)new SymbolReference("unbound_value"));
    }

    @Test
    public void testTryCast() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT, true), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new LongLiteral(123L), (Type)BigintType.BIGINT, true), (Expression)new LongLiteral(123L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER, true), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new LongLiteral(123L), (Type)IntegerType.INTEGER, true), (Expression)new LongLiteral(123L));
    }

    @Test
    public void testSearchCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(33L))), Optional.empty()), (Expression)new LongLiteral(33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L))), Optional.of(new LongLiteral(33L))), (Expression)new LongLiteral(33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(1234L)), (Expression)new LongLiteral(33L))), Optional.empty()), (Expression)new LongLiteral(33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("bound_value"))), Optional.empty()), (Expression)new LongLiteral(1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L))), Optional.of(new SymbolReference("bound_value"))), (Expression)new LongLiteral(1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(1234L)), (Expression)new LongLiteral(33L))), Optional.of(new SymbolReference("unbound_value"))), (Expression)new LongLiteral(33L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L))), Optional.empty()), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new StringLiteral("a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("b"))), Optional.of(new StringLiteral("c"))), (Expression)new StringLiteral("a"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a")), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new StringLiteral("b"))), Optional.of(new StringLiteral("c"))), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a"))), Optional.of(new StringLiteral("b"))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new StringLiteral("b"))), Optional.of(new StringLiteral("c"))), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a"))), Optional.of(new StringLiteral("c"))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new StringLiteral("b"))), Optional.empty()), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new StringLiteral("a"))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L))), Optional.empty()), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(2L))), Optional.of(new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(1L))), Optional.of(new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), (Expression)new LongLiteral(1L));
    }

    @Test
    public void testSimpleCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(33L)), (Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(34L))), Optional.empty()), (Expression)new LongLiteral(33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(33L))), Optional.empty()), (Expression)new NullLiteral());
        for (SimpleCaseExpression simpleCaseExpression : Arrays.asList(new SimpleCaseExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(33L))), Optional.of(new LongLiteral(33L))), new SimpleCaseExpression((Expression)new LongLiteral(33L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new LongLiteral(1L))), Optional.of(new LongLiteral(33L))), new SimpleCaseExpression((Expression)new SymbolReference("bound_value"), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1234L), (Expression)new LongLiteral(33L))), Optional.empty()), new SimpleCaseExpression((Expression)new LongLiteral(1234L), (List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference("bound_value"), (Expression)new LongLiteral(33L))), Optional.empty()))) {
            TestExpressionInterpreter.assertOptimizedEquals((Expression)simpleCaseExpression, (Expression)new LongLiteral(33L));
        }
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("bound_value"))), Optional.empty()), (Expression)new LongLiteral(1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L))), Optional.of(new SymbolReference("bound_value"))), (Expression)new LongLiteral(1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(33L))), (Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(33L))));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(1L))), (Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(1L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), Optional.of(new LongLiteral(1L))), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))), Optional.of(new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(3L))), (Expression)new SimpleCaseExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(3L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(3L))), (Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.of(new LongLiteral(3L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(2L), (Expression)new LongLiteral(2L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(3L))), Optional.of(new LongLiteral(4L))), (Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(3L))), Optional.of(new LongLiteral(4L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.empty()), (Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(2L), (Expression)new LongLiteral(2L)), (Object)new WhenClause((Expression)new LongLiteral(3L), (Expression)new LongLiteral(3L))), Optional.empty()), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), Optional.of(new LongLiteral(1L))), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(2L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), Optional.of(new LongLiteral(3L))), (Expression)new LongLiteral(3L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), (Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), Optional.empty()), (Expression)new LongLiteral(2L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new LongLiteral(1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))), Optional.of(new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))), (Expression)new LongLiteral(2L));
    }

    @Test
    public void testCoalesce() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("unbound_value"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new LongLiteral(2L), (Expression)new LongLiteral(3L))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(1L)), new Expression[]{new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("unbound_value"), (Expression)new LongLiteral(6L)), (Expression)new LongLiteral(0L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new CoalesceExpression((Expression)new SymbolReference("unbound_value"), (Expression)new SymbolReference("unbound_value"), new Expression[0]), (Expression)new SymbolReference("unbound_value"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new LongLiteral(6L), (Expression)new SymbolReference("unbound_value"), new Expression[0]), (Expression)new LongLiteral(6L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), new Expression[]{new DoubleLiteral(5.0)}), (Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), new Expression[]{new DoubleLiteral(5.0)}));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new NullLiteral(), (Expression)new CoalesceExpression((Expression)new NullLiteral(), (Expression)new NullLiteral(), new Expression[0]), new Expression[0]), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new CoalesceExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new CoalesceExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), new Expression[]{new LongLiteral(1L)}), new Expression[0]), new Expression[0]), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), new Expression[0]), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), new Expression[0]), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), new Expression[]{new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new LongLiteral(1L), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(2L), new Expression[0]), new Expression[0]), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), new Expression[]{new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(0L)), new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(0L)), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), new Expression[]{new DoubleLiteral(1.0), new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of())}), (Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of()), new Expression[]{new DoubleLiteral(1.0)}));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new CoalesceExpression((Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), new Expression[0]), (Expression)new LongLiteral(1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), new Expression[0]))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testIf() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(2L), (Expression)new LongLiteral(2L)), (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(3L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(4L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(3L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(4L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (Expression)new LongLiteral(3L), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(4L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(3L), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)), (Expression)new LongLiteral(3L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(3L), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new LongLiteral(4L)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new LongLiteral(4L)), (Expression)new LongLiteral(4L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER), (Expression)new Cast((Expression)new NullLiteral(), (Type)IntegerType.INTEGER)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), (Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new LongLiteral(1L), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L))), (Expression)new LongLiteral(1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testOptimizeDivideByZero() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testRowSubscript() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("a"), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)new LongLiteral(3L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Expression)new SubscriptExpression((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("a"), (Object)new Row((List)ImmutableList.of((Object)new LongLiteral(2L), (Object)new StringLiteral("b"), (Object)new Row((List)ImmutableList.of((Object)new LongLiteral(3L), (Object)new StringLiteral("c"))))))), (Expression)new LongLiteral(3L)), (Expression)new LongLiteral(3L)), (Expression)new LongLiteral(2L)), (Expression)new StringLiteral("c"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new NullLiteral())), (Expression)new LongLiteral(2L)), (Expression)new NullLiteral());
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(1L)), (Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(2L)), (Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(2L)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(0L), (Expression)new LongLiteral(0L)), (Object)new LongLiteral(1L))), (Expression)new LongLiteral(2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    private static void assertOptimizedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.optimize(actual)).isEqualTo(TestExpressionInterpreter.optimize(expected));
    }

    private static void assertOptimizedMatches(Expression actual, Expression expected) {
        Expression actualOptimized = (Expression)TestExpressionInterpreter.optimize(actual);
        SymbolAliases.Builder aliases = SymbolAliases.builder().putAll((Map)SYMBOL_TYPES.allTypes().keySet().stream().map(Symbol::getName).collect(ImmutableMap.toImmutableMap(Function.identity(), SymbolReference::new)));
        ExpressionTestUtils.assertExpressionEquals(actualOptimized, expected, aliases.build());
    }

    static Object optimize(Expression parsedExpression) {
        Map expressionTypes = new IrTypeAnalyzer(PLANNER_CONTEXT).getTypes(SessionTestUtils.TEST_SESSION, SYMBOL_TYPES, parsedExpression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(parsedExpression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, expressionTypes);
        return interpreter.optimize(INPUTS);
    }

    private static void assertEvaluatedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.evaluate(actual)).isEqualTo(TestExpressionInterpreter.evaluate(expected));
    }

    private static Object evaluate(Expression expression) {
        Map expressionTypes = new IrTypeAnalyzer(PLANNER_CONTEXT).getTypes(SessionTestUtils.TEST_SESSION, SYMBOL_TYPES, expression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, expressionTypes);
        return interpreter.evaluate(INPUTS);
    }
}

