/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.index.PageRecordSet;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.testing.TestingSession;
import io.trino.transaction.TestingTransactionManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPageProcessor2 {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction CONCAT = FUNCTIONS.resolveFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final IrTypeAnalyzer TYPE_ANALYZER = new IrTypeAnalyzer(PLANNER_CONTEXT);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int POSITIONS = 1024;
    private final DriverYieldSignal yieldSignal = new DriverYieldSignal();
    private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
    private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
    private CursorProcessor cursorProcessor;
    private PageProcessor pageProcessor;
    private Page inputPage;
    private RecordSet recordSet;
    private List<Type> types;
    @Param(value={"2", "4", "8", "16", "32"})
    int columnCount;
    @Param(value={"varchar", "bigint"})
    String type;
    @Param(value={"false", "true"})
    boolean dictionaryBlocks;

    @Setup
    public void setup() {
        Type type = TYPE_MAP.get(this.type);
        for (int i = 0; i < this.columnCount; ++i) {
            Symbol symbol = new Symbol(type.getDisplayName().toLowerCase(Locale.ENGLISH) + i);
            this.symbolTypes.put(symbol, type);
            this.sourceLayout.put(symbol, i);
        }
        List<RowExpression> projections = this.getProjections(type);
        this.types = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
        FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(functionManager, 0);
        this.inputPage = BenchmarkPageProcessor2.createPage(this.types, this.dictionaryBlocks);
        this.pageProcessor = (PageProcessor)new ExpressionCompiler(functionManager, pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
        this.recordSet = new PageRecordSet(this.types, this.inputPage);
        this.cursorProcessor = (CursorProcessor)new ExpressionCompiler(functionManager, pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
    }

    @Benchmark
    public Page rowOriented() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        this.cursorProcessor.process(null, this.yieldSignal, this.recordSet.cursor(), pageBuilder);
        return pageBuilder.build();
    }

    @Benchmark
    public List<Optional<Page>> columnOriented() {
        return ImmutableList.copyOf((Iterator)this.pageProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    private RowExpression getFilter(Type type) {
        if (type == VarcharType.VARCHAR) {
            return this.rowExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new Cast((Expression)new SymbolReference("varchar0"), (Type)BigintType.BIGINT), (Expression)new LongLiteral(2L)), (Expression)new LongLiteral(0L)));
        }
        if (type == BigintType.BIGINT) {
            return this.rowExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("bigint0"), (Expression)new LongLiteral(2L)), (Expression)new LongLiteral(0L)));
        }
        throw new IllegalArgumentException("filter not supported for type : " + String.valueOf(type));
    }

    private List<RowExpression> getProjections(Type type) {
        ImmutableList.Builder builder;
        block3: {
            block2: {
                builder = ImmutableList.builder();
                if (type != BigintType.BIGINT) break block2;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("bigint" + i), (Expression)new LongLiteral(5L))));
                }
                break block3;
            }
            if (type != VarcharType.VARCHAR) break block3;
            for (int i = 0; i < this.columnCount; ++i) {
                builder.add((Object)this.rowExpression((Expression)new FunctionCall(CONCAT.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("varchar" + i), (Object)new StringLiteral("foo")))));
            }
        }
        return builder.build();
    }

    private RowExpression rowExpression(Expression expression) {
        Map expressionTypes = TYPE_ANALYZER.getTypes(TEST_SESSION, TypeProvider.copyOf(this.symbolTypes), expression);
        return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, this.sourceLayout, (Metadata)PLANNER_CONTEXT.getMetadata(), (FunctionManager)PLANNER_CONTEXT.getFunctionManager(), (TypeManager)PLANNER_CONTEXT.getTypeManager(), (Session)TEST_SESSION, (boolean)true);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        if (dictionary) {
            return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 1024);
        }
        return SequencePageBuilder.createSequencePage(types, 1024);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkPageProcessor2.class).run();
    }
}

