/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.Literal;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.ColorType;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import io.trino.type.TypeCoercion;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDomainTranslator {
    private static final Symbol C_BIGINT = new Symbol("c_bigint");
    private static final Symbol C_DOUBLE = new Symbol("c_double");
    private static final Symbol C_VARCHAR = new Symbol("c_varchar");
    private static final Symbol C_BOOLEAN = new Symbol("c_boolean");
    private static final Symbol C_BIGINT_1 = new Symbol("c_bigint_1");
    private static final Symbol C_DOUBLE_1 = new Symbol("c_double_1");
    private static final Symbol C_VARCHAR_1 = new Symbol("c_varchar_1");
    private static final Symbol C_BOOLEAN_1 = new Symbol("c_boolean_1");
    private static final Symbol C_TIMESTAMP = new Symbol("c_timestamp");
    private static final Symbol C_DATE = new Symbol("c_date");
    private static final Symbol C_COLOR = new Symbol("c_color");
    private static final Symbol C_HYPER_LOG_LOG = new Symbol("c_hyper_log_log");
    private static final Symbol C_VARBINARY = new Symbol("c_varbinary");
    private static final Symbol C_DECIMAL_26_5 = new Symbol("c_decimal_26_5");
    private static final Symbol C_DECIMAL_23_4 = new Symbol("c_decimal_23_4");
    private static final Symbol C_INTEGER = new Symbol("c_integer");
    private static final Symbol C_INTEGER_1 = new Symbol("c_integer_1");
    private static final Symbol C_CHAR = new Symbol("c_char");
    private static final Symbol C_DECIMAL_21_3 = new Symbol("c_decimal_21_3");
    private static final Symbol C_DECIMAL_21_3_1 = new Symbol("c_decimal_21_3_1");
    private static final Symbol C_DECIMAL_12_2 = new Symbol("c_decimal_12_2");
    private static final Symbol C_DECIMAL_6_1 = new Symbol("c_decimal_6_1");
    private static final Symbol C_DECIMAL_6_1_1 = new Symbol("c_decimal_6_1_1");
    private static final Symbol C_DECIMAL_3_0 = new Symbol("c_decimal_3_0");
    private static final Symbol C_DECIMAL_2_0 = new Symbol("c_decimal_2_0");
    private static final Symbol C_SMALLINT = new Symbol("c_smallint");
    private static final Symbol C_TINYINT = new Symbol("c_tinyint");
    private static final Symbol C_REAL = new Symbol("c_real");
    private static final Symbol C_REAL_1 = new Symbol("c_real_1");
    private static final TypeProvider TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)BigintType.BIGINT).put((Object)C_DOUBLE, (Object)DoubleType.DOUBLE).put((Object)C_VARCHAR, (Object)VarcharType.VARCHAR).put((Object)C_BOOLEAN, (Object)BooleanType.BOOLEAN).put((Object)C_BIGINT_1, (Object)BigintType.BIGINT).put((Object)C_DOUBLE_1, (Object)DoubleType.DOUBLE).put((Object)C_VARCHAR_1, (Object)VarcharType.VARCHAR).put((Object)C_BOOLEAN_1, (Object)BooleanType.BOOLEAN).put((Object)C_TIMESTAMP, (Object)TimestampType.TIMESTAMP_MILLIS).put((Object)C_DATE, (Object)DateType.DATE).put((Object)C_COLOR, (Object)ColorType.COLOR).put((Object)C_HYPER_LOG_LOG, (Object)HyperLogLogType.HYPER_LOG_LOG).put((Object)C_VARBINARY, (Object)VarbinaryType.VARBINARY).put((Object)C_DECIMAL_26_5, (Object)DecimalType.createDecimalType((int)26, (int)5)).put((Object)C_DECIMAL_23_4, (Object)DecimalType.createDecimalType((int)23, (int)4)).put((Object)C_INTEGER, (Object)IntegerType.INTEGER).put((Object)C_INTEGER_1, (Object)IntegerType.INTEGER).put((Object)C_CHAR, (Object)CharType.createCharType((int)10)).put((Object)C_DECIMAL_21_3, (Object)DecimalType.createDecimalType((int)21, (int)3)).put((Object)C_DECIMAL_21_3_1, (Object)DecimalType.createDecimalType((int)21, (int)3)).put((Object)C_DECIMAL_12_2, (Object)DecimalType.createDecimalType((int)12, (int)2)).put((Object)C_DECIMAL_6_1, (Object)DecimalType.createDecimalType((int)6, (int)1)).put((Object)C_DECIMAL_6_1_1, (Object)DecimalType.createDecimalType((int)6, (int)1)).put((Object)C_DECIMAL_3_0, (Object)DecimalType.createDecimalType((int)3, (int)0)).put((Object)C_DECIMAL_2_0, (Object)DecimalType.createDecimalType((int)2, (int)0)).put((Object)C_SMALLINT, (Object)SmallintType.SMALLINT).put((Object)C_TINYINT, (Object)TinyintType.TINYINT).put((Object)C_REAL, (Object)RealType.REAL).put((Object)C_REAL_1, (Object)RealType.REAL).buildOrThrow());
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = TimeUnit.MILLISECONDS.toDays(new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis());
    private static final long COLOR_VALUE_1 = 1L;
    private static final long COLOR_VALUE_2 = 2L;
    private TestingFunctionResolution functionResolution;
    private LiteralEncoder literalEncoder;
    private DomainTranslator domainTranslator;

    @BeforeAll
    public void setup() {
        this.functionResolution = new TestingFunctionResolution();
        this.literalEncoder = new LiteralEncoder(this.functionResolution.getPlannerContext());
        this.domainTranslator = new DomainTranslator(this.functionResolution.getPlannerContext());
    }

    @AfterAll
    public void tearDown() {
        this.functionResolution = null;
        this.literalEncoder = null;
        this.domainTranslator = null;
    }

    @Test
    public void testNoneRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.none();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.all();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)).put((Object)C_BIGINT_1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)C_DOUBLE_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)1.1), (Range[])new Range[]{Range.equal((Type)DoubleType.DOUBLE, (Object)2.0), Range.range((Type)DoubleType.DOUBLE, (Object)3.0, (boolean)false, (Object)3.5, (boolean)true)}), (boolean)true)).put((Object)C_VARCHAR_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)C_TIMESTAMP, (Object)Domain.singleValue((Type)TimestampType.TIMESTAMP_MILLIS, (Object)TIMESTAMP_VALUE)).put((Object)C_DATE, (Object)Domain.singleValue((Type)DateType.DATE, (Object)DATE_VALUE)).put((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L)).put((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)).buildOrThrow());
        this.assertPredicateTranslates(this.toPredicate(tupleDomain), tupleDomain);
    }

    @Test
    public void testInOptimization() {
        Domain testDomain = Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)})), (boolean)false);
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)true, (Object)7L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)true)}), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(3L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L), (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L), (Expression)TestDomainTranslator.bigintLiteral(11L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[0])), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L), (Expression)TestDomainTranslator.bigintLiteral(9L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)11L, (boolean)false, (Object)13L, (boolean)false)})), (boolean)false);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, testDomain);
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(11L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(13L))})}));
    }

    @Test
    public void testToPredicateNone() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.none((Type)BooleanType.BOOLEAN)).buildOrThrow());
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testToPredicateAllIgnored() {
        TupleDomain tupleDomain = TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.all((Type)BooleanType.BOOLEAN)).buildOrThrow());
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate(tupleDomain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).buildOrThrow()));
    }

    @Test
    public void testToPredicate() {
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNotNull(C_BIGINT));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNull(C_BIGINT));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.none((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)BooleanLiteral.FALSE_LITERAL);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(0L)), TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.isNull(C_BIGINT)}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L)), TestDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L))), TestDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNull(C_HYPER_LOG_LOG));
        tupleDomain = TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG));
    }

    @Test
    public void testToPredicateWithRangeOptimisation() {
        TupleDomain<Symbol> tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)0L, (Object)1L))));
        tupleDomain = TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(0L))}), TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)RealType.REAL, (Object)0L)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("0.0")), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("0.0"))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)0L, (boolean)false, (Object)Float.floatToIntBits(1.0f), (boolean)false), Range.greaterThan((Type)RealType.REAL, (Object)Float.floatToIntBits(1.0f))}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("0.0")), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("0.0")), TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("1.0"))}), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("1.0"))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_REAL, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)0L), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)0L, (boolean)false, (Object)Float.floatToIntBits(1.0f), (boolean)false), Range.greaterThan((Type)RealType.REAL, (Object)Float.floatToIntBits(2.0f))}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("1.0")), TestDomainTranslator.notEqual(C_REAL, TestDomainTranslator.realLiteral("0.0"))}), TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("2.0"))}));
        tupleDomain = TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)false, (Object)1.0, (boolean)false), Range.range((Type)DoubleType.DOUBLE, (Object)2.0, (boolean)false, (Object)3.0, (boolean)false), Range.greaterThan((Type)DoubleType.DOUBLE, (Object)3.0)}), (boolean)false));
        Assertions.assertThat((Object)this.toPredicate(tupleDomain)).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.notEqual(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(0.0))}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.notEqual(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(3.0))})}));
    }

    @Test
    public void testFromUnknownPredicate() {
        this.assertUnsupportedPredicate(TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
    }

    @Test
    public void testFromAndPredicate() {
        Expression originalPredicate = IrUtils.and((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})})));
        originalPredicate = TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testFromOrPredicate() {
        Expression originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(20L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(10L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertUnsupportedPredicate(IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})}));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(5.0))});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("2.0")), TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("5.0")), TestDomainTranslator.isNull(C_REAL)});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_DOUBLE)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(5.0)), TestDomainTranslator.unprocessableExpression1(C_DOUBLE)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_REAL, TestDomainTranslator.realLiteral("2.0")), TestDomainTranslator.unprocessableExpression1(C_REAL)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_REAL, TestDomainTranslator.realLiteral("5.0")), TestDomainTranslator.unprocessableExpression1(C_REAL)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false), C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)1.0), (Range[])new Range[0]), (boolean)false)));
        originalPredicate = IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), this.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), this.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        originalPredicate = TestDomainTranslator.not(IrUtils.or((Expression[])new Expression[]{IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        Assertions.assertThat((boolean)result.getTupleDomain().isAll()).isTrue();
        originalPredicate = TestDomainTranslator.not(IrUtils.or((Expression[])new Expression[]{TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testFromSingleBooleanReference() {
        SymbolReference originalPredicate = C_BOOLEAN.toSymbolReference();
        DomainTranslator.ExtractionResult result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]), (boolean)false)));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        originalPredicate = TestDomainTranslator.not((Expression)C_BOOLEAN.toSymbolReference());
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]).complement(), (boolean)false)));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        originalPredicate = IrUtils.and((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()});
        result = this.fromPredicate((Expression)originalPredicate);
        Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[0]), (boolean)false);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_BOOLEAN, domain, C_BOOLEAN_1, domain));
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        originalPredicate = IrUtils.or((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()});
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
        originalPredicate = TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{C_BOOLEAN.toSymbolReference(), C_BOOLEAN_1.toSymbolReference()}));
        result = this.fromPredicate((Expression)originalPredicate);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo((Object)TupleDomain.all());
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)originalPredicate);
    }

    @Test
    public void testFromCastOfNullPredicate() {
        this.assertPredicateIsAlwaysFalse(TestDomainTranslator.cast((Expression)TestDomainTranslator.nullLiteral(), (Type)BooleanType.BOOLEAN));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not(TestDomainTranslator.cast((Expression)TestDomainTranslator.nullLiteral(), (Type)BooleanType.BOOLEAN)));
    }

    @Test
    public void testFromNotPredicate() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false)));
    }

    @Test
    public void testFromUnprocessableComparison() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT))));
    }

    @Test
    public void testFromBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, this.colorLiteral(1L)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
    }

    @Test
    public void testFromFlippedBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, this.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT), (Expression)C_BIGINT.toSymbolReference()), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.nullLiteral((Type)VarcharType.VARCHAR)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.none((Type)VarcharType.VARCHAR), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)), TestDomainTranslator.tupleDomain(C_COLOR, Domain.notNull((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.onlyNull((Type)ColorType.COLOR)));
    }

    @Test
    public void testFromBasicComparisonsWithNaN() {
        Expression nanDouble = this.literalEncoder.toExpression((Object)Double.NaN, (Type)DoubleType.DOUBLE);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_DOUBLE, nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_DOUBLE, nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_DOUBLE, nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_DOUBLE, nanDouble));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_DOUBLE, nanDouble), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isDistinctFrom(C_DOUBLE, nanDouble));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_DOUBLE, nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_DOUBLE, nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_DOUBLE, nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_DOUBLE, nanDouble)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.notNull((Type)DoubleType.DOUBLE)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_DOUBLE, nanDouble)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_DOUBLE, nanDouble)));
        Expression nanReal = this.literalEncoder.toExpression((Object)Float.floatToIntBits(Float.NaN), (Type)RealType.REAL);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_REAL, nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_REAL, nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_REAL, nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_REAL, nanReal));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_REAL, nanReal));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_REAL, nanReal), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isDistinctFrom(C_REAL, nanReal));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_REAL, nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_REAL, nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_REAL, nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_REAL, nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_REAL, nanReal)), TestDomainTranslator.tupleDomain(C_REAL, Domain.notNull((Type)RealType.REAL)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_REAL, nanReal)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_REAL, nanReal)));
    }

    @Test
    public void testFromCoercionComparisonsWithNaN() {
        Expression nanDouble = this.literalEncoder.toExpression((Object)Double.NaN, (Type)DoubleType.DOUBLE);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_TINYINT, (Type)DoubleType.DOUBLE), nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_SMALLINT, (Type)DoubleType.DOUBLE), nanDouble));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), nanDouble));
    }

    @Test
    public void testNonImplicitCastOnSymbolSide() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_TIMESTAMP, (Type)DateType.DATE), this.toExpression(DATE_VALUE, (Type)DateType.DATE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_DECIMAL_12_2, (Type)BigintType.BIGINT), (Expression)TestDomainTranslator.bigintLiteral(135L)));
    }

    @Test
    public void testNoSaturatedFloorCastFromUnsupportedApproximateDomain() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_DECIMAL_12_2, (Type)DoubleType.DOUBLE), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_BIGINT, (Type)DoubleType.DOUBLE), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_BIGINT, (Type)RealType.REAL), this.toExpression(TestDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)RealType.REAL), this.toExpression(TestDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
    }

    @Test
    public void testFromComparisonsWithCoercions() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.none((Type)IntegerType.INTEGER)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.notNull((Type)IntegerType.INTEGER)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)true)));
        this.assertPredicateIsAlwaysTrue((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE)), TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR))), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.notNull((Type)IntegerType.INTEGER)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.none((Type)IntegerType.INTEGER)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))));
    }

    @Test
    public void testPredicateWithVarcharCastToDate() {
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, " +2005-9-10  \t")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-10"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-11"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-10"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-11"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-09")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-09"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-0:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-9"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-09"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-0:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-9"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-:"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-19")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-19"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-09-1:"), (boolean)false), Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-19"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-1:"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, " +2005-9-10  \t")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-10")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-11"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-10"), (boolean)false), Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-11"))}), (boolean)false)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, " +2005-9-2  \t")));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-09")));
        this.assertPredicateDerives((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-19")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-19")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-09-1:"), (boolean)true, (Object)Slices.utf8Slice((String)"2005-9-19"), (boolean)false), Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2005-9-1:"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, " +2005-9-10  \t")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2006")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)));
        this.assertPredicateDerives((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, " +2005-9-10  \t")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2004"))}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan((Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2002")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)), (Expression)TestDomainTranslator.greaterThan((Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-10")), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2000"), (boolean)false, (Object)Slices.utf8Slice((String)"2006"), (boolean)false), Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false)), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31")), TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), (Expression)new GenericLiteral((Type)DateType.DATE, "2005-09-10"))}));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between((Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE), TestDomainTranslator.cast(C_VARCHAR_1, (Type)DateType.DATE)), TestDomainTranslator.tupleDomain(C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2002")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"9"))}), (boolean)false), C_VARCHAR_1, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2000"))}), (boolean)false)), IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThanOrEqual((Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), TestDomainTranslator.cast(C_VARCHAR, (Type)DateType.DATE)), TestDomainTranslator.lessThanOrEqual((Expression)new GenericLiteral((Type)DateType.DATE, "2001-01-31"), TestDomainTranslator.cast(C_VARCHAR_1, (Type)DateType.DATE))}));
    }

    @Test
    public void testFromUnprocessableInPredicate() {
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestDomainTranslator.unprocessableExpression1(C_BIGINT), (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL)));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN)))), TestDomainTranslator.tupleDomain(C_BOOLEAN, Domain.notNull((Type)BooleanType.BOOLEAN)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BOOLEAN, TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))));
    }

    @Test
    public void testInPredicateWithBoolean() {
        this.testInPredicate(C_BOOLEAN, C_BOOLEAN_1, (Type)BooleanType.BOOLEAN, false, true);
    }

    @Test
    public void testInPredicateWithInteger() {
        this.testInPredicate(C_INTEGER, C_INTEGER_1, (Type)IntegerType.INTEGER, 1L, 2L);
    }

    @Test
    public void testInPredicateWithBigint() {
        this.testInPredicate(C_BIGINT, C_BIGINT_1, (Type)BigintType.BIGINT, 1L, 2L);
    }

    @Test
    public void testInPredicateWithReal() {
        this.testInPredicateWithFloatingPoint(C_REAL, C_REAL_1, (Type)RealType.REAL, Float.floatToIntBits(1.0f), Float.floatToIntBits(2.0f), Float.floatToIntBits(Float.NaN));
    }

    @Test
    public void testInPredicateWithDouble() {
        this.testInPredicateWithFloatingPoint(C_DOUBLE, C_DOUBLE_1, (Type)DoubleType.DOUBLE, 1.0, 2.0, Double.NaN);
    }

    @Test
    public void testInPredicateWithShortDecimal() {
        this.testInPredicate(C_DECIMAL_6_1, C_DECIMAL_6_1_1, (Type)DecimalType.createDecimalType((int)6, (int)1), 10L, 20L);
    }

    @Test
    public void testInPredicateWithLongDecimal() {
        this.testInPredicate(C_DECIMAL_21_3, C_DECIMAL_21_3_1, (Type)DecimalType.createDecimalType((int)21, (int)3), Decimals.encodeScaledValue((BigDecimal)BigDecimal.ONE, (int)3), Decimals.encodeScaledValue((BigDecimal)BigDecimal.TWO, (int)3));
    }

    @Test
    public void testInPredicateWithVarchar() {
        this.testInPredicate(C_VARCHAR, C_VARCHAR_1, (Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"first"), Slices.utf8Slice((String)"second"));
    }

    private void testInPredicate(Symbol symbol, Symbol symbol2, Type type, Object one, Object two) {
        Expression oneExpression = this.literalEncoder.toExpression(one, type);
        Expression twoExpression = this.literalEncoder.toExpression(two, type);
        Expression nullExpression = this.literalEncoder.toExpression(null, type);
        SymbolReference otherSymbol = symbol2.toSymbolReference();
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.singleValue((Type)type, (Object)one)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(otherSymbol)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)one)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.range((Type)type, (Object)one, (boolean)false, (Object)two, (boolean)false), Range.greaterThan((Type)type, (Object)two)}), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nullExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression))), (TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(otherSymbol))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)one), (Range[])new Range[]{Range.range((Type)type, (Object)one, (boolean)false, (Object)two, (boolean)false), Range.greaterThan((Type)type, (Object)two)}), (boolean)false)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression))));
    }

    private void testInPredicateWithFloatingPoint(Symbol symbol, Symbol symbol2, Type type, Object one, Object two, Object nan) {
        Expression oneExpression = this.literalEncoder.toExpression(one, type);
        Expression twoExpression = this.literalEncoder.toExpression(two, type);
        Expression nanExpression = this.literalEncoder.toExpression(nan, type);
        Expression nullExpression = this.literalEncoder.toExpression(null, type);
        SymbolReference otherSymbol = symbol2.toSymbolReference();
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.singleValue((Type)type, (Object)one)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nanExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(symbol, List.of(nanExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression, nullExpression)), TestDomainTranslator.tupleDomain(symbol, Domain.multipleValues((Type)type, List.of(one, two))));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(otherSymbol)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nanExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression)));
        this.assertUnsupportedPredicate((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, nanExpression, twoExpression, nullExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, oneExpression)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nullExpression, twoExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nanExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(nanExpression, nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, nanExpression, twoExpression, nullExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(otherSymbol))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(symbol, (Expression)otherSymbol)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nanExpression))), TestDomainTranslator.tupleDomain(symbol, Domain.notNull((Type)type)), (Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, twoExpression, nullExpression))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(symbol, List.of(oneExpression, otherSymbol, nanExpression, twoExpression, nullExpression))));
    }

    @Test
    public void testInPredicateWithEquitableType() {
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.singleValue((Type)ColorType.COLOR, (Object)1L)));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)this.colorLiteral(1L), (Object)this.colorLiteral(2L)))), TestDomainTranslator.tupleDomain(C_COLOR, Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false)));
    }

    @Test
    public void testInPredicateWithCasts() {
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(1L, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertPredicateTranslates((Expression)new InPredicate(TestDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (List)ImmutableList.of((Object)this.toExpression(1L, (Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_SMALLINT, Domain.singleValue((Type)SmallintType.SMALLINT, (Object)1L)));
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestDomainTranslator.cast(C_BIGINT, (Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)this.toExpression(1L, (Type)IntegerType.INTEGER))));
    }

    @Test
    public void testFromInPredicateWithCastsAndNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)new InPredicate(TestDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (List)ImmutableList.of((Object)this.toExpression(null, (Type)BigintType.BIGINT)))));
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)BigintType.BIGINT)))));
    }

    @Test
    public void testFromBetweenPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), TestDomainTranslator.tupleDomain(C_INTEGER, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testFromIsNullPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_BIGINT), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG)), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testFromIsNotNullPredicate() {
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_BIGINT), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.notNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_BIGINT)), TestDomainTranslator.tupleDomain(C_BIGINT, Domain.onlyNull((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG)), TestDomainTranslator.tupleDomain(C_HYPER_LOG_LOG, Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testFromBooleanLiteralPredicate() {
        this.assertPredicateIsAlwaysTrue((Expression)BooleanLiteral.TRUE_LITERAL);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateIsAlwaysFalse((Expression)BooleanLiteral.FALSE_LITERAL);
        this.assertPredicateIsAlwaysTrue((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.FALSE_LITERAL));
    }

    @Test
    public void testFromNullLiteralPredicate() {
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.nullLiteral());
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.nullLiteral()));
    }

    @Test
    public void testExpressionConstantFolding() {
        FunctionCall fromHex = this.functionResolution.functionCallBuilder("from_hex").addArgument((Type)VarcharType.VARCHAR, (Expression)TestDomainTranslator.stringLiteral("123456")).build();
        ComparisonExpression originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_VARBINARY.toSymbolReference(), (Expression)fromHex);
        DomainTranslator.ExtractionResult result = this.fromPredicate((Expression)originalExpression);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Slice value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)"123456"));
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(TestDomainTranslator.tupleDomain(C_VARBINARY, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarbinaryType.VARBINARY, (Object)value), (Range[])new Range[0]), (boolean)false)));
        Expression expression = this.toPredicate((TupleDomain<Symbol>)result.getTupleDomain());
        Assertions.assertThat((Object)expression).isEqualTo((Object)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_VARBINARY.toSymbolReference(), this.varbinaryLiteral(value)));
    }

    @Test
    public void testConjunctExpression() {
        Expression expression = IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0)), TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L))});
        this.assertPredicateTranslates(expression, TestDomainTranslator.tupleDomain(C_DOUBLE, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)false), C_BIGINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false)));
        Assertions.assertThat((Object)this.toPredicate((TupleDomain<Symbol>)this.fromPredicate(expression).getTupleDomain())).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0)), TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L))}));
    }

    @Test
    public void testMultipleCoercionsOnSymbolSide() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.cast(TestDomainTranslator.cast(C_SMALLINT, (Type)RealType.REAL), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(3.7)), TestDomainTranslator.tupleDomain(C_SMALLINT, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)SmallintType.SMALLINT, (Object)3L), (Range[])new Range[0]), (boolean)false)));
    }

    @Test
    public void testNumericTypeTranslation() {
        this.testNumericTypeTranslationChain(new NumericValues<Int128>(C_DECIMAL_26_5, TestDomainTranslator.longDecimal("-999999999999999999999.99999"), TestDomainTranslator.longDecimal("-22.00000"), TestDomainTranslator.longDecimal("-44.55569"), TestDomainTranslator.longDecimal("23.00000"), TestDomainTranslator.longDecimal("44.55567"), TestDomainTranslator.longDecimal("999999999999999999999.99999")), new NumericValues<Int128>(C_DECIMAL_23_4, TestDomainTranslator.longDecimal("-9999999999999999999.9999"), TestDomainTranslator.longDecimal("-22.0000"), TestDomainTranslator.longDecimal("-44.5557"), TestDomainTranslator.longDecimal("23.0000"), TestDomainTranslator.longDecimal("44.5556"), TestDomainTranslator.longDecimal("9999999999999999999.9999")), new NumericValues<Long>(C_BIGINT, Long.MIN_VALUE, -22L, -45L, 23L, 44L, Long.MAX_VALUE), new NumericValues<Int128>(C_DECIMAL_21_3, TestDomainTranslator.longDecimal("-999999999999999999.999"), TestDomainTranslator.longDecimal("-22.000"), TestDomainTranslator.longDecimal("-44.556"), TestDomainTranslator.longDecimal("23.000"), TestDomainTranslator.longDecimal("44.555"), TestDomainTranslator.longDecimal("999999999999999999.999")), new NumericValues<Long>(C_DECIMAL_12_2, TestDomainTranslator.shortDecimal("-9999999999.99"), TestDomainTranslator.shortDecimal("-22.00"), TestDomainTranslator.shortDecimal("-44.56"), TestDomainTranslator.shortDecimal("23.00"), TestDomainTranslator.shortDecimal("44.55"), TestDomainTranslator.shortDecimal("9999999999.99")), new NumericValues<Long>(C_INTEGER, (Long)Integer.MIN_VALUE, -22L, -45L, 23L, 44L, (Long)Integer.MAX_VALUE), new NumericValues<Long>(C_DECIMAL_6_1, TestDomainTranslator.shortDecimal("-99999.9"), TestDomainTranslator.shortDecimal("-22.0"), TestDomainTranslator.shortDecimal("-44.6"), TestDomainTranslator.shortDecimal("23.0"), TestDomainTranslator.shortDecimal("44.5"), TestDomainTranslator.shortDecimal("99999.9")), new NumericValues<Long>(C_SMALLINT, -32768L, -22L, -45L, 23L, 44L, 32767L), new NumericValues<Long>(C_DECIMAL_3_0, TestDomainTranslator.shortDecimal("-999"), TestDomainTranslator.shortDecimal("-22"), TestDomainTranslator.shortDecimal("-45"), TestDomainTranslator.shortDecimal("23"), TestDomainTranslator.shortDecimal("44"), TestDomainTranslator.shortDecimal("999")), new NumericValues<Long>(C_TINYINT, -128L, -22L, -45L, 23L, 44L, 127L), new NumericValues<Long>(C_DECIMAL_2_0, TestDomainTranslator.shortDecimal("-99"), TestDomainTranslator.shortDecimal("-22"), TestDomainTranslator.shortDecimal("-45"), TestDomainTranslator.shortDecimal("23"), TestDomainTranslator.shortDecimal("44"), TestDomainTranslator.shortDecimal("99")));
        this.testNumericTypeTranslationChain(new NumericValues<Double>(C_DOUBLE, -1.7976931348623157E308, -22.0, -44.5556836, 23.0, 44.5556789, (Double)Double.MAX_VALUE), new NumericValues<Long>(C_REAL, TestDomainTranslator.realValue(-3.4028235E38f), TestDomainTranslator.realValue(-22.0f), TestDomainTranslator.realValue(-44.555687f), TestDomainTranslator.realValue(23.0f), TestDomainTranslator.realValue(44.555676f), TestDomainTranslator.realValue(Float.MAX_VALUE)));
    }

    private void testNumericTypeTranslationChain(NumericValues<?> ... translationChain) {
        for (int literalIndex = 0; literalIndex < translationChain.length; ++literalIndex) {
            for (int columnIndex = literalIndex + 1; columnIndex < translationChain.length; ++columnIndex) {
                NumericValues<?> literal = translationChain[literalIndex];
                NumericValues<?> column = translationChain[columnIndex];
                this.testNumericTypeTranslation(column, literal);
            }
        }
    }

    private void testNumericTypeTranslation(NumericValues<?> columnValues, NumericValues<?> literalValues) {
        Type columnType = columnValues.getType();
        Type literalType = literalValues.getType();
        Type superType = (Type)new TypeCoercion(arg_0 -> ((TypeManager)this.functionResolution.getPlannerContext().getTypeManager()).getType(arg_0)).getCommonSuperType(columnType, literalType).orElseThrow(() -> new IllegalArgumentException("incompatible types in test (" + String.valueOf(columnType) + ", " + String.valueOf(literalType) + ")"));
        Expression max = this.toExpression(literalValues.getMax(), literalType);
        Expression min = this.toExpression(literalValues.getMin(), literalType);
        Expression integerPositive = this.toExpression(literalValues.getIntegerPositive(), literalType);
        Expression integerNegative = this.toExpression(literalValues.getIntegerNegative(), literalType);
        Expression fractionalPositive = this.toExpression(literalValues.getFractionalPositive(), literalType);
        Expression fractionalNegative = this.toExpression(literalValues.getFractionalNegative(), literalType);
        if (!literalType.equals((Object)superType)) {
            max = TestDomainTranslator.cast(max, superType);
            min = TestDomainTranslator.cast(min, superType);
            integerPositive = TestDomainTranslator.cast(integerPositive, superType);
            integerNegative = TestDomainTranslator.cast(integerNegative, superType);
            fractionalPositive = TestDomainTranslator.cast(fractionalPositive, superType);
            fractionalNegative = TestDomainTranslator.cast(fractionalNegative, superType);
        }
        Symbol columnSymbol = columnValues.getColumn();
        SymbolReference columnExpression = columnSymbol.toSymbolReference();
        if (!columnType.equals((Object)superType)) {
            columnExpression = TestDomainTranslator.cast((Expression)columnExpression, superType);
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerPositive), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerNegative), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerNegative)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerPositive)), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerNegative)), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerNegative()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, max)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, min)), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalPositive)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalNegative)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
            }
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerNegative)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerPositive)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerNegative)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, max)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, min)), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalPositive)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalNegative)), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
            }
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerNegative)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerPositive)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerNegative)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerNegative()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, max)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, min)), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalPositive)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalNegative)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
            }
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerPositive), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerNegative), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerNegative)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerPositive)), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerNegative)), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, max)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, min)), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalPositive)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalNegative)), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
            }
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerPositive), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerNegative), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, max), columnSymbol, Domain.none((Type)columnType));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, min), columnSymbol, Domain.none((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.none((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.none((Type)columnType));
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerNegative)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerPositive)), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)false));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerNegative)), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)false));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, max)), columnSymbol, Domain.notNull((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, min)), columnSymbol, Domain.notNull((Type)columnType));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalPositive)), columnSymbol, Domain.notNull((Type)columnType));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalNegative)), columnSymbol, Domain.notNull((Type)columnType));
            }
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerPositive));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, max));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, min));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)false));
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)false));
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, max), columnSymbol, Domain.notNull((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, min), columnSymbol, Domain.notNull((Type)columnType));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.notNull((Type)columnType));
                this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.notNull((Type)columnType));
            }
        }
        if (literalValues.isTypeWithNaN()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerPositive)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, max)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, min)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive)));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalNegative)));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerPositive)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, max)), columnSymbol, Domain.none((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, min)), columnSymbol, Domain.none((Type)columnType));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive)), columnSymbol, Domain.none((Type)columnType));
                this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalNegative)), columnSymbol, Domain.none((Type)columnType));
            }
        }
        if (literalValues.isTypeWithNaN()) {
            this.assertNoFullPushdown((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerPositive));
            this.assertNoFullPushdown((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerNegative));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, max), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, min), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.all((Type)columnType));
        } else {
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)true));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)true));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, max), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, min), columnSymbol, Domain.all((Type)columnType));
            if (literalValues.isFractional()) {
                this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.all((Type)columnType));
                this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.all((Type)columnType));
            }
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerPositive)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerNegative)), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, max)), columnSymbol, Domain.none((Type)columnType));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, min)), columnSymbol, Domain.none((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalPositive)), columnSymbol, Domain.none((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalNegative)), columnSymbol, Domain.none((Type)columnType));
        }
    }

    @Test
    public void testLikePredicate() {
        VarcharType varcharType = VarcharType.createUnboundedVarcharType();
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc"), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc"))));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, "_def"));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, "%def"));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc_def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc_def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\_def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\\"), (boolean)true, (Object)Slices.utf8Slice((String)"abc]"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def", Character.valueOf('\\')), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc_def"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\_def_", Character.valueOf('\\')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\_def_", Character.valueOf('\\')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc_deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc^_def_", Character.valueOf('^')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc^_def_", Character.valueOf('^')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc_deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc%"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc%"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc%def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc%def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\%def"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\\"), (boolean)true, (Object)Slices.utf8Slice((String)"abc]"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def", Character.valueOf('\\')), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc%def"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\\%def_", Character.valueOf('\\')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\\%def_", Character.valueOf('\\')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc%def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc%deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc^%def_", Character.valueOf('^')), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc^%def_", Character.valueOf('^')), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc%def"), (boolean)true, (Object)Slices.utf8Slice((String)"abc%deg"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\u007f\u0123\udbfe"), C_VARCHAR, Domain.multipleValues((Type)varcharType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"abc\u007f\u0123\udbfe"))));
        this.testSimpleComparison((Expression)this.like(C_VARCHAR, "abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0%"), C_VARCHAR, (Expression)this.like(C_VARCHAR, "abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0%"), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0"), (boolean)true, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def\u007f"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.assertUnsupportedPredicate((Expression)this.like(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\\_def"), (Expression)C_VARCHAR_1.toSymbolReference()));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abcdef")), C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abcdef")), (Range[])new Range[]{Range.greaterThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abcdef"))}), (boolean)false));
        this.testSimpleComparison((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abc\\_def", Character.valueOf('\\'))), C_VARCHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def")), (Range[])new Range[]{Range.greaterThan((Type)varcharType, (Object)Slices.utf8Slice((String)"abc_def"))}), (boolean)false));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)this.like(C_VARCHAR, "abc\\_def")));
    }

    @Test
    public void testStartsWithFunction() {
        VarcharType varcharType = VarcharType.createUnboundedVarcharType();
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc"), (boolean)true, (Object)Slices.utf8Slice((String)"abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("_abc")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("_abc")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"_abc"), (boolean)true, (Object)Slices.utf8Slice((String)"_abd"), (boolean)false), (Range[])new Range[0]), (boolean)false));
        this.assertUnsupportedPredicate((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("")));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc"))));
        this.testSimpleComparison((Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0")), C_VARCHAR, (Expression)this.startsWith(C_VARCHAR, (Expression)TestDomainTranslator.stringLiteral("abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0")), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)varcharType, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def~\u007f\u00ff\u0123\uccf0"), (boolean)true, (Object)Slices.utf8Slice((String)"abc\u0123\ud83d\ude80def\u007f"), (boolean)false), (Range[])new Range[0]), (boolean)false));
    }

    @Test
    public void testUnsupportedFunctions() {
        this.assertUnsupportedPredicate((Expression)new FunctionCall(this.functionResolution.resolveFunction("length", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)C_VARCHAR.toSymbolReference())));
        this.assertUnsupportedPredicate((Expression)new FunctionCall(this.functionResolution.resolveFunction("replace", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)C_VARCHAR.toSymbolReference(), (Object)TestDomainTranslator.stringLiteral("abc"))));
    }

    @Test
    public void testCharComparedToVarcharExpression() {
        CharType charType = CharType.createCharType((int)10);
        this.testSimpleComparison((Expression)TestDomainTranslator.equal(C_CHAR, TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral("abc"), (Type)charType)), C_CHAR, Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"abc")));
        charType = CharType.createCharType((int)11);
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_CHAR, (Type)charType), TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral("abc12345678"), (Type)charType)));
    }

    private void assertPredicateIsAlwaysTrue(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.all(), (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private void assertPredicateIsAlwaysFalse(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private void assertUnsupportedPredicate(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.all(), expression);
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<Symbol> tupleDomain) {
        this.assertPredicateTranslates(expression, tupleDomain, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private void assertPredicateDerives(Expression expression, TupleDomain<Symbol> tupleDomain) {
        this.assertPredicateTranslates(expression, tupleDomain, expression);
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getTupleDomain()).isEqualTo(tupleDomain);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)remainingExpression);
    }

    private void assertNoFullPushdown(Expression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getRemainingExpression()).isNotEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
    }

    private DomainTranslator.ExtractionResult fromPredicate(Expression originalPredicate) {
        return DomainTranslator.getExtractionResult((PlannerContext)this.functionResolution.getPlannerContext(), (Session)SessionTestUtils.TEST_SESSION, (Expression)originalPredicate, (TypeProvider)TYPES);
    }

    private Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        return this.domainTranslator.toPredicate(tupleDomain);
    }

    private static Expression unprocessableExpression1(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private static Expression unprocessableExpression2(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private Expression randPredicate(Symbol symbol, Type type) {
        FunctionCall rand = this.functionResolution.functionCallBuilder("rand").build();
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), TestDomainTranslator.cast((Expression)rand, type));
    }

    private static ComparisonExpression equal(Symbol symbol, Expression expression) {
        return TestDomainTranslator.equal((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression notEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.notEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression greaterThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression greaterThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression lessThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression lessThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression isDistinctFrom(Symbol symbol, Expression expression) {
        return TestDomainTranslator.isDistinctFrom((Expression)symbol.toSymbolReference(), expression);
    }

    private FunctionCall like(Symbol symbol, String pattern) {
        return new FunctionCall(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})).toQualifiedName(), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)this.literalEncoder.toExpression((Object)LikePattern.compile((String)pattern, Optional.empty()), (Type)LikePatternType.LIKE_PATTERN)));
    }

    private FunctionCall like(Symbol symbol, Expression pattern, Expression escape) {
        FunctionCall likePattern = new FunctionCall(this.functionResolution.resolveFunction("$like_pattern", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)pattern, (Object)escape));
        return new FunctionCall(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})).toQualifiedName(), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)pattern, (Object)likePattern));
    }

    private FunctionCall like(Symbol symbol, String pattern, Character escape) {
        return new FunctionCall(this.functionResolution.resolveFunction("$like", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, LikePatternType.LIKE_PATTERN})).toQualifiedName(), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)this.literalEncoder.toExpression((Object)LikePattern.compile((String)pattern, Optional.of(escape)), (Type)LikePatternType.LIKE_PATTERN)));
    }

    private FunctionCall startsWith(Symbol symbol, Expression expression) {
        return new FunctionCall(this.functionResolution.resolveFunction("starts_with", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)symbol.toSymbolReference(), (Object)expression));
    }

    private static Expression isNotNull(Symbol symbol) {
        return TestDomainTranslator.isNotNull((Expression)symbol.toSymbolReference());
    }

    private static IsNullPredicate isNull(Symbol symbol) {
        return new IsNullPredicate((Expression)symbol.toSymbolReference());
    }

    private InPredicate in(Symbol symbol, List<?> values) {
        return this.in((Expression)symbol.toSymbolReference(), TYPES.get(symbol), values);
    }

    private static BetweenPredicate between(Symbol symbol, Expression min, Expression max) {
        return new BetweenPredicate((Expression)symbol.toSymbolReference(), min, max);
    }

    private static Expression isNotNull(Expression expression) {
        return new NotExpression((Expression)new IsNullPredicate(expression));
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private InPredicate in(Expression expression, Type expressisonType, List<?> values) {
        List<Type> types = Collections.nCopies(values.size(), expressisonType);
        List expressions = this.literalEncoder.toExpressions(values, types);
        return new InPredicate(expression, expressions);
    }

    private static BetweenPredicate between(Expression expression, Expression min, Expression max) {
        return new BetweenPredicate(expression, min, max);
    }

    private static ComparisonExpression equal(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, left, right);
    }

    private static ComparisonExpression notEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, left, right);
    }

    private static ComparisonExpression greaterThan(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, left, right);
    }

    private static ComparisonExpression greaterThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression lessThan(Expression left, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, left, expression);
    }

    private static ComparisonExpression lessThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression isDistinctFrom(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, left, right);
    }

    private static NotExpression not(Expression expression) {
        return new NotExpression(expression);
    }

    private static ComparisonExpression comparison(ComparisonExpression.Operator operator, Expression expression1, Expression expression2) {
        return new ComparisonExpression(operator, expression1, expression2);
    }

    private static Literal bigintLiteral(long value) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new GenericLiteral((Type)BigintType.BIGINT, Long.toString(value));
        }
        return new LongLiteral(value);
    }

    private static DoubleLiteral doubleLiteral(double value) {
        return new DoubleLiteral(value);
    }

    private static Expression realLiteral(String value) {
        return new GenericLiteral((Type)RealType.REAL, value);
    }

    private static StringLiteral stringLiteral(String value) {
        return new StringLiteral(value);
    }

    private static Expression stringLiteral(String value, Type type) {
        return TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral(value), type);
    }

    private static NullLiteral nullLiteral() {
        return new NullLiteral();
    }

    private static Expression nullLiteral(Type type) {
        return TestDomainTranslator.cast((Expression)new NullLiteral(), type);
    }

    private static Expression cast(Symbol symbol, Type type) {
        return TestDomainTranslator.cast((Expression)symbol.toSymbolReference(), type);
    }

    private static Expression cast(Expression expression, Type type) {
        return new Cast(expression, type);
    }

    private Expression colorLiteral(long value) {
        return this.literalEncoder.toExpression((Object)value, (Type)ColorType.COLOR);
    }

    private Expression varbinaryLiteral(Slice value) {
        return this.toExpression(value, (Type)VarbinaryType.VARBINARY);
    }

    private static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    private static Int128 longDecimal(String value) {
        return Decimals.valueOf((BigDecimal)new BigDecimal(value));
    }

    private static Long realValue(float value) {
        return Float.floatToIntBits(value);
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Range expectedDomainRange) {
        this.testSimpleComparison(expression, symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)expectedDomainRange, (Range[])new Range[0]), (boolean)false));
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Domain expectedDomain) {
        this.testSimpleComparison(expression, symbol, (Expression)BooleanLiteral.TRUE_LITERAL, expectedDomain);
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Expression expectedRemainingExpression, Domain expectedDomain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assertions.assertThat((Object)result.getRemainingExpression()).isEqualTo((Object)expectedRemainingExpression);
        TupleDomain actual = result.getTupleDomain();
        TupleDomain<Symbol> expected = TestDomainTranslator.tupleDomain(symbol, expectedDomain);
        if (!actual.equals(expected)) {
            Fail.fail((String)String.format("for comparison [%s] expected [%s] but found [%s]", expression.toString(), expected.toString(TestingConnectorSession.SESSION), actual.toString(TestingConnectorSession.SESSION)));
        }
    }

    private Expression toExpression(Object object, Type type) {
        return this.literalEncoder.toExpression(object, type);
    }

    private static <T> TupleDomain<T> tupleDomain(T key, Domain domain) {
        return TestDomainTranslator.tupleDomain(Map.of(key, domain));
    }

    private static <T> TupleDomain<T> tupleDomain(T key1, Domain domain1, T key2, Domain domain2) {
        return TestDomainTranslator.tupleDomain(Map.of(key1, domain1, key2, domain2));
    }

    private static <T> TupleDomain<T> tupleDomain(Map<T, Domain> domains) {
        return TupleDomain.withColumnDomains(domains);
    }

    private static class NumericValues<T> {
        private final Symbol column;
        private final Type type;
        private final T min;
        private final T integerNegative;
        private final T fractionalNegative;
        private final T integerPositive;
        private final T fractionalPositive;
        private final T max;

        private NumericValues(Symbol column, T min, T integerNegative, T fractionalNegative, T integerPositive, T fractionalPositive, T max) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.type = Objects.requireNonNull(TYPES.get(column), "type for column not found: " + String.valueOf(column));
            this.min = Objects.requireNonNull(min, "min is null");
            this.integerNegative = Objects.requireNonNull(integerNegative, "integerNegative is null");
            this.fractionalNegative = Objects.requireNonNull(fractionalNegative, "fractionalNegative is null");
            this.integerPositive = Objects.requireNonNull(integerPositive, "integerPositive is null");
            this.fractionalPositive = Objects.requireNonNull(fractionalPositive, "fractionalPositive is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public Symbol getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public T getMin() {
            return this.min;
        }

        public T getIntegerNegative() {
            return this.integerNegative;
        }

        public T getFractionalNegative() {
            return this.fractionalNegative;
        }

        public T getIntegerPositive() {
            return this.integerPositive;
        }

        public T getFractionalPositive() {
            return this.fractionalPositive;
        }

        public T getMax() {
            return this.max;
        }

        public boolean isFractional() {
            return this.type == DoubleType.DOUBLE || this.type == RealType.REAL || this.type instanceof DecimalType && ((DecimalType)this.type).getScale() > 0;
        }

        public boolean isTypeWithNaN() {
            return this.type instanceof DoubleType || this.type instanceof RealType;
        }
    }
}

