/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.type.FunctionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEqualityInference {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final Metadata metadata = this.functionResolution.getMetadata();

    @Test
    public void testDoesNotInferRedundantStraddlingPredicates() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals(TestEqualityInference.add((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.number(1L)), (Expression)TestEqualityInference.number(0L)), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a2"), TestEqualityInference.add((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.number(2L))), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("a3", "b3")), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("b2"), TestEqualityInference.add("a4", "b4"))});
        EqualityInference.EqualityPartition partition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "a3", "a4"));
        Assertions.assertThat((List)partition.getScopeEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.number(0L), TestEqualityInference.add((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.number(1L))), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a2"), TestEqualityInference.add((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.number(2L)))});
        Assertions.assertThat((List)partition.getScopeComplementEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.number(0L), TestEqualityInference.add((Expression)TestEqualityInference.nameReference("b1"), (Expression)TestEqualityInference.number(1L)))});
        Assertions.assertThat((List)partition.getScopeStraddlingEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("a3", "b3")), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("b2"), TestEqualityInference.add("a4", "b4"))});
    }

    @Test
    public void testTransitivity() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals("d1", "c1"), TestEqualityInference.equals("a2", "b2"), TestEqualityInference.equals("b2", "a2"), TestEqualityInference.equals("b2", "c2"), TestEqualityInference.equals("d2", "b2"), TestEqualityInference.equals("c2", "d2")});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("d1", "d2"))).isEqualTo((Object)TestEqualityInference.someExpression("d1", "d2"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "c1"), TestEqualityInference.symbols("b1"))).isEqualTo((Object)TestEqualityInference.someExpression("b1", "b1"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("b1", "d2", "c3"))).isEqualTo((Object)TestEqualityInference.someExpression("b1", "d2"));
        Assertions.assertThat((Object)inference.getScopedCanonical((Expression)TestEqualityInference.nameReference("a2"), TestEqualityInference.matchesSymbols("c2", "d2"))).isEqualTo((Object)inference.getScopedCanonical((Expression)TestEqualityInference.nameReference("b2"), TestEqualityInference.matchesSymbols("c2", "d2")));
        Expression canonical = inference.getScopedCanonical((Expression)TestEqualityInference.nameReference("a2"), TestEqualityInference.matchesSymbols("c2", "d2"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a2", "b2"), TestEqualityInference.symbols("c2", "d2"))).isEqualTo((Object)TestEqualityInference.someExpression(canonical, canonical));
    }

    @Test
    public void testTriviallyRewritable() {
        Expression expression = new EqualityInference(this.metadata, new Expression[0]).rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("a1", "a2"));
        Assertions.assertThat((Object)expression).isEqualTo((Object)TestEqualityInference.someExpression("a1", "a2"));
    }

    @Test
    public void testUnrewritable() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("a2", "b2")});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("b1", "c1"))).isNull();
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("c1", "c2"), TestEqualityInference.symbols("a1", "a2"))).isNull();
    }

    @Test
    public void testParseEqualityExpression() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("a1", "c1"), TestEqualityInference.equals("c1", "a1")});
        Expression expression = inference.rewrite(TestEqualityInference.someExpression("a1", "b1"), TestEqualityInference.symbols("c1"));
        Assertions.assertThat((Object)expression).isEqualTo((Object)TestEqualityInference.someExpression("c1", "c1"));
    }

    @Test
    public void testExtractInferrableEqualities() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{IrUtils.and((Expression[])new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.someExpression("c1", "d1")})});
        Assertions.assertThat((Object)TestEqualityInference.nameReference("c1")).isEqualTo((Object)inference.rewrite((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.symbols("c1")));
        Assertions.assertThat((Object)inference.rewrite((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.symbols("d1"))).isNull();
    }

    @Test
    public void testEqualityPartitionGeneration() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.nameReference("b1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "a1"), TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("a1"), (Expression)TestEqualityInference.number(2L))), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("b1"), (Expression)TestEqualityInference.nameReference("c1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "a1"), (Expression)TestEqualityInference.nameReference("c1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "b1"), (Expression)TestEqualityInference.nameReference("c1"))});
        EqualityInference.EqualityPartition emptyScopePartition = inference.generateEqualitiesPartitionedBy((Set)ImmutableSet.of());
        Assertions.assertThat((boolean)emptyScopePartition.getScopeEqualities().isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyScopePartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)emptyScopePartition.getScopeStraddlingEqualities().isEmpty()).isTrue();
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("c1"));
        Assertions.assertThat((boolean)equalityPartition.getScopeEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesSymbolScope(TestEqualityInference.matchesSymbols("c1")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesSymbolScope((Predicate<Symbol>)Predicates.not(TestEqualityInference.matchesSymbols("c1"))))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.matchesSymbols("c1")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        EqualityInference newInference = new EqualityInference(this.metadata, (Collection)ImmutableList.builder().addAll((Iterable)equalityPartition.getScopeEqualities()).addAll((Iterable)equalityPartition.getScopeComplementEqualities()).addAll((Iterable)equalityPartition.getScopeStraddlingEqualities()).build());
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("c1"));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testMultipleEqualitySetsPredicateGeneration() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals("c1", "d1"), TestEqualityInference.equals("a2", "b2"), TestEqualityInference.equals("b2", "c2"), TestEqualityInference.equals("c2", "d2")});
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "b1", "b2"));
        Assertions.assertThat((boolean)equalityPartition.getScopeEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesSymbolScope(TestEqualityInference.symbolBeginsWith("a", "b")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesSymbolScope((Predicate<Symbol>)Predicates.not(TestEqualityInference.symbolBeginsWith("a", "b"))))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.symbolBeginsWith("a", "b")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), expression -> EqualityInference.isInferenceCandidate((Metadata)this.metadata, (Expression)expression))).isTrue();
        EqualityInference newInference = new EqualityInference(this.metadata, (Collection)ImmutableList.builder().addAll((Iterable)equalityPartition.getScopeEqualities()).addAll((Iterable)equalityPartition.getScopeComplementEqualities()).addAll((Iterable)equalityPartition.getScopeStraddlingEqualities()).build());
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "b1", "b2"));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testSubExpressionRewrites() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a2"), TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("b"), TestEqualityInference.add("b", "c"))), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a3"), TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("b", "c")))});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.add("b", "c"), TestEqualityInference.symbols("a1", "a2"))).isEqualTo((Object)TestEqualityInference.nameReference("a1"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("ax"), TestEqualityInference.add("b", "c")), TestEqualityInference.symbols("ax", "a1", "a2", "a3"))).isEqualTo((Object)TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("ax"), (Expression)TestEqualityInference.nameReference("a1")));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.symbols("a1", "a2", "a3"))).isEqualTo((Object)TestEqualityInference.nameReference("a3"));
    }

    @Test
    public void testConstantEqualities() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("c1"), (Expression)TestEqualityInference.number(1L))});
        Assertions.assertThat((Object)inference.rewrite((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.symbols("a1", "b1"))).isEqualTo((Object)TestEqualityInference.number(1L));
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "b1"));
        Assertions.assertThat(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.set(TestEqualityInference.set(TestEqualityInference.nameReference("a1"), TestEqualityInference.number(1L)), TestEqualityInference.set(TestEqualityInference.nameReference("b1"), TestEqualityInference.number(1L))));
        Assertions.assertThat(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.set(TestEqualityInference.set(TestEqualityInference.nameReference("c1"), TestEqualityInference.number(1L))));
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isTrue();
    }

    @Test
    public void testEqualityGeneration() {
        EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("e1"), TestEqualityInference.add("b", "d")), TestEqualityInference.equals("c", "d")});
        Expression scopedCanonical = inference.getScopedCanonical((Expression)TestEqualityInference.nameReference("e1"), TestEqualityInference.symbolBeginsWith("a"));
        Assertions.assertThat((Object)scopedCanonical).isEqualTo((Object)TestEqualityInference.nameReference("a1"));
    }

    @Test
    public void testExpressionsThatMayReturnNullOnNonNullInput() {
        ImmutableList candidates = ImmutableList.of((Object)new Cast((Expression)TestEqualityInference.nameReference("b"), (Type)BigintType.BIGINT, true), (Object)this.functionResolution.functionCallBuilder("$internal$try").addArgument((Type)new FunctionType((List)ImmutableList.of(), (Type)VarcharType.VARCHAR), (Expression)new LambdaExpression((List)ImmutableList.of(), (Expression)TestEqualityInference.nameReference("b"))).build(), (Object)new NullIfExpression((Expression)TestEqualityInference.nameReference("b"), (Expression)TestEqualityInference.number(1L)), (Object)new IfExpression((Expression)TestEqualityInference.nameReference("b"), (Expression)TestEqualityInference.number(1L), (Expression)new NullLiteral()), (Object)new InPredicate((Expression)TestEqualityInference.nameReference("b"), (List)ImmutableList.of((Object)new NullLiteral())), (Object)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new IsNotNullPredicate((Expression)TestEqualityInference.nameReference("b")), (Expression)new NullLiteral())), Optional.empty()), (Object)new SimpleCaseExpression((Expression)TestEqualityInference.nameReference("b"), (List)ImmutableList.of((Object)new WhenClause((Expression)TestEqualityInference.number(1L), (Expression)new NullLiteral())), Optional.empty()), (Object)new SubscriptExpression((Expression)new Array((List)ImmutableList.of((Object)new NullLiteral())), (Expression)TestEqualityInference.nameReference("b")));
        for (Expression candidate : candidates) {
            EqualityInference inference = new EqualityInference(this.metadata, new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("b"), (Expression)TestEqualityInference.nameReference("x")), TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("a"), candidate)});
            List equalities = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("b")).getScopeStraddlingEqualities();
            Assertions.assertThat((int)equalities.size()).isEqualTo(1);
            Assertions.assertThat((((Expression)equalities.get(0)).equals(TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("x"), (Expression)TestEqualityInference.nameReference("b"))) || ((Expression)equalities.get(0)).equals(TestEqualityInference.equals((Expression)TestEqualityInference.nameReference("b"), (Expression)TestEqualityInference.nameReference("x"))) ? 1 : 0) != 0).isTrue();
        }
    }

    private static Predicate<Expression> matchesSymbolScope(Predicate<Symbol> symbolScope) {
        return expression -> Iterables.all((Iterable)SymbolsExtractor.extractUnique((Expression)expression), (Predicate)symbolScope);
    }

    private static Predicate<Expression> matchesStraddlingScope(Predicate<Symbol> symbolScope) {
        return expression -> {
            Set symbols = SymbolsExtractor.extractUnique((Expression)expression);
            return Iterables.any((Iterable)symbols, (Predicate)symbolScope) && Iterables.any((Iterable)symbols, (Predicate)Predicates.not((Predicate)symbolScope));
        };
    }

    private static Expression someExpression(String symbol1, String symbol2) {
        return TestEqualityInference.someExpression((Expression)TestEqualityInference.nameReference(symbol1), (Expression)TestEqualityInference.nameReference(symbol2));
    }

    private static Expression someExpression(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, expression1, expression2);
    }

    private static Expression add(String symbol1, String symbol2) {
        return TestEqualityInference.add((Expression)TestEqualityInference.nameReference(symbol1), (Expression)TestEqualityInference.nameReference(symbol2));
    }

    private static Expression add(Expression expression1, Expression expression2) {
        return new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, expression1, expression2);
    }

    private static Expression multiply(String symbol1, String symbol2) {
        return TestEqualityInference.multiply((Expression)TestEqualityInference.nameReference(symbol1), (Expression)TestEqualityInference.nameReference(symbol2));
    }

    private static Expression multiply(Expression expression1, Expression expression2) {
        return new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, expression1, expression2);
    }

    private static Expression equals(String symbol1, String symbol2) {
        return TestEqualityInference.equals((Expression)TestEqualityInference.nameReference(symbol1), (Expression)TestEqualityInference.nameReference(symbol2));
    }

    private static Expression equals(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, expression1, expression2);
    }

    private static SymbolReference nameReference(String symbol) {
        return new SymbolReference(symbol);
    }

    private static LongLiteral number(long number) {
        return new LongLiteral(number);
    }

    private static Set<Symbol> symbols(String ... symbols) {
        return (Set)Arrays.stream(symbols).map(Symbol::new).collect(ImmutableSet.toImmutableSet());
    }

    private static Predicate<Symbol> matchesSymbols(String ... symbols) {
        return TestEqualityInference.matchesSymbols(Arrays.asList(symbols));
    }

    private static Predicate<Symbol> matchesSymbols(Collection<String> symbols) {
        Set symbolSet = (Set)symbols.stream().map(Symbol::new).collect(ImmutableSet.toImmutableSet());
        return Predicates.in((Collection)symbolSet);
    }

    private static Predicate<Symbol> symbolBeginsWith(String ... prefixes) {
        return TestEqualityInference.symbolBeginsWith(Arrays.asList(prefixes));
    }

    private static Predicate<Symbol> symbolBeginsWith(Iterable<String> prefixes) {
        return symbol -> {
            for (String prefix : prefixes) {
                if (!symbol.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private static Set<Set<Expression>> equalitiesAsSets(Iterable<Expression> expressions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Expression expression : expressions) {
            builder.add(TestEqualityInference.equalityAsSet(expression));
        }
        return builder.build();
    }

    private static Set<Expression> equalityAsSet(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof ComparisonExpression));
        ComparisonExpression comparisonExpression = (ComparisonExpression)expression;
        Preconditions.checkArgument((comparisonExpression.getOperator() == ComparisonExpression.Operator.EQUAL ? 1 : 0) != 0);
        return ImmutableSet.of((Object)comparisonExpression.getLeft(), (Object)comparisonExpression.getRight());
    }

    @SafeVarargs
    private static <E> Set<E> set(E ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    private static <E> Set<E> setCopy(Iterable<E> elements) {
        return ImmutableSet.copyOf(elements);
    }
}

