/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JsonFunctions;
import io.trino.operator.scalar.Re2JCastToRegexpFunction;
import io.trino.operator.scalar.StringFunctions;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.CodePointsType;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePatternType;
import io.trino.type.Re2JRegexp;
import io.trino.type.Re2JRegexpType;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLiteralEncoder {
    private final LiteralEncoder encoder = new LiteralEncoder(TestingPlannerContext.PLANNER_CONTEXT);
    private final ResolvedFunction literalFunction = new ResolvedFunction(new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"$literal$"), (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)VarbinaryType.VARBINARY)), GlobalSystemConnector.CATALOG_HANDLE, new LiteralFunction(TestingPlannerContext.PLANNER_CONTEXT.getBlockEncodingSerde()).getFunctionMetadata().getFunctionId(), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of((Object)false)), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());
    private final ResolvedFunction base64Function = new ResolvedFunction(new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"from_base64"), (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)VarcharType.VARCHAR)), GlobalSystemConnector.CATALOG_HANDLE, FunctionId.toFunctionId((String)"from_base64", (Signature)Signature.builder().returnType((Type)VarbinaryType.VARBINARY).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build()), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of((Object)false)), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());

    @Test
    public void testEncodeUnknown() {
        this.assertEncode(null, (Type)UnknownType.UNKNOWN);
    }

    @Test
    public void testEncodeBigint() {
        this.assertEncode(null, (Type)BigintType.BIGINT);
        this.assertEncode(123L, (Type)BigintType.BIGINT);
    }

    @Test
    public void testEncodeDecimal() {
        this.assertEncode(123L, (Type)DecimalType.createDecimalType((int)7, (int)1));
    }

    @Test
    public void testEncodeChar() {
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)CharType.createCharType((int)5));
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)CharType.createCharType((int)13));
    }

    @Test
    public void testEncodeVarchar() {
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.createVarcharType((int)5));
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.createVarcharType((int)13));
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.VARCHAR);
    }

    @Test
    public void testEncodeVarbinary() {
        this.assertEncodeCaseInsensitively(Slices.utf8Slice((String)"hello"), (Type)VarbinaryType.VARBINARY);
        this.assertEncodeCaseInsensitively(Slices.utf8Slice((String)"hello"), (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testEncodeTimestamp() {
        for (int precision = 0; precision <= 12; ++precision) {
            this.assertEncode(null, (Type)TimestampType.createTimestampType((int)precision));
        }
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)0));
        this.assertEncode(1603710138100000L, (Type)TimestampType.createTimestampType((int)1));
        this.assertEncode(1603710138120000L, (Type)TimestampType.createTimestampType((int)2));
        this.assertEncode(1603710138123000L, (Type)TimestampType.createTimestampType((int)3));
        this.assertEncode(1603710138123400L, (Type)TimestampType.createTimestampType((int)4));
        this.assertEncode(1603710138123450L, (Type)TimestampType.createTimestampType((int)5));
        this.assertEncode(1603710138123456L, (Type)TimestampType.createTimestampType((int)6));
        this.assertEncode(new LongTimestamp(1603710138123456L, 100000), (Type)TimestampType.createTimestampType((int)7));
        this.assertEncode(new LongTimestamp(1603710138123456L, 120000), (Type)TimestampType.createTimestampType((int)8));
        this.assertEncode(new LongTimestamp(1603710138123456L, 123000), (Type)TimestampType.createTimestampType((int)9));
        this.assertEncode(new LongTimestamp(1603710138123456L, 123400), (Type)TimestampType.createTimestampType((int)10));
        this.assertEncode(new LongTimestamp(1603710138123456L, 123450), (Type)TimestampType.createTimestampType((int)11));
        this.assertEncode(new LongTimestamp(1603710138123456L, 123456), (Type)TimestampType.createTimestampType((int)12));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)1));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)2));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)3));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)4));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)5));
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)6));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)7));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)8));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)9));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)10));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)11));
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)12));
    }

    @Test
    public void testEncodeTimestampWithTimeZone() {
        for (int precision = 0; precision <= 12; ++precision) {
            this.assertEncode(null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision));
        }
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138100L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138120L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138123L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)100000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)120000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123400000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123450000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456700, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456780, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456789, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1585445478000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1585445478123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
        this.assertRoundTrip(DateTimeEncoding.packDateTimeWithZone((long)1603589478000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), Long::equals);
        this.assertRoundTrip(DateTimeEncoding.packDateTimeWithZone((long)1603589478123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), Long::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), LongTimestampWithTimeZone::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), LongTimestampWithTimeZone::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), LongTimestampWithTimeZone::equals);
    }

    @Test
    public void testEncodeRegex() {
        this.assertRoundTrip(JoniRegexpCasts.castVarcharToJoniRegexp((Slice)Slices.utf8Slice((String)"[a-z]")), (Type)JoniRegexpType.JONI_REGEXP, (left, right) -> left.pattern().equals((Object)right.pattern()));
        this.assertRoundTrip(TestLiteralEncoder.castVarcharToRe2JRegexp(Slices.utf8Slice((String)"[a-z]")), TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(Re2JRegexpType.RE2J_REGEXP_SIGNATURE), (left, right) -> left.pattern().equals(right.pattern()));
    }

    @Test
    public void testEncodeLikePattern() {
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc_")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc%")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"a_b%cX%X_"), (Slice)Slices.utf8Slice((String)"/")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
    }

    @Test
    public void testEncodeJsonPath() {
        this.assertRoundTrip(JsonFunctions.castVarcharToJsonPath((Slice)Slices.utf8Slice((String)"$.foo")), (Type)JsonPathType.JSON_PATH, (left, right) -> left.pattern().equals(right.pattern()));
    }

    @Test
    public void testEncodeCodePoints() {
        this.assertRoundTrip(StringFunctions.castVarcharToCodePoints((Slice)Slices.utf8Slice((String)"hello")), (Type)CodePointsType.CODE_POINTS, Arrays::equals);
    }

    private void assertEncode(Object value, Type type) {
        Expression expression = this.encoder.toExpression(value, type);
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Assertions.assertThat((Object)this.getExpressionValue(expression)).isEqualTo(value);
    }

    @Deprecated
    private void assertEncodeCaseInsensitively(Object value, Type type) {
        Expression expression = this.encoder.toExpression(value, type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)IrUtils.isEffectivelyLiteral((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression)).describedAs("isEffectivelyLiteral returned false for: " + String.valueOf(expression), new Object[0])).isTrue();
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Assertions.assertThat((Object)this.getExpressionValue(expression)).isEqualTo(value);
    }

    private <T> void assertRoundTrip(T value, Type type, BiPredicate<T, T> predicate) {
        Expression expression = this.encoder.toExpression(value, type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)IrUtils.isEffectivelyLiteral((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression)).describedAs("isEffectivelyLiteral returned false for: " + String.valueOf(expression), new Object[0])).isTrue();
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Object decodedValue = this.getExpressionValue(expression);
        Assertions.assertThat((boolean)predicate.test(value, decodedValue)).isTrue();
    }

    private Object getExpressionValue(Expression expression) {
        return new IrExpressionInterpreter(expression, TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, this.getExpressionTypes(expression)).evaluate();
    }

    private Type getExpressionType(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression);
        Type expressionType = expressionTypes.get(NodeRef.of((Expression)expression));
        Verify.verify((expressionType != null ? 1 : 0) != 0, (String)"No type found", (Object[])new Object[0]);
        return expressionType;
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (Map)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> new IrTypeAnalyzer(TestingPlannerContext.PLANNER_CONTEXT).getTypes(transactionSession, TypeProvider.empty(), expression));
    }

    private String literalVarbinary(byte[] value) {
        return "%s(%s('%s'))".formatted(TestLiteralEncoder.serializeResolvedFunction(this.literalFunction), TestLiteralEncoder.serializeResolvedFunction(this.base64Function), Base64.getEncoder().encodeToString(value));
    }

    private static String serializeResolvedFunction(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.toCatalogSchemaFunctionName();
        return "%s.\"%s\".\"%s\"".formatted(name.getCatalogName(), name.getSchemaName(), name.getFunctionName());
    }

    private static Re2JRegexp castVarcharToRe2JRegexp(Slice value) {
        return Re2JCastToRegexpFunction.castToRegexp((int)Integer.MAX_VALUE, (int)5, (boolean)false, (long)Integer.MAX_VALUE, (Slice)value);
    }
}

