/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRecursiveCte
extends BasePlanTest {
    @Override
    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setSystemProperty("max_recursion_depth", "1");
        return PlanTester.create((Session)sessionBuilder.build());
    }

    @Test
    public void testRecursiveQuery() {
        String sql = "WITH RECURSIVE t(n) AS (                SELECT 1                UNION ALL                SELECT n + 2 FROM t WHERE n < 6                )                SELECT * from t";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L))), PlanMatchPattern.values(new String[0])))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(2L)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(6L)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L))), PlanMatchPattern.values(new String[0])))))))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("count"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, Integer.toString(StandardErrorCode.NOT_SUPPORTED.toErrorCode().getCode())), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Recursion depth limit exceeded (1). Use 'max_recursion_depth' session property to modify the limit."))), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.window(windowBuilder -> windowBuilder.addFunction("count", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(2L)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(6L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expr_0"))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(2L)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("expr"), (Expression)new LongLiteral(6L)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L))), PlanMatchPattern.values(new String[0])))))))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

