/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.SortExpressionContext;
import io.trino.sql.planner.SortExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.transaction.TestingTransactionManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSortExpressionExtractor {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final Set<Symbol> BUILD_SYMBOLS = ImmutableSet.of((Object)new Symbol("b1"), (Object)new Symbol("b2"));
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction SIN = FUNCTIONS.resolveFunction("sin", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));

    @Test
    public void testGetSortExpression() {
        this.assertGetSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1")), "b1");
        this.assertGetSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), "b2");
        this.assertGetSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), "b2");
        this.assertGetSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("p1")))), "b2");
        this.assertNoSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("p1")))));
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("p1")))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")))), "b2", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1"))});
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new FunctionCall(RANDOM.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("p1")))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")))), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1"))});
        this.assertNoSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b2"))));
        this.assertNoSortExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("b1"))), (Expression)new SymbolReference("p1")));
        this.assertNoSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")))));
        this.assertNoSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("b2"))), (Expression)new SymbolReference("p1")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new LongLiteral(10L))))))));
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(SIN.toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference("b2"))), (Expression)new SymbolReference("p1")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new LongLiteral(10L))))))), "b2", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new LongLiteral(10L)))});
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")))), "b1");
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")))), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1"))});
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new LongLiteral(10L))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p2")))), "b2", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p1")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("p1"), (Expression)new LongLiteral(10L))), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b2"), (Expression)new SymbolReference("p2"))});
        this.assertGetSortExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("b2")), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1"))});
        this.assertGetSortExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("p1"), (Expression)new SymbolReference("p2"), (Expression)new SymbolReference("b1")), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1"))});
        this.assertGetSortExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("p2")), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1"))});
        this.assertGetSortExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), (Object)new BetweenPredicate((Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("b2")))), "b1", new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b1"), (Expression)new SymbolReference("p1")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("p1"), (Expression)new SymbolReference("b1"))});
    }

    private void assertNoSortExpression(Expression expression) {
        Optional actual = SortExpressionExtractor.extractSortExpression((Metadata)PLANNER_CONTEXT.getMetadata(), BUILD_SYMBOLS, (Expression)expression);
        Assertions.assertThat((Optional)actual).isEqualTo(Optional.empty());
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol) {
        this.assertGetSortExpression(expression, expectedSymbol, IrUtils.extractConjuncts((Expression)expression));
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, Expression ... searchExpressions) {
        this.assertGetSortExpression(expression, expectedSymbol, Arrays.asList(searchExpressions));
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, List<Expression> searchExpressions) {
        Optional<SortExpressionContext> expected = Optional.of(new SortExpressionContext((Expression)new SymbolReference(expectedSymbol), searchExpressions));
        Optional actual = SortExpressionExtractor.extractSortExpression((Metadata)PLANNER_CONTEXT.getMetadata(), BUILD_SYMBOLS, (Expression)expression);
        Assertions.assertThat((Optional)actual).isEqualTo(expected);
    }
}

