/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.TestingTableFunctions;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.TableFunctionMatcher;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestTableFunctionInvocation
extends BasePlanTest {
    private static final String TESTING_CATALOG = "mock";

    @BeforeAll
    public final void setup() {
        this.getPlanTester().installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withTableFunctions((Iterable<ConnectorTableFunction>)ImmutableSet.of((Object)((Object)new TestingTableFunctions.DifferentArgumentTypesFunction()), (Object)((Object)new TestingTableFunctions.TwoScalarArgumentsFunction()), (Object)((Object)new TestingTableFunctions.DescriptorArgumentFunction()), (Object)((Object)new TestingTableFunctions.TwoTableArgumentsFunction()), (Object)((Object)new TestingTableFunctions.PassThroughFunction()))).withApplyTableFunction((session, handle) -> {
            if (handle instanceof TestingTableFunctions.TestingTableFunctionPushdownHandle) {
                TestingTableFunctions.TestingTableFunctionPushdownHandle functionHandle = (TestingTableFunctions.TestingTableFunctionPushdownHandle)handle;
                return Optional.of(new TableFunctionApplicationResult((Object)functionHandle.getTableHandle(), functionHandle.getTableHandle().getColumns().orElseThrow()));
            }
            throw new IllegalStateException("Unsupported table function handle: " + handle.getClass().getSimpleName());
        }).build()));
        this.getPlanTester().createCatalog(TESTING_CATALOG, TESTING_CATALOG, (Map)ImmutableMap.of());
    }

    @Test
    public void testTableFunctionInitialPlan() {
        this.assertPlan("SELECT * FROM TABLE(mock.system.different_arguments_function(\n   INPUT_1 => TABLE(SELECT 'a') t1(c1) PARTITION BY c1 ORDER BY c1,\n   INPUT_3 => TABLE(SELECT 'b') t3(c3) PARTITION BY c3,\n   INPUT_2 => TABLE(VALUES 1) t2(c2),\n   ID => BIGINT '2001',\n   LAYOUT => DESCRIPTOR (x boolean, y bigint)\n   COPARTITION (t1, t3))) t\n", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.tableFunction(builder -> builder.name("different_arguments_function").addTableArgument("INPUT_1", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(0).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c1"), (List<String>)ImmutableList.of((Object)"c1"), (Map<String, SortOrder>)ImmutableMap.of((Object)"c1", (Object)SortOrder.ASC_NULLS_LAST))).passThroughColumns().passThroughSymbols((Set<String>)ImmutableSet.of((Object)"c1"))).addTableArgument("INPUT_3", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(2).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c3"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).pruneWhenEmpty().passThroughSymbols((Set<String>)ImmutableSet.of((Object)"c3"))).addTableArgument("INPUT_2", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(1).rowSemantics().passThroughColumns().passThroughSymbols((Set<String>)ImmutableSet.of((Object)"c2"))).addScalarArgument("ID", 2001L).addDescriptorArgument("LAYOUT", TableFunctionMatcher.DescriptorArgumentValue.descriptorArgument(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("X", Optional.of(BooleanType.BOOLEAN)), (Object)new Descriptor.Field("Y", Optional.of(BigintType.BIGINT)))))).addCopartitioning((List<String>)ImmutableList.of((Object)"INPUT_1", (Object)"INPUT_3")).properOutputs((List<String>)ImmutableList.of((Object)"OUTPUT")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c1", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("a"))), PlanMatchPattern.values(1))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c2"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c3", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("b"))), PlanMatchPattern.values(1))))));
    }

    @Test
    public void testTableFunctionInitialPlanWithCoercionForCopartitioning() {
        this.assertPlan("SELECT * FROM TABLE(mock.system.two_table_arguments_function(\n   INPUT1 => TABLE(VALUES SMALLINT '1') t1(c1) PARTITION BY c1,\n   INPUT2 => TABLE(VALUES INTEGER '2') t2(c2) PARTITION BY c2\n   COPARTITION (t1, t2))) t\n", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.tableFunction(builder -> builder.name("two_table_arguments_function").addTableArgument("INPUT1", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(0).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c1_coerced"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).passThroughSymbols((Set<String>)ImmutableSet.of((Object)"c1"))).addTableArgument("INPUT2", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(1).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c2"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).passThroughSymbols((Set<String>)ImmutableSet.of((Object)"c2"))).addCopartitioning((List<String>)ImmutableList.of((Object)"INPUT1", (Object)"INPUT2")).properOutputs((List<String>)ImmutableList.of((Object)"COLUMN")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c1_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("c1"), (Type)IntegerType.INTEGER))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral((Type)SmallintType.SMALLINT, "1")))))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c2"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, "2"))))))));
    }

    @Test
    public void testNullScalarArgument() {
        this.assertPlan(" SELECT * FROM TABLE(mock.system.two_arguments_function(TEXT => null))", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.tableFunction(builder -> builder.name("two_arguments_function").addScalarArgument("TEXT", null).addScalarArgument("NUMBER", null).properOutputs((List<String>)ImmutableList.of((Object)"OUTPUT")), new PlanMatchPattern[0])));
    }

    @Test
    public void testNullDescriptorArgument() {
        this.assertPlan(" SELECT * FROM TABLE(mock.system.descriptor_argument_function(SCHEMA => CAST(null AS DESCRIPTOR)))", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.tableFunction(builder -> builder.name("descriptor_argument_function").addDescriptorArgument("SCHEMA", TableFunctionMatcher.DescriptorArgumentValue.nullDescriptor()).properOutputs((List<String>)ImmutableList.of((Object)"OUTPUT")), new PlanMatchPattern[0])));
        this.assertPlan(" SELECT * FROM TABLE(mock.system.descriptor_argument_function())", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.tableFunction(builder -> builder.name("descriptor_argument_function").addDescriptorArgument("SCHEMA", TableFunctionMatcher.DescriptorArgumentValue.nullDescriptor()).properOutputs((List<String>)ImmutableList.of((Object)"OUTPUT")), new PlanMatchPattern[0])));
    }

    @Test
    public void testPruneTableFunctionColumns() {
        this.assertPlan("SELECT * FROM TABLE(mock.system.pass_through_function(input => TABLE(SELECT 1, true) t(a, b)))", PlanMatchPattern.strictOutput((List<String>)ImmutableList.of((Object)"x", (Object)"a", (Object)"b"), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("pass_through_function").properOutputs((List<String>)ImmutableList.of((Object)"x")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L), (Object)BooleanLiteral.TRUE_LITERAL))))));
        this.assertPlan("SELECT 'constant' c FROM TABLE(mock.system.pass_through_function(input => TABLE(SELECT 1, true) t(a, b)))", PlanMatchPattern.strictOutput((List<String>)ImmutableList.of((Object)"c"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("constant"))), PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("pass_through_function").properOutputs((List<String>)ImmutableList.of((Object)"x")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L))))))));
    }

    @Test
    public void testRemoveRedundantTableFunction() {
        this.assertPlan("SELECT * FROM TABLE(mock.system.pass_through_function(input => TABLE(SELECT 1, true WHERE false) t(a, b) PRUNE WHEN EMPTY))", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x", (Object)"a", (Object)"b"))));
        this.assertPlan("SELECT *\nFROM TABLE(mock.system.two_table_arguments_function(\n                input1 => TABLE(SELECT 1, true WHERE false) t1(a, b) PRUNE WHEN EMPTY,\n                input2 => TABLE(SELECT 2, false) t2(c, d) KEEP WHEN EMPTY))\n", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"column"))));
        this.assertPlan("SELECT *\nFROM TABLE(mock.system.two_table_arguments_function(\n                input1 => TABLE(SELECT 1, true WHERE false) t1(a, b) PRUNE WHEN EMPTY,\n                input2 => TABLE(SELECT 2, false WHERE false) t2(c, d) PRUNE WHEN EMPTY))\n", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"column"))));
        this.assertPlan("SELECT *\nFROM TABLE(mock.system.two_table_arguments_function(\n                input1 => TABLE(SELECT 1, true WHERE false) t1(a, b) PRUNE WHEN EMPTY,\n                input2 => TABLE(SELECT 2, false WHERE false) t2(c, d) KEEP WHEN EMPTY))\n", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"column"))));
        this.assertPlan("SELECT *\nFROM TABLE(mock.system.two_table_arguments_function(\n                input1 => TABLE(SELECT 1, true WHERE false) t1(a, b) KEEP WHEN EMPTY,\n                input2 => TABLE(SELECT 2, false WHERE false) t2(c, d) KEEP WHEN EMPTY))\n", PlanMatchPattern.output(PlanMatchPattern.node(TableFunctionProcessorNode.class, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"marker_1", (Object)"c", (Object)"marker_2", (Object)"row_number")))));
        this.assertPlan("SELECT *\nFROM TABLE(mock.system.two_table_arguments_function(\n                input1 => TABLE(SELECT 1, true WHERE false) t1(a, b) KEEP WHEN EMPTY,\n                input2 => TABLE(SELECT 2, false) t2(c, d) PRUNE WHEN EMPTY))\n", PlanMatchPattern.output(PlanMatchPattern.node(TableFunctionProcessorNode.class, PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"c"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(2L))))).withAlias("input_2_row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))))));
    }
}

