/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.tree.QualifiedName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.Test;

public class TestUnwrapCastInComparison
extends BasePlanTest {
    @Test
    public void testEquals() {
        this.testUnwrap("smallint", "a = DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a = DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a = DOUBLE '1.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a = DOUBLE '1.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a = DOUBLE '1.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a = DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a = DOUBLE '32766.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a = DOUBLE '32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a = DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a = DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a = DOUBLE '-32767.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a = DOUBLE '-32768'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a = DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a = DOUBLE '-18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("varchar(3)", "a = CAST('abc' AS char(3))", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new StringLiteral("abc")));
        this.testUnwrap("varchar(10)", "a = CAST('abc' AS char(3))", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)CharType.createCharType((int)10)), (Expression)new Cast((Expression)new StringLiteral("abc"), (Type)CharType.createCharType((int)10))));
        this.testUnwrap("varchar", "a = CAST('abc' AS char(3))", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)CharType.createCharType((int)65536)), (Expression)new Cast((Expression)new StringLiteral("abc"), (Type)CharType.createCharType((int)65536))));
    }

    @Test
    public void testNotEquals() {
        this.testUnwrap("smallint", "a <> DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a <> DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a <> DOUBLE '1.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '1.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '1.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a <> DOUBLE '1.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a <> DOUBLE '32766.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a <> DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a <> DOUBLE '18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a <> DOUBLE '-32767.9'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> DOUBLE '-32768'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a <> DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testLessThan() {
        this.testUnwrap("smallint", "a < DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a < DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a < DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a < DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a < DOUBLE '1.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "2")));
        this.testUnwrap("smallint", "a < DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a < DOUBLE '32766.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a < DOUBLE '32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a < DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a < DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a < DOUBLE '-32767.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a < DOUBLE '-32768'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a < DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a < DOUBLE '-18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testLessThanOrEqual() {
        this.testUnwrap("smallint", "a <= DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a <= DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a <= DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a <= DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a <= DOUBLE '1.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "2")));
        this.testUnwrap("smallint", "a <= DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a <= DOUBLE '32766.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a <= DOUBLE '32767'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <= DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a <= DOUBLE '18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <= DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a <= DOUBLE '-32767.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a <= DOUBLE '-32768'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a <= DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testGreaterThan() {
        this.testUnwrap("smallint", "a > DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a > DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a > DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("smallint", "a > DOUBLE '1.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "2")));
        this.testUnwrap("bigint", "a > DOUBLE '1.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2")));
        this.testUnwrap("smallint", "a > DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a > DOUBLE '32766.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a > DOUBLE '32767'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a > DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a > DOUBLE '18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a > DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a > DOUBLE '-32767.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a > DOUBLE '-32768'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a > DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.testUnwrap("smallint", "a >= DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a >= DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a >= DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a >= DOUBLE '1.1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testUnwrap("smallint", "a >= DOUBLE '1.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "2")));
        this.testUnwrap("smallint", "a >= DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testUnwrap("smallint", "a >= DOUBLE '32766.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a >= DOUBLE '32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testUnwrap("smallint", "a >= DOUBLE '32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a >= DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testUnwrap("smallint", "a >= DOUBLE '-32767.9'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testUnwrap("smallint", "a >= DOUBLE '-32768'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a >= DOUBLE '-32768.1'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a >= DOUBLE '-18446744073709551616'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testDistinctFrom() {
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        this.testUnwrap("bigint", "a IS DISTINCT FROM DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '1.1'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '1.9'");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM DOUBLE '1.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '32766'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32766")));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '32766.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "32767")));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '32768.1'");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM DOUBLE '18446744073709551616'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '-32767'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32767")));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '-32767.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '-32768'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-32768")));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '-32768.1'");
    }

    @Test
    public void testNull() {
        this.testUnwrap("smallint", "a = CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("bigint", "a = CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a <> CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a > CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a < CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a >= CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a <= CAST(NULL AS DOUBLE)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("smallint", "a IS DISTINCT FROM CAST(NULL AS DOUBLE)", (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE))));
        this.testUnwrap("bigint", "a IS DISTINCT FROM CAST(NULL AS DOUBLE)", (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE))));
    }

    @Test
    public void testNaN() {
        this.testUnwrap("smallint", "a = nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("bigint", "a = nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a < nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("smallint", "a <> nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM nan()");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM nan()");
        this.testUnwrap("real", "a = nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("real", "a < nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("real", "a <> nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("real", "a IS DISTINCT FROM nan()", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of()), (Type)RealType.REAL)));
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("tinyint", String.format("a = %s '1'", type), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TinyintType.TINYINT, "1")));
        }
        for (String type : Arrays.asList("INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("smallint", String.format("a = %s '1'", type), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1")));
        }
        for (String type : Arrays.asList("BIGINT", "DOUBLE")) {
            this.testUnwrap("integer", String.format("a = %s '1'", type), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        }
        this.testUnwrap("real", "a = DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)RealType.REAL, "1.0")));
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES REAL '1') t(a) WHERE DOUBLE '1' = a", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("A"), (Expression)new GenericLiteral((Type)RealType.REAL, "1.0")), PlanMatchPattern.values("A"))));
    }

    @Test
    public void testCastDateToTimestampWithTimeZone() {
        Session session = this.getPlanTester().getDefaultSession();
        Session utcSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.UTC_KEY);
        Session warsawSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw"));
        Session losAngelesSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles"));
        this.testUnwrap(utcSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18 Europe/Warsaw'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(losAngelesSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18 America/Los_Angeles'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(losAngelesSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(losAngelesSession, "date", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-10-26")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59.999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59.13 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59.999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59.999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(warsawSession, "date", "a > TIMESTAMP '2020-03-29 00:59:59.999999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2020-03-29")));
        this.testUnwrap(utcSession, "date", "a = TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a = TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a = TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a = TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <> TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <> TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <> TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <> TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a < TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a < TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a < TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a < TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <= TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <= TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <= TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a <= TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a > TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a > TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a > TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a > TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a >= TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a >= TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a >= TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a >= TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a IS DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a IS DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a IS DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a IS DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
        this.testUnwrap(utcSession, "date", "a IS NOT DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00 UTC'", (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22"))));
        this.testUnwrap(utcSession, "date", "a IS NOT DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000 UTC'", (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22"))));
        this.testUnwrap(utcSession, "date", "a IS NOT DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000000 UTC'", (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22"))));
        this.testUnwrap(utcSession, "date", "a IS NOT DISTINCT FROM TIMESTAMP '1981-06-22 00:00:00.000000000000 UTC'", (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22"))));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) = NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) < NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) <= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) > NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) >= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("date", "CAST(a AS TIMESTAMP WITH TIME ZONE) IS DISTINCT FROM NULL", (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))));
        this.testUnwrap(utcSession, "date", "TIMESTAMP '1981-06-22 00:00:00 UTC' = a", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1981-06-22")));
    }

    @Test
    public void testCastTimestampToTimestampWithTimeZone() {
        Session session = this.getPlanTester().getDefaultSession();
        Session utcSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.UTC_KEY);
        Session warsawSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw"));
        Session losAngelesSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles"));
        this.testUnwrap(utcSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-26 11:02:18")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 Europe/Warsaw'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-26 11:02:18")));
        this.testUnwrap(losAngelesSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 America/Los_Angeles'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-26 11:02:18")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-26 12:02:18")));
        this.testUnwrap(losAngelesSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-26 04:02:18")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-26 12:02:18.120000")));
        this.testUnwrap(losAngelesSession, "timestamp(6)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-26 04:02:18.120000")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-26 12:02:18.120000000")));
        this.testUnwrap(losAngelesSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-26 04:02:18.120000000")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.123456 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-26 12:02:18.123456000")));
        this.testUnwrap(losAngelesSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.123456 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-26 04:02:18.123456000")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-26 12:02:18.123456789321")));
        this.testUnwrap(losAngelesSession, "timestamp(12)", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-26 04:02:18.123456789321")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-03-29 00:59:59 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-03-29 01:59:59")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-03-29 00:59:59.999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-03-29 01:59:59.999")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 00:59:59.13 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-03-29 01:59:59.130000")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 00:59:59.999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-03-29 01:59:59.999999")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-03-29 00:59:59.999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-03-29 01:59:59.999999999")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-03-29 00:59:59.999999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-03-29 01:59:59.999999999999")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-03-29 02:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-03-29 04:00:00")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-03-29 02:00:00.000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-03-29 04:00:00.000")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 02:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-03-29 04:00:00.000000")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-03-29 02:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-03-29 04:00:00.000000000")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-03-29 02:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-03-29 04:00:00.000000000000")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 00:59:59 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-25 02:59:59")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 00:59:59.999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-10-25 02:59:59.999")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 00:59:59.999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-25 02:59:59.999999")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 00:59:59.999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-25 02:59:59.999999999")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 00:59:59.999999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-25 02:59:59.999999999999")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 01:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-25 02:00:00")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 01:00:00.000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-10-25 02:00:00.000")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 01:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-25 02:00:00.000000")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 01:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-25 02:00:00.000000000")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 01:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-25 02:00:00.000000000000")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 01:59:59 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-25 02:59:59")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 01:59:59.999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-10-25 02:59:59.999")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 01:59:59.999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-25 02:59:59.999999")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 01:59:59.999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-25 02:59:59.999999999")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 01:59:59.999999999999 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-25 02:59:59.999999999999")));
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 02:00:00 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2020-10-25 03:00:00")));
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 02:00:00.000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2020-10-25 03:00:00.000")));
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 02:00:00.000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2020-10-25 03:00:00.000000")));
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 02:00:00.000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-10-25 03:00:00.000000000")));
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 02:00:00.000000000000 UTC'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2020-10-25 03:00:00.000000000000")));
    }

    @Test
    public void testNoEffect() {
        this.testUnwrap("bigint", "a = DOUBLE '9007199254740992'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), (Expression)new DoubleLiteral(9.007199254740992E15)));
        this.testUnwrap("bigint", "a = DOUBLE '9223372036854775807'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), (Expression)new DoubleLiteral(9.223372036854776E18)));
        this.testUnwrap("bigint", "a = DOUBLE '-9007199254740992'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), (Expression)new DoubleLiteral(-9.007199254740992E15)));
        this.testUnwrap("bigint", "a = DOUBLE '-9223372036854775807'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), (Expression)new DoubleLiteral(-9.223372036854776E18)));
        this.testUnwrap("bigint", "a = REAL '8388608'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "8388608.0")));
        this.testUnwrap("bigint", "a = REAL '9223372036854775807'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "9.223372E18")));
        this.testUnwrap("bigint", "a = REAL '-8388608'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "-8388608.0")));
        this.testUnwrap("bigint", "a = REAL '-9223372036854775807'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "-9.223372E18")));
        this.testUnwrap("integer", "a = REAL '8388608'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "8388608.0")));
        this.testUnwrap("integer", "a = REAL '2147483647'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "2.1474836E9")));
        this.testUnwrap("integer", "a = REAL '-8388608'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "-8388608.0")));
        this.testUnwrap("integer", "a = REAL '-2147483647'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "-2.1474836E9")));
        this.testUnwrap("decimal(16)", "a = DOUBLE '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)DoubleType.DOUBLE), (Expression)new DoubleLiteral(1.0)));
        this.testUnwrap("decimal(8)", "a = REAL '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)RealType.REAL), (Expression)new GenericLiteral((Type)RealType.REAL, "1.0")));
        this.testUnwrap("varchar", "CAST(a AS INTEGER) = INTEGER '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)IntegerType.INTEGER), (Expression)new LongLiteral(1L)));
        this.testUnwrap("double", "CAST(a AS INTEGER) = INTEGER '1'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new SymbolReference("a"), (Type)IntegerType.INTEGER), (Expression)new LongLiteral(1L)));
    }

    @Test
    public void testUnwrapCastTimestampAsDate() {
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "CAST(a AS DATE) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "CAST(a AS DATE) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "CAST(a AS DATE) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) = NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) < NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) <= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) > NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) >= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) IS DISTINCT FROM NULL", (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DateType.DATE))));
        this.testUnwrap("timestamp(3)", "CAST(a AS DATE) = DATE '1981-06-22' + INTERVAL '2' DAY", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-24 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-25 00:00:00.000")))));
        this.testUnwrap("timestamp(3)", "DATE '1981-06-22' = CAST(a AS DATE)", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
    }

    @Test
    public void testUnwrapConvertTimestatmpToDate() {
        this.testUnwrap("timestamp(3)", "date(a) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "date(a) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "date(a) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "date(a) = DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "date(a) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "date(a) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "date(a) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "date(a) <> DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "date(a) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "date(a) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "date(a) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "date(a) < DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "date(a) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "date(a) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "date(a) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "date(a) <= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "date(a) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "date(a) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "date(a) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "date(a) > DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "date(a) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")));
        this.testUnwrap("timestamp(6)", "date(a) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")));
        this.testUnwrap("timestamp(9)", "date(a) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")));
        this.testUnwrap("timestamp(12)", "date(a) >= DATE '1981-06-22'", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")));
        this.testUnwrap("timestamp(3)", "date(a) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "date(a) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "date(a) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "date(a) IS DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "date(a) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
        this.testUnwrap("timestamp(6)", "date(a) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-22 00:00:00.000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "1981-06-23 00:00:00.000000")))));
        this.testUnwrap("timestamp(9)", "date(a) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-22 00:00:00.000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "1981-06-23 00:00:00.000000000")))));
        this.testUnwrap("timestamp(12)", "date(a) IS NOT DISTINCT FROM DATE '1981-06-22'", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("a"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-22 00:00:00.000000000000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "1981-06-23 00:00:00.000000000000")))));
        this.testUnwrap("timestamp(3)", "date(a) = NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "date(a) < NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "date(a) <= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "date(a) > NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "date(a) >= NULL", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp(3)", "date(a) IS DISTINCT FROM NULL", (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DateType.DATE))));
        this.testUnwrap("timestamp(3)", "date(a) = DATE '1981-06-22' + INTERVAL '2' DAY", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-24 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-25 00:00:00.000")))));
        this.testUnwrap("timestamp(3)", "DATE '1981-06-22' = date(a)", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-22 00:00:00.000")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1981-06-23 00:00:00.000")))));
    }

    private void testRemoveFilter(String inputType, String inputPredicate) {
        this.assertPlan(String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s AND rand() = 42", inputType, inputPredicate), PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCall(QualifiedName.of((String)"random"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(42.0)), PlanMatchPattern.values("a"))));
    }

    private void testUnwrap(String inputType, String inputPredicate, Expression expectedPredicate) {
        this.testUnwrap(this.getPlanTester().getDefaultSession(), inputType, inputPredicate, expectedPredicate);
    }

    private void testUnwrap(Session session, String inputType, String inputPredicate, Expression expected) {
        LogicalExpression logical;
        ComparisonExpression antiOptimization = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCall(QualifiedName.of((String)"random"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(42.0));
        expected = expected instanceof LogicalExpression && (logical = (LogicalExpression)expected).getOperator() == LogicalExpression.Operator.OR ? new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.builder().addAll((Iterable)logical.getTerms()).add((Object)antiOptimization).build()) : new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)expected, (Object)antiOptimization));
        this.assertPlan(String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE (%s) OR rand() = 42", inputType, inputPredicate), session, PlanMatchPattern.output(PlanMatchPattern.filter(expected, PlanMatchPattern.values("a"))));
    }

    private static Session withZone(Session session, TimeZoneKey timeZoneKey) {
        return Session.builder((Session)Objects.requireNonNull(session, "session is null")).setTimeZoneKey(Objects.requireNonNull(timeZoneKey, "timeZoneKey is null")).build();
    }
}

