/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.UnwrapYearInComparison;
import io.trino.sql.tree.QualifiedName;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnwrapYearInComparison
extends BasePlanTest {
    @Test
    public void testEquals() {
        this.testUnwrap("date", "year(a) = -0001", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-12-31")));
        this.testUnwrap("date", "year(a) = 1960", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-12-31")));
        this.testUnwrap("date", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31")));
        this.testUnwrap("date", "year(a) = 9999", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-12-31")));
        this.testUnwrap("timestamp", "year(a) = -0001", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) = 1960", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) = 9999", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(0)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-01-01 00:00:00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-12-31 23:59:59")));
        this.testUnwrap("timestamp(1)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-01-01 00:00:00.0"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-12-31 23:59:59.9")));
        this.testUnwrap("timestamp(2)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-01-01 00:00:00.00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-12-31 23:59:59.99")));
        this.testUnwrap("timestamp(3)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(4)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-01-01 00:00:00.0000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-12-31 23:59:59.9999")));
        this.testUnwrap("timestamp(5)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-01-01 00:00:00.00000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-12-31 23:59:59.99999")));
        this.testUnwrap("timestamp(6)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-01-01 00:00:00.000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-12-31 23:59:59.999999")));
        this.testUnwrap("timestamp(7)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-01-01 00:00:00.0000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-12-31 23:59:59.9999999")));
        this.testUnwrap("timestamp(8)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-01-01 00:00:00.00000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-12-31 23:59:59.99999999")));
        this.testUnwrap("timestamp(9)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-01-01 00:00:00.000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-12-31 23:59:59.999999999")));
        this.testUnwrap("timestamp(10)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-01-01 00:00:00.0000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-12-31 23:59:59.9999999999")));
        this.testUnwrap("timestamp(11)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-01-01 00:00:00.00000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-12-31 23:59:59.99999999999")));
        this.testUnwrap("timestamp(12)", "year(a) = 2022", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-01-01 00:00:00.000000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-12-31 23:59:59.999999999999")));
    }

    @Test
    public void testInPredicate() {
        this.testUnwrap("date", "year(a) IN (1000, 1400, 1800)", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1000-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1000-12-31")), (Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1400-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1400-12-31")), (Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1800-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1800-12-31")))));
        this.testUnwrap("timestamp", "year(a) IN (1000, 1400, 1800)", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1000-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1000-12-31 23:59:59.999")), (Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1400-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1400-12-31 23:59:59.999")), (Object)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1800-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1800-12-31 23:59:59.999")))));
    }

    @Test
    public void testNotEquals() {
        this.testUnwrap("date", "year(a) <> -0001", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-12-31"))));
        this.testUnwrap("date", "year(a) <> 1960", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-12-31"))));
        this.testUnwrap("date", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31"))));
        this.testUnwrap("date", "year(a) <> 9999", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-12-31"))));
        this.testUnwrap("timestamp", "year(a) <> -0001", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <> 1960", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <> 9999", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(0)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-01-01 00:00:00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-12-31 23:59:59"))));
        this.testUnwrap("timestamp(1)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-01-01 00:00:00.0"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-12-31 23:59:59.9"))));
        this.testUnwrap("timestamp(2)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-01-01 00:00:00.00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-12-31 23:59:59.99"))));
        this.testUnwrap("timestamp(3)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(4)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-01-01 00:00:00.0000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-12-31 23:59:59.9999"))));
        this.testUnwrap("timestamp(5)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-01-01 00:00:00.00000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-12-31 23:59:59.99999"))));
        this.testUnwrap("timestamp(6)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-01-01 00:00:00.000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-12-31 23:59:59.999999"))));
        this.testUnwrap("timestamp(7)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-01-01 00:00:00.0000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-12-31 23:59:59.9999999"))));
        this.testUnwrap("timestamp(8)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-01-01 00:00:00.00000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-12-31 23:59:59.99999999"))));
        this.testUnwrap("timestamp(9)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-01-01 00:00:00.000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-12-31 23:59:59.999999999"))));
        this.testUnwrap("timestamp(10)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-01-01 00:00:00.0000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-12-31 23:59:59.9999999999"))));
        this.testUnwrap("timestamp(11)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-01-01 00:00:00.00000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-12-31 23:59:59.99999999999"))));
        this.testUnwrap("timestamp(12)", "year(a) <> 2022", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-01-01 00:00:00.000000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-12-31 23:59:59.999999999999"))));
    }

    @Test
    public void testLessThan() {
        this.testUnwrap("date", "year(a) < -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-01-01")));
        this.testUnwrap("date", "year(a) < 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-01-01")));
        this.testUnwrap("date", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01")));
        this.testUnwrap("date", "year(a) < 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-01-01")));
        this.testUnwrap("timestamp", "year(a) < -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) < 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) < 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-01-01 00:00:00.000")));
        this.testUnwrap("timestamp(0)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-01-01 00:00:00")));
        this.testUnwrap("timestamp(1)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-01-01 00:00:00.0")));
        this.testUnwrap("timestamp(2)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-01-01 00:00:00.00")));
        this.testUnwrap("timestamp(3)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000")));
        this.testUnwrap("timestamp(4)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-01-01 00:00:00.0000")));
        this.testUnwrap("timestamp(5)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-01-01 00:00:00.00000")));
        this.testUnwrap("timestamp(6)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-01-01 00:00:00.000000")));
        this.testUnwrap("timestamp(7)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-01-01 00:00:00.0000000")));
        this.testUnwrap("timestamp(8)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-01-01 00:00:00.00000000")));
        this.testUnwrap("timestamp(9)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-01-01 00:00:00.000000000")));
        this.testUnwrap("timestamp(10)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-01-01 00:00:00.0000000000")));
        this.testUnwrap("timestamp(11)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-01-01 00:00:00.00000000000")));
        this.testUnwrap("timestamp(12)", "year(a) < 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-01-01 00:00:00.000000000000")));
    }

    @Test
    public void testLessThanOrEqual() {
        this.testUnwrap("date", "year(a) <= -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-12-31")));
        this.testUnwrap("date", "year(a) <= 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-12-31")));
        this.testUnwrap("date", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31")));
        this.testUnwrap("date", "year(a) <= 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-12-31")));
        this.testUnwrap("timestamp", "year(a) <= -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) <= 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) <= 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(0)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-12-31 23:59:59")));
        this.testUnwrap("timestamp(1)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-12-31 23:59:59.9")));
        this.testUnwrap("timestamp(2)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-12-31 23:59:59.99")));
        this.testUnwrap("timestamp(3)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(4)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-12-31 23:59:59.9999")));
        this.testUnwrap("timestamp(5)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-12-31 23:59:59.99999")));
        this.testUnwrap("timestamp(6)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-12-31 23:59:59.999999")));
        this.testUnwrap("timestamp(7)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-12-31 23:59:59.9999999")));
        this.testUnwrap("timestamp(8)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-12-31 23:59:59.99999999")));
        this.testUnwrap("timestamp(9)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-12-31 23:59:59.999999999")));
        this.testUnwrap("timestamp(10)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-12-31 23:59:59.9999999999")));
        this.testUnwrap("timestamp(11)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-12-31 23:59:59.99999999999")));
        this.testUnwrap("timestamp(12)", "year(a) <= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-12-31 23:59:59.999999999999")));
    }

    @Test
    public void testGreaterThan() {
        this.testUnwrap("date", "year(a) > -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-12-31")));
        this.testUnwrap("date", "year(a) > 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-12-31")));
        this.testUnwrap("date", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31")));
        this.testUnwrap("date", "year(a) > 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-12-31")));
        this.testUnwrap("timestamp", "year(a) > -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) > 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp", "year(a) > 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(0)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-12-31 23:59:59")));
        this.testUnwrap("timestamp(1)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-12-31 23:59:59.9")));
        this.testUnwrap("timestamp(2)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-12-31 23:59:59.99")));
        this.testUnwrap("timestamp(3)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999")));
        this.testUnwrap("timestamp(4)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-12-31 23:59:59.9999")));
        this.testUnwrap("timestamp(5)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-12-31 23:59:59.99999")));
        this.testUnwrap("timestamp(6)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-12-31 23:59:59.999999")));
        this.testUnwrap("timestamp(7)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-12-31 23:59:59.9999999")));
        this.testUnwrap("timestamp(8)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-12-31 23:59:59.99999999")));
        this.testUnwrap("timestamp(9)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-12-31 23:59:59.999999999")));
        this.testUnwrap("timestamp(10)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-12-31 23:59:59.9999999999")));
        this.testUnwrap("timestamp(11)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-12-31 23:59:59.99999999999")));
        this.testUnwrap("timestamp(12)", "year(a) > 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-12-31 23:59:59.999999999999")));
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.testUnwrap("date", "year(a) >= -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-01-01")));
        this.testUnwrap("date", "year(a) >= 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-01-01")));
        this.testUnwrap("date", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01")));
        this.testUnwrap("date", "year(a) >= 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-01-01")));
        this.testUnwrap("timestamp", "year(a) >= -0001", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) >= 1960", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000")));
        this.testUnwrap("timestamp", "year(a) >= 9999", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-01-01 00:00:00.000")));
        this.testUnwrap("timestamp(0)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-01-01 00:00:00")));
        this.testUnwrap("timestamp(1)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-01-01 00:00:00.0")));
        this.testUnwrap("timestamp(2)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-01-01 00:00:00.00")));
        this.testUnwrap("timestamp(3)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000")));
        this.testUnwrap("timestamp(4)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-01-01 00:00:00.0000")));
        this.testUnwrap("timestamp(5)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-01-01 00:00:00.00000")));
        this.testUnwrap("timestamp(6)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-01-01 00:00:00.000000")));
        this.testUnwrap("timestamp(7)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-01-01 00:00:00.0000000")));
        this.testUnwrap("timestamp(8)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-01-01 00:00:00.00000000")));
        this.testUnwrap("timestamp(9)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-01-01 00:00:00.000000000")));
        this.testUnwrap("timestamp(10)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-01-01 00:00:00.0000000000")));
        this.testUnwrap("timestamp(11)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-01-01 00:00:00.00000000000")));
        this.testUnwrap("timestamp(12)", "year(a) >= 2022", (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-01-01 00:00:00.000000000000")));
    }

    @Test
    public void testDistinctFrom() {
        this.testUnwrap("date", "year(a) IS DISTINCT FROM -0001", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "-0001-12-31"))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 1960", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "1960-12-31"))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31"))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 9999", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "9999-12-31"))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM -0001", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "-0001-12-31 23:59:59.999"))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 1960", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "1960-12-31 23:59:59.999"))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999"))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 9999", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "9999-12-31 23:59:59.999"))))));
        this.testUnwrap("timestamp(0)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-01-01 00:00:00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)0), "2022-12-31 23:59:59"))))));
        this.testUnwrap("timestamp(1)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-01-01 00:00:00.0"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)1), "2022-12-31 23:59:59.9"))))));
        this.testUnwrap("timestamp(2)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-01-01 00:00:00.00"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)2), "2022-12-31 23:59:59.99"))))));
        this.testUnwrap("timestamp(3)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2022-12-31 23:59:59.999"))))));
        this.testUnwrap("timestamp(4)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-01-01 00:00:00.0000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)4), "2022-12-31 23:59:59.9999"))))));
        this.testUnwrap("timestamp(5)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-01-01 00:00:00.00000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)5), "2022-12-31 23:59:59.99999"))))));
        this.testUnwrap("timestamp(6)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-01-01 00:00:00.000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)6), "2022-12-31 23:59:59.999999"))))));
        this.testUnwrap("timestamp(7)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-01-01 00:00:00.0000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)7), "2022-12-31 23:59:59.9999999"))))));
        this.testUnwrap("timestamp(8)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-01-01 00:00:00.00000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)8), "2022-12-31 23:59:59.99999999"))))));
        this.testUnwrap("timestamp(9)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-01-01 00:00:00.000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2022-12-31 23:59:59.999999999"))))));
        this.testUnwrap("timestamp(10)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-01-01 00:00:00.0000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)10), "2022-12-31 23:59:59.9999999999"))))));
        this.testUnwrap("timestamp(11)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-01-01 00:00:00.00000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)11), "2022-12-31 23:59:59.99999999999"))))));
        this.testUnwrap("timestamp(12)", "year(a) IS DISTINCT FROM 2022", (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-01-01 00:00:00.000000000000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)12), "2022-12-31 23:59:59.999999999999"))))));
    }

    @Test
    public void testNull() {
        this.testUnwrap("date", "year(a) = CAST(NULL AS BIGINT)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        this.testUnwrap("timestamp", "year(a) = CAST(NULL AS BIGINT)", (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
    }

    @Test
    public void testNaN() {
        this.testUnwrap("date", "year(a) = nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new FunctionCall(QualifiedName.of((String)"year"), (List)ImmutableList.of((Object)new SymbolReference("a")))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
        this.testUnwrap("timestamp", "year(a) = nan()", (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new FunctionCall(QualifiedName.of((String)"year"), (List)ImmutableList.of((Object)new SymbolReference("a")))), (Object)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("date", String.format("year(a) = %s '2022'", type), (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31")));
        }
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES DATE '2022-01-01') t(a) WHERE 2022 = year(a)", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new BetweenPredicate((Expression)new SymbolReference("A"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2022-12-31")), PlanMatchPattern.values("A"))));
    }

    @Test
    public void testLeapYear() {
        this.testUnwrap("date", "year(a) = 2024", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)DateType.DATE, "2024-01-01"), (Expression)new GenericLiteral((Type)DateType.DATE, "2024-12-31")));
        this.testUnwrap("timestamp", "year(a) = 2024", (Expression)new BetweenPredicate((Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2024-01-01 00:00:00.000"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)3), "2024-12-31 23:59:59.999")));
    }

    @Test
    public void testCalculateRangeEndInclusive() {
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(1960, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(2024, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999999));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999999));
    }

    private static long toEpochMicros(LocalDateTime localDateTime) {
        return Math.multiplyExact(localDateTime.toEpochSecond(ZoneOffset.UTC), 1000000) + (long)(localDateTime.getNano() / 1000);
    }

    private void testUnwrap(String inputType, String inputPredicate, Expression expected) {
        LogicalExpression logical;
        ComparisonExpression antiOptimization = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCall(QualifiedName.of((String)"random"), (List)ImmutableList.of()), (Expression)new DoubleLiteral(42.0));
        expected = expected instanceof LogicalExpression && (logical = (LogicalExpression)expected).getOperator() == LogicalExpression.Operator.OR ? new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.builder().addAll((Iterable)logical.getTerms()).add((Object)antiOptimization).build()) : new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)expected, (Object)antiOptimization));
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s OR rand() = 42", inputType, inputPredicate);
        try {
            this.assertPlan(sql, this.getPlanTester().getDefaultSession(), PlanMatchPattern.output(PlanMatchPattern.filter(expected, PlanMatchPattern.values("a"))));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }
}

