/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowClause
extends BasePlanTest {
    @Test
    public void testPreprojectExpression() {
        String sql = "SELECT max(b) OVER w FROM (VALUES (1, 1)) t(a, b) WINDOW w AS (PARTITION BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"b"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b"))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testPreprojectExpressions() {
        String sql = "SELECT max(b) OVER w3 FROM (VALUES (1, 1, 1)) t(a, b, c) WINDOW w1 AS (PARTITION BY a + 1), w2 AS (w1 ORDER BY b + 2), w3 AS (w2 RANGE c + 3 PRECEDING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr_a"), (List<String>)ImmutableList.of((Object)"expr_b"), (Map<String, SortOrder>)ImmutableMap.of((Object)"expr_b", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"b"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol("frame_start")), Optional.of(new Symbol("expr_b")), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("expr_b"), (Object)new SymbolReference("expr_c"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_a", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L))), (Object)"expr_b", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L))), (Object)"expr_c", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(3L)))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b", "c")))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowFunctionsInSelectAndOrderBy() {
        String sql = "SELECT array_agg(a) OVER (w ORDER BY a + 1), -a a FROM (VALUES 1, 2, 3) t(a) WINDOW w AS () ORDER BY max(a) OVER (w ORDER BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("max_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"order_by_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"minus_a"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("minus_a"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"minus_a", (Object)PlanMatchPattern.expression((Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("a")))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"select_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"select_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"a"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"select_window_sortkey", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a"))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowWithFrameCoercions() {
        String sql = "SELECT a old_a, 2e0 a FROM (VALUES -100, -99, -98) t(a) WINDOW w AS (ORDER BY a + 1) ORDER BY count(*) OVER (w RANGE BETWEEN CURRENT ROW AND a + 1e0 FOLLOWING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("count_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("count_result", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.FOLLOWING, Optional.of(new Symbol("frame_bound")), Optional.of(new Symbol("coerced_sortkey"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_bound", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("coerced_sortkey"), (Object)new SymbolReference("frame_offset"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"coerced_sortkey", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("sortkey"), (Type)DoubleType.DOUBLE))), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sortkey", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L))), (Object)"frame_offset", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("new_a"), (Expression)new DoubleLiteral(1.0)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_a", (Object)PlanMatchPattern.expression((Expression)new DoubleLiteral(2.0))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.values("a")))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

