/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowFrameRange
extends BasePlanTest {
    @Test
    public void testFramePrecedingWithSortKeyCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE x PRECEDING) FROM (VALUES (1, 1.1), (2, 2.2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol("frame_start_value")), Optional.of(new Symbol("key_for_frame_start_comparison")), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_comparison", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("key"), (Type)DecimalType.createDecimalType((int)12, (int)1)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("key_for_frame_start_calculation"), (Object)new SymbolReference("x"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_calculation", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("key"), (Type)DecimalType.createDecimalType((int)10, (int)0)))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DecimalType.createDecimalType((int)2, (int)1))), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, Integer.toString(StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode())), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Window frame offset value must not be negative or null"))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L), (Object)new DecimalLiteral("1.1")), (Object)ImmutableList.of((Object)new LongLiteral(2L), (Object)new DecimalLiteral("2.2")))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFrameFollowingWithOffsetCoercion() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN CURRENT ROW AND x FOLLOWING) FROM (VALUES (1.1, 1), (2.2, 2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.FOLLOWING, Optional.of(new Symbol("frame_end_value")), Optional.of(new Symbol("key_for_frame_end_comparison"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_end_comparison", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("key"), (Type)DecimalType.createDecimalType((int)12, (int)1)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("offset"))))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("offset"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)DecimalType.createDecimalType((int)10, (int)0))), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, Integer.toString(StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode())), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Window frame offset value must not be negative or null"))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"offset", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("x"), (Type)DecimalType.createDecimalType((int)10, (int)0)))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DecimalLiteral("1.1"), (Object)new LongLiteral(1L)), (Object)ImmutableList.of((Object)new DecimalLiteral("2.2"), (Object)new LongLiteral(2L)))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFramePrecedingFollowingNoCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN x PRECEDING AND y FOLLOWING) FROM (VALUES (1, 1, 1), (2, 2, 2)) t(key, x, y)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol("frame_start_value")), Optional.of(new Symbol("key")), FrameBoundType.FOLLOWING, Optional.of(new Symbol("frame_end_value")), Optional.of(new Symbol("key"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("y"))))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("y"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)IntegerType.INTEGER)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, Integer.toString(StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode())), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Window frame offset value must not be negative or null"))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("x"))))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new Cast((Expression)new LongLiteral(0L), (Type)IntegerType.INTEGER)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, Integer.toString(StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode())), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Window frame offset value must not be negative or null"))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L), (Object)new LongLiteral(1L), (Object)new LongLiteral(1L)), (Object)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(2L), (Object)new LongLiteral(2L)))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

