/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExpressionMatcher
implements RvalueMatcher {
    private final String sql;
    private final Expression expression;

    ExpressionMatcher(Expression expression) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.sql = expression.toString();
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        ImmutableList.Builder matchesBuilder = ImmutableList.builder();
        Map<Symbol, Expression> assignments = ExpressionMatcher.getAssignments(node);
        if (assignments == null) {
            return result;
        }
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
            if (!((Boolean)verifier.process(assignment.getValue(), this.expression)).booleanValue()) continue;
            result = Optional.of(assignment.getKey());
            matchesBuilder.add((Object)assignment.getValue());
        }
        ImmutableList matches = matchesBuilder.build();
        Preconditions.checkState((matches.size() < 2 ? 1 : 0) != 0, (String)"Ambiguous expression %s matches multiple assignments: %s", (Object)this.expression, (Object)matches);
        return result;
    }

    private static Map<Symbol, Expression> getAssignments(PlanNode node) {
        if (node instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)node;
            return projectNode.getAssignments().getMap();
        }
        return null;
    }

    public String toString() {
        return this.sql;
    }
}

