/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExpressionVerifier
extends IrVisitor<Boolean, Expression> {
    private final SymbolAliases symbolAliases;

    public ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitGenericLiteral(GenericLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof GenericLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression)) && actual.getType().equals((Object)((GenericLiteral)expectedExpression).getType());
    }

    protected Boolean visitStringLiteral(StringLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof StringLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitLongLiteral(LongLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof LongLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDoubleLiteral(DoubleLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof DoubleLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDecimalLiteral(DecimalLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof DecimalLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitBooleanLiteral(BooleanLiteral actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof BooleanLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Expression)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitNullLiteral(NullLiteral node, Expression expectedExpression) {
        return expectedExpression instanceof NullLiteral;
    }

    private static String getValueFromLiteral(Expression expression) {
        if (expression instanceof LongLiteral) {
            return String.valueOf(((LongLiteral)expression).getValue());
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof DoubleLiteral) {
            return String.valueOf(((DoubleLiteral)expression).getValue());
        }
        if (expression instanceof DecimalLiteral) {
            return String.valueOf(((DecimalLiteral)expression).getValue());
        }
        if (expression instanceof GenericLiteral) {
            return ((GenericLiteral)expression).getValue();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getValue();
        }
        throw new IllegalArgumentException("Unsupported literal expression type: " + expression.getClass().getName());
    }

    protected Boolean visitSymbolReference(SymbolReference actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SymbolReference)) {
            return false;
        }
        SymbolReference expected = (SymbolReference)expectedExpression;
        return this.symbolAliases.get(expected.getName()).equals((Object)actual);
    }

    protected Boolean visitIfExpression(IfExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof IfExpression)) {
            return false;
        }
        IfExpression expected = (IfExpression)expectedExpression;
        return (Boolean)this.process(actual.getCondition(), expected.getCondition()) != false && (Boolean)this.process(actual.getTrueValue(), expected.getTrueValue()) != false && this.process(actual.getFalseValue(), expected.getFalseValue());
    }

    protected Boolean visitCast(Cast actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.getType().toString().equalsIgnoreCase(expected.getType().toString())) {
            return false;
        }
        return (Boolean)this.process(actual.getExpression(), expected.getExpression());
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate expected = (IsNullPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof IsNotNullPredicate)) {
            return false;
        }
        IsNotNullPredicate expected = (IsNotNullPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitInPredicate(InPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof InPredicate)) {
            return false;
        }
        InPredicate expected = (InPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue()) != false && this.process(actual.getValueList(), expected.getValueList());
    }

    protected Boolean visitComparisonExpression(ComparisonExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ComparisonExpression)) {
            return false;
        }
        ComparisonExpression expected = (ComparisonExpression)expectedExpression;
        if (actual.getOperator() == expected.getOperator() && ((Boolean)this.process(actual.getLeft(), expected.getLeft())).booleanValue() && ((Boolean)this.process(actual.getRight(), expected.getRight())).booleanValue()) {
            return true;
        }
        return actual.getOperator() == expected.getOperator().flip() && (Boolean)this.process(actual.getLeft(), expected.getRight()) != false && (Boolean)this.process(actual.getRight(), expected.getLeft()) != false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof BetweenPredicate)) {
            return false;
        }
        BetweenPredicate expected = (BetweenPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue()) != false && (Boolean)this.process(actual.getMin(), expected.getMin()) != false && (Boolean)this.process(actual.getMax(), expected.getMax()) != false;
    }

    protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticUnaryExpression)) {
            return false;
        }
        ArithmeticUnaryExpression expected = (ArithmeticUnaryExpression)expectedExpression;
        return actual.getSign() == expected.getSign() && (Boolean)this.process(actual.getValue(), expected.getValue()) != false;
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticBinaryExpression)) {
            return false;
        }
        ArithmeticBinaryExpression expected = (ArithmeticBinaryExpression)expectedExpression;
        return actual.getOperator() == expected.getOperator() && (Boolean)this.process(actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process(actual.getRight(), expected.getRight()) != false;
    }

    protected Boolean visitNotExpression(NotExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof NotExpression)) {
            return false;
        }
        NotExpression expected = (NotExpression)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitLogicalExpression(LogicalExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof LogicalExpression)) {
            return false;
        }
        LogicalExpression expected = (LogicalExpression)expectedExpression;
        if (actual.getTerms().size() != expected.getTerms().size() || actual.getOperator() != expected.getOperator()) {
            return false;
        }
        for (int i = 0; i < actual.getTerms().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.getTerms().get(i), (Expression)expected.getTerms().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof CoalesceExpression)) {
            return false;
        }
        CoalesceExpression expected = (CoalesceExpression)expectedExpression;
        if (actual.getOperands().size() != expected.getOperands().size()) {
            return false;
        }
        for (int i = 0; i < actual.getOperands().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.getOperands().get(i), (Expression)expected.getOperands().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression expected = (SimpleCaseExpression)expectedExpression;
        return (Boolean)this.process(actual.getOperand(), expected.getOperand()) != false && this.process(actual.getWhenClauses(), expected.getWhenClauses()) && this.process(actual.getDefaultValue(), expected.getDefaultValue());
    }

    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression actual, Expression expected) {
        if (!(expected instanceof SearchedCaseExpression)) {
            return false;
        }
        SearchedCaseExpression expectedCase = (SearchedCaseExpression)expected;
        if (!this.process(actual.getWhenClauses(), expectedCase.getWhenClauses())) {
            return false;
        }
        if (actual.getDefaultValue().isPresent() != expectedCase.getDefaultValue().isPresent()) {
            return false;
        }
        return this.process(actual.getDefaultValue(), expectedCase.getDefaultValue());
    }

    protected Boolean visitWhenClause(WhenClause actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof WhenClause)) {
            return false;
        }
        WhenClause expected = (WhenClause)expectedExpression;
        return (Boolean)this.process(actual.getOperand(), expected.getOperand()) != false && (Boolean)this.process(actual.getResult(), expected.getResult()) != false;
    }

    protected Boolean visitFunctionCall(FunctionCall actual, Expression expectedExpression) {
        CatalogSchemaFunctionName expectedFunctionName;
        if (!(expectedExpression instanceof FunctionCall)) {
            return false;
        }
        FunctionCall expected = (FunctionCall)expectedExpression;
        if (ResolvedFunction.isResolved((QualifiedName)expected.getName())) {
            expectedFunctionName = ResolvedFunction.extractFunctionName((QualifiedName)expected.getName());
        } else {
            Preconditions.checkArgument((expected.getName().getParts().size() == 1 ? 1 : 0) != 0, (String)"Unresolved function call name must not be qualified: %s", (Object)expected.getName());
            expectedFunctionName = GlobalFunctionCatalog.builtinFunctionName((String)expected.getName().getSuffix());
        }
        return ResolvedFunction.extractFunctionName((QualifiedName)actual.getName()).equals((Object)expectedFunctionName) && this.process(actual.getArguments(), expected.getArguments());
    }

    protected Boolean visitLambdaExpression(LambdaExpression actual, Expression expected) {
        if (!(expected instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambdaExpression = (LambdaExpression)expected;
        if (!actual.getArguments().equals(lambdaExpression.getArguments())) {
            return false;
        }
        return (Boolean)this.process(actual.getBody(), lambdaExpression.getBody());
    }

    protected Boolean visitRow(Row actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Row)) {
            return false;
        }
        Row expected = (Row)expectedExpression;
        return this.process(actual.getItems(), expected.getItems());
    }

    protected Boolean visitSubscriptExpression(SubscriptExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SubscriptExpression)) {
            return false;
        }
        SubscriptExpression expected = (SubscriptExpression)expectedExpression;
        return (Boolean)this.process(actual.getBase(), expected.getBase()) != false && (Boolean)this.process(actual.getIndex(), expected.getIndex()) != false;
    }

    private <T extends Expression> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Expression)actuals.get(i), (Expression)expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Expression> boolean process(Optional<T> actual, Optional<T> expected) {
        if (actual.isPresent() != expected.isPresent()) {
            return false;
        }
        if (actual.isPresent()) {
            return (Boolean)this.process((Expression)actual.get(), (Expression)expected.get());
        }
        return true;
    }
}

