/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionVerifier {
    @Test
    public void test() {
        NotExpression actual = new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("custkey"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(10L)))));
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("Y"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(10L)))))))).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestExpressionVerifier.lambda$test$0(verifier, (Expression)actual)).isInstanceOf(IllegalStateException.class)).hasMessage("missing expression for alias Z");
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(10L)))))))).isFalse();
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(aliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new GenericLiteral((Type)VarcharType.VARCHAR, "2"), new GenericLiteral((Type)VarcharType.VARCHAR, "2")))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new GenericLiteral((Type)VarcharType.VARCHAR, "2"), new Cast((Expression)new StringLiteral("2"), (Type)BigintType.BIGINT)))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Cast((Expression)new SymbolReference("orderkey"), (Type)VarcharType.VARCHAR), new Cast((Expression)new SymbolReference("X"), (Type)VarcharType.VARCHAR)))).isTrue();
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference("orderkey")).put("Y", new SymbolReference("custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), new BetweenPredicate((Expression)new SymbolReference("X"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), new BetweenPredicate((Expression)new SymbolReference("Y"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("custkey"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), new BetweenPredicate((Expression)new SymbolReference("X"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(2L), (Expression)new LongLiteral(4L)), new BetweenPredicate((Expression)new SymbolReference("X"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), new BetweenPredicate((Expression)new SymbolReference("X"), (Expression)new StringLiteral("1"), (Expression)new StringLiteral("2"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference("orderkey"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)), new BetweenPredicate((Expression)new SymbolReference("X"), (Expression)new LongLiteral(4L), (Expression)new LongLiteral(7L))))).isFalse();
    }

    @Test
    public void testSymmetry() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("a", new SymbolReference("x")).put("b", new SymbolReference("y")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("y"), (Expression)new SymbolReference("x")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("a"))))).isTrue();
    }

    private static /* synthetic */ void lambda$test$0(ExpressionVerifier verifier, Expression actual) throws Throwable {
        verifier.process(actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("X"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("Y"), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("Z"), (Expression)new LongLiteral(10L))))));
    }
}

