/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Optional;

class WindowFrameMatcher {
    private WindowFrameMatcher() {
    }

    public static boolean matches(WindowNode.Frame expected, WindowNode.Frame actual, SymbolAliases aliases) {
        return expected.getType().equals((Object)actual.getType()) && expected.getStartType().equals((Object)actual.getStartType()) && expected.getEndType().equals((Object)actual.getEndType()) && WindowFrameMatcher.matches(expected.getStartValue(), actual.getStartValue(), aliases) && WindowFrameMatcher.matches(expected.getSortKeyCoercedForFrameEndComparison(), actual.getSortKeyCoercedForFrameEndComparison(), aliases) && WindowFrameMatcher.matches(expected.getEndValue(), actual.getEndValue(), aliases) && WindowFrameMatcher.matches(expected.getSortKeyCoercedForFrameEndComparison(), actual.getSortKeyCoercedForFrameEndComparison(), aliases);
    }

    private static boolean matches(Optional<Symbol> expected, Optional<Symbol> actual, SymbolAliases aliases) {
        if (expected.isPresent() != actual.isPresent()) {
            return false;
        }
        return expected.map(symbol -> aliases.get(symbol.getName()).getName().equals(((Symbol)actual.get()).getName())).orElse(true);
    }
}

