/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestCanonicalizeExpressionRewriter {
    private static final TransactionManager TRANSACTION_MANAGER = InMemoryTransactionManager.createTestTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final IrTypeAnalyzer TYPE_ANALYZER = new IrTypeAnalyzer(PLANNER_CONTEXT);
    private static final AllowAllAccessControl ACCESS_CONTROL = new AllowAllAccessControl();

    @Test
    public void testRewriteIsNotNullPredicate() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new IsNotNullPredicate((Expression)new SymbolReference("x")), (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("x"))));
    }

    @Test
    public void testRewriteIfExpression() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L), (Expression)new LongLiteral(1L)), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(0L)), (Expression)new LongLiteral(0L))), Optional.of(new LongLiteral(1L))));
    }

    @Test
    public void testCanonicalizeArithmetic() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
    }

    @Test
    public void testCanonicalizeComparison() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("a")));
    }

    @Test
    public void testTypedLiteral() {
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2)), (Expression)new SymbolReference("a")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2)), (Expression)new SymbolReference("a")), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new LongLiteral(1L), (Type)DecimalType.createDecimalType((int)5, (int)2))));
    }

    @Test
    public void testCanonicalizeRewriteDateFunctionToCast() {
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)TimestampType.createTimestampType((int)3), "ts");
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "tstz");
        TestCanonicalizeExpressionRewriter.assertCanonicalizedDate((Type)VarcharType.createVarcharType((int)100), "v");
    }

    private static void assertCanonicalizedDate(Type type, String symbolName) {
        FunctionCall date = new FunctionCall(PLANNER_CONTEXT.getMetadata().resolveBuiltinFunction("date", TypeSignatureProvider.fromTypes((Type[])new Type[]{type})).toQualifiedName(), (List)ImmutableList.of((Object)new SymbolReference(symbolName)));
        TestCanonicalizeExpressionRewriter.assertRewritten((Expression)date, (Expression)new Cast((Expression)new SymbolReference(symbolName), (Type)DateType.DATE));
    }

    private static void assertRewritten(Expression from, Expression to) {
        ExpressionTestUtils.assertExpressionEquals((Expression)TransactionBuilder.transaction((TransactionManager)TRANSACTION_MANAGER, (Metadata)PLANNER_CONTEXT.getMetadata(), (AccessControl)ACCESS_CONTROL).execute(SessionTestUtils.TEST_SESSION, transactedSession -> CanonicalizeExpressionRewriter.rewrite((Expression)from, (Session)transactedSession, (PlannerContext)PLANNER_CONTEXT, (IrTypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("x"), (Object)BigintType.BIGINT).put((Object)new Symbol("a"), (Object)BigintType.BIGINT).put((Object)new Symbol("ts"), (Object)TimestampType.createTimestampType((int)3)).put((Object)new Symbol("tstz"), (Object)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).put((Object)new Symbol("v"), (Object)VarcharType.createVarcharType((int)100)).buildOrThrow()))), to, SymbolAliases.builder().put("x", new SymbolReference("x")).put("a", new SymbolReference("a")).put("ts", new SymbolReference("ts")).put("tstz", new SymbolReference("tstz")).put("v", new SymbolReference("v")).build());
    }
}

