/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateInnerUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateInnerUnnestWithGlobalAggregation
extends BaseRuleTest {
    public TestDecorrelateInnerUnnestWithGlobalAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.symbol("unnested")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values(new Symbol[0])))))).doesNotFire();
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).doesNotFire();
    }

    @Test
    public void testTransformCorrelatedUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testPreexistingMask() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr"), (Object)p.symbol("old_masks")), (PlanNode)p.values(p.symbol("corr"), p.symbol("old_masks")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("old_mask")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("old_masks"), (List)ImmutableList.of((Object)p.symbol("old_mask")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "old_masks", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("old_mask"), (Object)new SymbolReference("mask"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"old_masks", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("old_masks", (List<String>)ImmutableList.of((Object)"old_mask"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr", "old_masks"))))))));
    }

    @Test
    public void testWithPreexistingOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testMultipleGlobalAggregations() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.globalGrouping().addAggregation(p.symbol("arbitrary"), PlanBuilder.aggregation("arbitrary", (List<Expression>)ImmutableList.of((Object)new SymbolReference("sum"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("any_value"), PlanMatchPattern.aggregationFunction("any_value", (List<String>)ImmutableList.of((Object)"sum"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testProjectOverGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L))), (PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))).matches(PlanMatchPattern.project(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("unique")), (Object)"sum_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> {
            Symbol corr = p.symbol("corr", (Type)VarcharType.VARCHAR);
            FunctionCall regexpExtractAll = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)corr.toSymbolReference(), (Object)new StringLiteral(".")));
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)corr), (PlanNode)p.values(corr), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("max"), PlanBuilder.aggregation("max", (List<Expression>)ImmutableList.of((Object)new SymbolReference("unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array"), (Expression)regexpExtractAll), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "char_array"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"regexp_extract_all"), (List)ImmutableList.of((Object)new SymbolReference("corr"), (Object)new StringLiteral("."))))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testMultipleNodesOverUnnestInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("groups"), (Object)p.symbol("numbers")), (PlanNode)p.values(p.symbol("groups"), p.symbol("numbers")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L))), (PlanNode)p.aggregation(globalBuilder -> globalBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("negate"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().put(p.symbol("negate"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("max"))).build(), (PlanNode)p.aggregation(groupedBuilder -> groupedBuilder.singleGroupingSet(p.symbol("group")).addAggregation(p.symbol("max"), PlanBuilder.aggregation("max", (List<Expression>)ImmutableList.of((Object)new SymbolReference("modulo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentities((Iterable)ImmutableList.of((Object)p.symbol("group"), (Object)p.symbol("number"))).put(p.symbol("modulo"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("number"), (Expression)new LongLiteral(10L))).build(), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("groups"), (List)ImmutableList.of((Object)p.symbol("group"))), (Object)new UnnestNode.Mapping(p.symbol("numbers"), (List)ImmutableList.of((Object)p.symbol("number")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"negated"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"negated", (Object)PlanMatchPattern.expression((Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("max")))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique", "mask", "group"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"modulo"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"modulo", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("number"), (Expression)new LongLiteral(10L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression((Expression)new IsNotNullPredicate((Expression)new SymbolReference("ordinality")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"groups", (Object)"numbers", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("groups", (List<String>)ImmutableList.of((Object)"group")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("numbers", (List<String>)ImmutableList.of((Object)"number"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("groups", "numbers")))))))))));
    }
}

