/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateUnnest;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateUnnest
extends BaseRuleTest {
    public TestDecorrelateUnnest() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.limit(5L, (PlanNode)p.values(new Symbol[0])))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testLeftCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.INNER, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testLeftCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression((Expression)new IfExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("ordinality")), (Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT), (Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression((Expression)new IfExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("ordinality")), (Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT), (Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")), (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, "28"), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Scalar sub-query has returned multiple rows"))), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimit() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.empty()), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimitWithTies() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("rank_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("rank_number", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testTopN() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.topN(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testProject() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr"))), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("ordinality")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr"))), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IfExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("ordinality")), (Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT), (Expression)new SymbolReference("boolean_result")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("ordinality")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }

    @Test
    public void testDifferentNodesInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("integer_result"), (Expression)new IfExpression((Expression)new SymbolReference("boolean_result"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(-1L))), (PlanNode)p.limit(5L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr"))), (PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")), (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"fail"), (List)ImmutableList.of((Object)new GenericLiteral((Type)IntegerType.INTEGER, "28"), (Object)new GenericLiteral((Type)VarcharType.VARCHAR, "Scalar sub-query has returned multiple rows"))), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("ordinality")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number")), (Object)"integer_result", (Object)PlanMatchPattern.expression((Expression)new IfExpression((Expression)new SymbolReference("boolean_result"), (Expression)new LongLiteral(1L), (Expression)new LongLiteral(-1L)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("ordinality")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "10")), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))))))));
    }

    @Test
    public void testWithPreexistingOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression((Expression)new IfExpression((Expression)new IsNullPredicate((Expression)new SymbolReference("ordinality")), (Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT), (Expression)new SymbolReference("unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> {
            Symbol corr = p.symbol("corr", (Type)VarcharType.VARCHAR);
            FunctionCall regexpExtractAll = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)corr.toSymbolReference(), (Object)new StringLiteral(".")));
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)corr), (PlanNode)p.values(corr), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array"), (List)ImmutableList.of((Object)p.symbol("unnested_char")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array"), (Expression)regexpExtractAll), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_char"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"regexp_extract_all"), (List)ImmutableList.of((Object)new SymbolReference("corr"), (Object)new StringLiteral("."))))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }
}

