/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SetOperationOutputMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementIntersectAll;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestImplementIntersectAll
extends BaseRuleTest {
    public TestImplementIntersectAll() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());
        this.tester().assertThat((Rule<?>)new ImplementIntersectAll(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol a1 = p.symbol("a_1");
            Symbol a2 = p.symbol("a_2");
            Symbol b = p.symbol("b");
            Symbol b1 = p.symbol("b_1");
            Symbol b2 = p.symbol("b_2");
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)a, (Object)a1).put((Object)a, (Object)a2).put((Object)b, (Object)b1).put((Object)b, (Object)b2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a1, b1), (Object)p.values(a2, b2)), false);
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b"))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("row_number"), (Expression)new FunctionCall(QualifiedName.of((String)"least"), (List)ImmutableList.of((Object)new SymbolReference("count_1"), (Object)new SymbolReference("count_2")))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"count_1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("count_1")), (Object)"count_2", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("count_2")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number"))), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("count_1", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of((Object)"marker_1"), frame)).addFunction("count_2", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of((Object)"marker_2"), frame)).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), frame)), PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a_1")), (Object)"b1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b_1")), (Object)"marker_left_1", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL), (Object)"marker_left_2", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN))), PlanMatchPattern.values("a_1", "b_1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a_2")), (Object)"b2", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b_2")), (Object)"marker_right_1", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN)), (Object)"marker_right_2", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values("a_2", "b_2"))).withAlias("a", (RvalueMatcher)new SetOperationOutputMatcher(0)).withAlias("b", (RvalueMatcher)new SetOperationOutputMatcher(1)).withAlias("marker_1", (RvalueMatcher)new SetOperationOutputMatcher(2)).withAlias("marker_2", (RvalueMatcher)new SetOperationOutputMatcher(3)))))));
    }
}

