/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjectIntoFilter;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestInlineProjectIntoFilter
extends BaseRuleTest {
    public TestInlineProjectIntoFilter() {
        super(new Plugin[0]);
    }

    @Test
    public void testInlineProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new SymbolReference("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("b"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b"))), PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("c")))), (PlanNode)p.project(Assignments.builder().put(a, (Expression)new IsNullPredicate((Expression)new SymbolReference("d"))).put(b, (Expression)new SymbolReference("b")).put(c, (Expression)new SymbolReference("c")).build(), (PlanNode)p.values(b, c, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c")), (Object)"a", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("d")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("c")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"d", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("d")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("b", "c", "d")))));
    }

    @Test
    public void testNoSimpleConjuncts() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testMultipleReferencesToConjunct() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("a"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)BooleanLiteral.FALSE_LITERAL)))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testInlineMultiple() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("b"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(0L)), (Symbol)p.symbol("b"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L))), (PlanNode)p.values(p.symbol("c"))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(0L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testInlinePartially() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("a"), (Object)new SymbolReference("b"))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(0L)), (Symbol)p.symbol("b"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L))), (PlanNode)p.values(p.symbol("c"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(0L))), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testTrivialProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new SymbolReference("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference("a")), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new SymbolReference("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference("b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter((Expression)new SymbolReference("corr"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }
}

