/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestInlineProjections
extends BaseRuleTest {
    private static final RowType MSG_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)));

    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("identity"), (Expression)new SymbolReference("symbol")).put(p.symbol("multi_complex_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("complex"), (Expression)new LongLiteral(1L))).put(p.symbol("multi_complex_2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("complex"), (Expression)new LongLiteral(2L))).put(p.symbol("multi_literal_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("literal"), (Expression)new LongLiteral(1L))).put(p.symbol("multi_literal_2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("literal"), (Expression)new LongLiteral(2L))).put(p.symbol("single_complex"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("complex_2"), (Expression)new LongLiteral(2L))).put(p.symbol("msg_xx"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("z"), (Expression)new LongLiteral(1L))).put(p.symbol("multi_symbol_reference"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("v"), (Expression)new SymbolReference("v"))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("symbol"), (Expression)new SymbolReference("x")).put(p.symbol("complex"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(2L))).put(p.symbol("literal"), (Expression)new LongLiteral(1L)).put(p.symbol("complex_2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(1L))).put(p.symbol("z"), (Expression)new SubscriptExpression((Expression)new SymbolReference("msg"), (Expression)new LongLiteral(1L))).put(p.symbol("v"), (Expression)new SymbolReference("x")).build(), (PlanNode)p.values(p.symbol("x"), p.symbol("msg", (Type)MSG_TYPE))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("x"))).put((Object)"out2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(1L)))).put((Object)"out3", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("y"), (Expression)new LongLiteral(2L)))).put((Object)"out4", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(1L)))).put((Object)"out5", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(1L), (Expression)new LongLiteral(2L)))).put((Object)"out6", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(2L)))).put((Object)"out8", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("z"), (Expression)new LongLiteral(1L)))).put((Object)"out10", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("x")))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("x")), (Object)"y", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(2L))), (Object)"z", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("msg"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"msg", (Object)1)))));
    }

    @Test
    public void testInlineEffectivelyLiteral() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("decimal_multiplication"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("decimal_literal"), (Expression)new SymbolReference("decimal_literal"))).put(p.symbol("decimal_addition"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("decimal_literal"), (Expression)new SymbolReference("decimal_literal"))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("decimal_literal", (Type)DecimalType.createDecimalType((int)8, (int)4)), (Expression)new Cast((Expression)new DecimalLiteral("12.5"), (Type)DecimalType.createDecimalType((int)8, (int)4))).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project(Map.of("decimal_multiplication", PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new Cast((Expression)new DecimalLiteral("12.5"), (Type)DecimalType.createDecimalType((int)8, (int)4)), (Expression)new Cast((Expression)new DecimalLiteral("12.5"), (Type)DecimalType.createDecimalType((int)8, (int)4)))), "decimal_addition", PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new Cast((Expression)new DecimalLiteral("12.5"), (Type)DecimalType.createDecimalType((int)8, (int)4)), (Expression)new Cast((Expression)new DecimalLiteral("12.5"), (Type)DecimalType.createDecimalType((int)8, (int)4))))), PlanMatchPattern.values(Map.of("x", 0))));
    }

    @Test
    public void testEliminatesIdentityProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("single_complex"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("complex"), (Expression)new LongLiteral(2L))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(1L))).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("x"), (Expression)new LongLiteral(1L)), (Expression)new LongLiteral(2L)))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))));
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)new SymbolReference("value")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x"), p.symbol("y")}), (PlanNode)p.values(p.symbol("x"), p.symbol("y"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("x"))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)1))));
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value_1")}), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("value_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("value"), (Expression)new LongLiteral(1L))), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
    }
}

