/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergePatternRecognitionNodes;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestMergePatternRecognitionNodes
extends BaseRuleTest {
    private static final WindowNode.Frame ROWS_CURRENT_TO_UNBOUNDED = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());

    public TestMergePatternRecognitionNodes() {
        super(new Plugin[0]);
    }

    @Test
    public void testSpecificationsDoNotMatch() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.FALSE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.FALSE_LITERAL).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        QualifiedName count = this.tester().getMetadata().resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})).toQualifiedName();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)new SymbolReference("a"))), (Expression)new LongLiteral(5L))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(count, (List)ImmutableList.of((Object)new SymbolReference("b"))), (Expression)new LongLiteral(5L))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputs() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("measure"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer()), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("function"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("function").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("measure").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer()), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputsWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("measure"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("measure")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer()), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("renamed"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("renamed"), (Expression)new SymbolReference("measure")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer()), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("projected"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("projected"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("measure"))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer()), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testMergeWithoutProject() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).addWindowFunction(p.symbol("parent_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipToPosition.LAST, (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).addWindowFunction(p.symbol("child_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("b").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipToPosition.LAST, (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"), p.symbol("d"))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).addFunction("parent_function", PlanMatchPattern.windowFunction("lag", (List<String>)ImmutableList.of((Object)"a"), WindowNode.Frame.DEFAULT_FRAME)).addFunction("child_function", PlanMatchPattern.windowFunction("lag", (List<String>)ImmutableList.of((Object)"b"), WindowNode.Frame.DEFAULT_FRAME)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_CURRENT_TO_UNBOUNDED).skipTo(SkipToPosition.LAST, new IrLabel("X")).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.values("a", "b", "c", "d")));
    }

    @Test
    public void testMergeWithoutProjectAndPruneOutputs() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure"))), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.values("a", "b", "c"))));
    }

    @Test
    public void testMergeWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference("a"), (Symbol)p.symbol("expression"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expression"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("child_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")))), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.values("a", "b")))));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new SymbolReference("a"), (Symbol)p.symbol("expression"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")), (Expression)new SymbolReference("child_measure"))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expression"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("child_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")), (Expression)new SymbolReference("child_measure")))), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("expression_1"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), (Expression)new SymbolReference("a")).put(p.symbol("expression_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))).put(p.symbol("expression_2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expression_1")), (Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expression_2"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))).put((Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b"))).put((Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure"))).put((Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("child_measure"))).put((Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("expression_1"))).put((Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")))).buildOrThrow(), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("expression_1"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")))), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testOneRowPerMatchMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("parent_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("expression_1"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), (Expression)new SymbolReference("a")).put(p.symbol("child_measure"), (Expression)new SymbolReference("child_measure")).put(p.symbol("expression_1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("a"))).put(p.symbol("expression_2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("a"))).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("child_measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("child_measure")), (Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("a")))), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("expression_1"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol("b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("a")))), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testMergeWithAggregation() {
        ResolvedFunction count = this.tester().getMetadata().resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"c", (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"c", (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()))).source((PlanNode)p.values(p.symbol("a"))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("c"), (Expression)new LongLiteral(5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"c", (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()))), PlanMatchPattern.values("a")));
    }
}

