/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PrunePatternRecognitionSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestPrunePatternRecognitionSourceColumns
extends BaseRuleTest {
    public TestPrunePatternRecognitionSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneUnreferencedInput() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("a"))));
    }

    @Test
    public void testDoNotPruneInputsWithAllRowsPerMatch() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPrunePartitionByInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneOrderByInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("a")), (Map)ImmutableMap.of((Object)p.symbol("a"), (Object)SortOrder.ASC_NULLS_LAST))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneMeasureInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), (Expression)new SymbolReference("pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneVariableDefinitionInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("pointer"), (Expression)new LongLiteral(0L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol("a")))).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }
}

