/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneSemiJoinFilteringSourceColumns
extends BaseRuleTest {
    public TestPruneSemiJoinFilteringSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllColumnsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneSemiJoinFilteringSourceColumns()).on(p -> TestPruneSemiJoinFilteringSourceColumns.buildSemiJoin(p, symbol -> true)).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.values("leftKey"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightKey", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("rightKey")), (Object)"rightKeyHash", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("rightKeyHash"))), PlanMatchPattern.values("rightKey", "rightKeyHash", "rightValue"))));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule<?>)new PruneSemiJoinFilteringSourceColumns()).on(p -> TestPruneSemiJoinFilteringSourceColumns.buildSemiJoin(p, symbol -> !symbol.getName().equals("rightValue"))).doesNotFire();
    }

    private static PlanNode buildSemiJoin(PlanBuilder p, Predicate<Symbol> filteringSourceSymbolFilter) {
        Symbol match = p.symbol("match");
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        Symbol rightKeyHash = p.symbol("rightKeyHash");
        Symbol rightValue = p.symbol("rightValue");
        ImmutableList filteringSourceSymbols = ImmutableList.of((Object)rightKey, (Object)rightKeyHash, (Object)rightValue);
        return p.semiJoin(leftKey, rightKey, match, Optional.empty(), Optional.of(rightKeyHash), (PlanNode)p.values(leftKey), (PlanNode)p.values((List)filteringSourceSymbols.stream().filter(filteringSourceSymbolFilter).collect(ImmutableList.toImmutableList()), (List<List<Expression>>)ImmutableList.of()));
    }
}

