/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableExecuteSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneTableExecuteSourceColumns
extends BaseRuleTest {
    public TestPruneTableExecuteSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableExecuteSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.tableExecute((List<Symbol>)ImmutableList.of((Object)a), (List<String>)ImmutableList.of((Object)"column_a"), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.tableExecute((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of((Object)"column_a"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableExecuteSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.tableExecute((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<String>)ImmutableList.of((Object)"column_a", (Object)"column_b"), (PlanNode)p.values(a, b));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPrunePartitioningSchemeSymbols() {
        this.tester().assertThat((Rule<?>)new PruneTableExecuteSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol partition = p.symbol("partition");
            Symbol hash = p.symbol("hash");
            return p.tableExecute((List<Symbol>)ImmutableList.of((Object)a), (List<String>)ImmutableList.of((Object)"column_a"), Optional.of(p.partitioningScheme((List<Symbol>)ImmutableList.of((Object)partition, (Object)hash), (List<Symbol>)ImmutableList.of((Object)partition), hash)), (PlanNode)p.values(a, partition, hash));
        }).doesNotFire();
    }
}

