/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneUnionSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneUnionSourceColumns
extends BaseRuleTest {
    public TestPruneUnionSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneOneChild() {
        this.tester().assertThat((Rule<?>)new PruneUnionSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)c, (Object)output, (Object)d), (List<PlanNode>)ImmutableList.of((Object)p.values(a, b), (Object)p.values(c), (Object)p.values(d)));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))), PlanMatchPattern.values("a", "b")), PlanMatchPattern.values("c"), PlanMatchPattern.values("d")));
    }

    @Test
    public void testPruneAllChildren() {
        this.tester().assertThat((Rule<?>)new PruneUnionSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)c, (Object)output, (Object)e), (List<PlanNode>)ImmutableList.of((Object)p.values(a, b), (Object)p.values(c, d), (Object)p.values(e, f)));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))), PlanMatchPattern.values("a", "b")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c", "d")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"e", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("e"))), PlanMatchPattern.values("e", "f"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnionSourceColumns()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)output, (Object)a, (Object)output, (Object)b, (Object)output, (Object)c), (List<PlanNode>)ImmutableList.of((Object)p.values(a), (Object)p.values(b), (Object)p.values(c)));
        }).doesNotFire();
    }
}

