/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushDownProjectionsFromPatternRecognition;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestPushDownProjectionsFromPatternRecognition
extends BaseRuleTest {
    private static final QualifiedName MAX_BY = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})).toQualifiedName();

    public TestPushDownProjectionsFromPatternRecognition() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoAggregations() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)BooleanLiteral.TRUE_LITERAL).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushRuntimeEvaluatedArguments() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(1L), (Expression)new FunctionCall(QualifiedName.of((String)"match_number"), (List)ImmutableList.of())), (Object)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("x"), (Object)new FunctionCall(QualifiedName.of((String)"classifier"), (List)ImmutableList.of()))))), (Expression)new LongLiteral(5L))).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushSymbolReferences() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("b"))), (Expression)new LongLiteral(5L))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testPreProjectArguments() {
        ResolvedFunction maxBy = this.tester().getMetadata().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("agg"), (Expression)new LongLiteral(5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"agg", (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L))), Optional.empty(), Optional.empty()))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("agg"), (Expression)new LongLiteral(5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"agg", (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new SymbolReference("expr_1"), (Object)new SymbolReference("expr_2")), Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L))), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L))), (Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b"))), PlanMatchPattern.values("a", "b"))));
    }
}

