/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushPredicateThroughProjectIntoRowNumber
extends BaseRuleTest {
    public TestPushPredicateThroughProjectIntoRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void testRowNumberSymbolPruned() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(1L)), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNoUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNonPositiveUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "-10")))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.values("a", "row_number"));
    }

    @Test
    public void testPredicateNotSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.empty(), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number"))), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(4)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testPredicateNotSatisfiedAndMaxRowCountNotUpdated() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testPredicateSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number"))), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "3")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(5), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number"))), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher())));
    }

    @Test
    public void testPredicatePartiallySatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber, a}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number")), (Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "5")), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("row_number"), (Expression)new LongLiteral(2L)), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of(), Optional.of(3), rowNumber, (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("row_number"), (Expression)new LongLiteral(2L)), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "0")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("row_number"))), PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.of(3)), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }
}

