/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughUnion;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushProjectionThroughUnion
extends BaseRuleTest {
    private static final RowType ROW_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushProjectionThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new LongLiteral(3L)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testTrivialProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> {
            Symbol left = p.symbol("left");
            Symbol right = p.symbol("right");
            Symbol unioned = p.symbol("unioned");
            Symbol renamed = p.symbol("renamed");
            return p.project(Assignments.of((Symbol)renamed, (Expression)unioned.toSymbolReference()), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)unioned, (Object)left).put((Object)unioned, (Object)right).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(left), (Object)p.values(right))));
        }).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d", (Type)ROW_TYPE);
            Symbol cTimes3 = p.symbol("c_times_3");
            Symbol dX = p.symbol("d_x");
            Symbol z = p.symbol("z", (Type)ROW_TYPE);
            Symbol w = p.symbol("w", (Type)ROW_TYPE);
            return p.project(Assignments.of((Symbol)cTimes3, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)c.toSymbolReference(), (Expression)new LongLiteral(3L)), (Symbol)dX, (Expression)new SubscriptExpression((Expression)new SymbolReference("d"), (Expression)new LongLiteral(1L))), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).put((Object)d, (Object)z).put((Object)d, (Object)w).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a, z), (Object)p.values(b, w))));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_times_3", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(3L))), (Object)"z_x", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("z"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"z"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_times_3", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(3L))), (Object)"w_x", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("w"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b", (Object)"w")))).withNumberOfOutputColumns(2).withAlias("a_times_3").withAlias("b_times_3").withAlias("z_x").withAlias("w_x"));
    }
}

