/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushdownFilterIntoRowNumber
extends BaseRuleTest {
    public TestPushdownFilterIntoRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void testSourceRowNumber() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(100L), (Type)BigintType.BIGINT)), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(99)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(100L), (Type)BigintType.BIGINT)), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(10)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Cast((Expression)new LongLiteral(3L), (Type)BigintType.BIGINT), (Expression)new SymbolReference("row_number_1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)BigintType.BIGINT)))), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Cast((Expression)new LongLiteral(3L), (Type)BigintType.BIGINT), (Expression)new SymbolReference("row_number_1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)BigintType.BIGINT)))), PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(4)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new RowNumberSymbolMatcher())));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)BigintType.BIGINT)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")))), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(10), rowNumberSymbol, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1")), PlanMatchPattern.rowNumber(rowNumber -> rowNumber.maxRowCountPerPartition(Optional.of(4)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new RowNumberSymbolMatcher())));
    }

    @Test
    public void testNoOutputsThroughRowNumber() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(-100L), (Type)BigintType.BIGINT)), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"))));
        }).matches(PlanMatchPattern.values("a", "row_number_1"));
    }

    @Test
    public void testDoNotFire() {
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("not_row_number"), (Expression)new Cast((Expression)new LongLiteral(100L), (Type)BigintType.BIGINT)), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"), p.symbol("not_row_number"))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(100L), (Type)BigintType.BIGINT)), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), Optional.empty(), rowNumberSymbol, (PlanNode)p.values(p.symbol("a"))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoRowNumber(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Cast((Expression)new LongLiteral(3L), (Type)BigintType.BIGINT), (Expression)new SymbolReference("row_number_1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("row_number_1"), (Expression)new Cast((Expression)new LongLiteral(5L), (Type)BigintType.BIGINT)))), (PlanNode)p.rowNumber((List<Symbol>)ImmutableList.of((Object)a), Optional.of(4), rowNumberSymbol, (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

