/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTopN;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantTopN
extends BaseRuleTest {
    public TestRemoveRedundantTopN() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTopN()).on(p -> p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.tester().assertThat((Rule<?>)new RemoveRedundantTopN()).on(p -> p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(5L)), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L), (Object)new LongLiteral(10L)), (Object)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(11L))))))).matches(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testZeroTopN() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTopN()).on(p -> p.topN(0L, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(5L)), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral(1L), (Object)new LongLiteral(10L)), (Object)ImmutableList.of((Object)new LongLiteral(2L), (Object)new LongLiteral(11L))))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantTopN()).on(p -> p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(20, p.symbol("foo")))))).doesNotFire();
    }
}

